/*
 * Decompiled with CFR 0.152.
 */
package b.events;

import b.PhantomClient;
import b.events.Event;
import b.events.EventHandler;
import b.events.Listener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventManager {
    private PhantomClient Client;
    private Map<Class, List<Map.Entry<Listener, List<Method>>>> RegistryMap = new HashMap<Class, List<Map.Entry<Listener, List<Method>>>>();

    public EventManager(PhantomClient Client) {
        this.Client = Client;
    }

    public void callEvent(Event event) {
        if (!this.RegistryMap.containsKey(event.getClass())) {
            return;
        }
        for (Map.Entry<Listener, List<Method>> s : this.RegistryMap.get(event.getClass())) {
            List<Method> Methods = s.getValue();
            Listener Listener2 = s.getKey();
            if (Methods == null) continue;
            for (Method method : Methods) {
                try {
                    method.invoke((Object)Listener2, event);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void registerEvents(Listener Listener2) {
        Class<?> clazz = Listener2.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(EventHandler.class) && method.getParameters().length == 1) {
                try {
                    Class<?> type = method.getParameters()[0].getType();
                    List<Object> m = new ArrayList();
                    if (this.RegistryMap.containsKey(type)) {
                        m = this.RegistryMap.get(type);
                    }
                    if (m.contains(Listener2)) {
                        for (Map.Entry entry : m) {
                            if (!((Listener)entry.getKey()).equals(Listener2)) continue;
                            ((List)entry.getValue()).add(method);
                        }
                    } else {
                        ArrayList<Method> arrayList = new ArrayList<Method>();
                        arrayList.add(method);
                        m.add(new AbstractMap.SimpleEntry(Listener2, arrayList));
                    }
                    this.RegistryMap.put(type, m);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void unregisterEvents(Listener listener) {
        this.RegistryMap.remove(listener);
    }

    public void unregisterAllEvents() {
        this.RegistryMap.clear();
    }
}

