/*
 * Decompiled with CFR 0.152.
 */
package b.friends;

import b.PhantomClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FriendManager {
    private PhantomClient Client;
    private List<String> Friends;

    public FriendManager(PhantomClient Client) {
        this.Client = Client;
        this.Friends = new ArrayList<String>();
        this.loadFriends();
    }

    public void addFriend(String Name) {
        this.Friends.add(Name);
        this.saveFriends();
    }

    public void removeFriend(String Name) {
        this.Friends.remove(Name);
        this.saveFriends();
    }

    public void removeFriends() {
        this.Friends.clear();
        this.saveFriends();
    }

    public boolean isFriend(String Name) {
        return this.Friends.contains(Name);
    }

    private File getFriendsFile() {
        File file;
        File dir = new File("phantom");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(file = new File(dir, "friends.properties")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public void loadFriends() {
        try {
            String Line2;
            FileReader fr = new FileReader(this.getFriendsFile());
            BufferedReader br = new BufferedReader(fr);
            while ((Line2 = br.readLine()) != null) {
                this.Friends.add(Line2);
            }
            br.close();
            fr.close();
        }
        catch (Exception exx) {
            exx.printStackTrace();
        }
    }

    public void saveFriends() {
        this.clearFriends();
        for (String name : this.Friends) {
            try {
                FileWriter fw = new FileWriter(this.getFriendsFile(), true);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(name);
                bw.newLine();
                bw.close();
                fw.close();
            }
            catch (Exception localException) {
                localException.printStackTrace();
            }
        }
    }

    private void clearFriends() {
        try {
            FileWriter fw = new FileWriter(this.getFriendsFile(), false);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("");
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

