/*
 * Decompiled with CFR 0.152.
 */
package b.gui;

import b.PhantomClient;
import b.events.EventHandler;
import b.events.Listener;
import b.events.events.Render2DEvent;
import b.events.events.TickEvent;
import b.gui.theme.PhantomTheme;
import b.mods.BoolValue;
import b.mods.Category;
import b.mods.Module;
import b.mods.Value;
import b.mods.Values;
import b.mods.other.Commands;
import b.util.UtilPing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import y.gui.AbstractGuiManager;
import y.gui.component.Button;
import y.gui.component.CheckButton;
import y.gui.component.Frame;
import y.gui.component.Label;
import y.gui.component.Slider;
import y.gui.component.basic.BasicButton;
import y.gui.component.basic.BasicCheckButton;
import y.gui.component.basic.BasicFrame;
import y.gui.component.basic.BasicLabel;
import y.gui.component.basic.BasicSlider;
import y.gui.layout.Constraint;
import y.gui.layout.GridLayoutManager;
import y.gui.listener.ButtonListener;
import y.gui.listener.SliderListener;
import y.gui.util.GuiManagerDisplayScreen;

public class GUIManager
extends AbstractGuiManager
implements Listener {
    private final AtomicBoolean setup;
    private PhantomClient Client;
    private Map<Category, ModuleFrame> categoryFrames = new HashMap<Category, ModuleFrame>();
    private List<Module> moduleSelected = new ArrayList<Module>();
    protected long lastMS = -1L;
    Label fpsLabel = null;
    Label pingLabel = null;
    Label xLabel = null;
    Label yLabel = null;
    Label zLabel = null;
    private ArrayListFrame arrayListFrame;

    public static float getScaleFactor() {
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution localRes = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
        int i = localRes.getScaleFactor();
        return (float)(i == 0 ? 0.5 : (i == 1 ? 2.0 : (i == 2 ? 1.0 : (i == 3 ? 0.66666 : (i == 4 ? 0.5 : 1.0)))));
    }

    private File getGuisFile() {
        File file;
        File dir = new File("phantom");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!(file = new File(dir, "gui.properties")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public void loadFrames() {
        try {
            String Line2;
            FileReader fr = new FileReader(this.getGuisFile());
            BufferedReader br = new BufferedReader(fr);
            while ((Line2 = br.readLine()) != null) {
                String[] args = Line2.split(":");
                String name = args[0];
                Frame frame = null;
                Frame[] frameArray = this.getFrames();
                int n = frameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Frame a = frameArray[n2];
                    if (name.equalsIgnoreCase(a.getTitle())) {
                        frame = a;
                    }
                    ++n2;
                }
                if (frame == null) continue;
                if (args.length != 5) {
                    this.clearFrames();
                    br.close();
                    fr.close();
                    return;
                }
                Integer X = Integer.parseInt(args[1]);
                Integer Y = Integer.parseInt(args[2]);
                Boolean minimized = Boolean.parseBoolean(args[3]);
                Boolean pinned = Boolean.parseBoolean(args[4]);
                frame.setX(X);
                frame.setY(Y);
                frame.setMinimized(minimized);
                frame.setPinned(pinned);
            }
            br.close();
            fr.close();
        }
        catch (Exception exx) {
            exx.printStackTrace();
        }
    }

    public void saveFrames() {
        this.clearFrames();
        Frame[] frameArray = this.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            try {
                FileWriter fw = new FileWriter(this.getGuisFile(), true);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(String.valueOf(frame.getTitle()) + ":" + frame.getX() + ":" + frame.getY() + ":" + String.valueOf(String.valueOf(frame.isMinimized()) + ":" + String.valueOf(frame.isPinned())));
                bw.newLine();
                bw.close();
                fw.close();
            }
            catch (Exception localException) {
                localException.printStackTrace();
            }
            ++n2;
        }
    }

    private void clearFrames() {
        try {
            FileWriter fw = new FileWriter(this.getGuisFile(), false);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("");
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GUIManager(PhantomClient Client) {
        this.setup = new AtomicBoolean();
        this.setTheme(new PhantomTheme());
        this.Client = Client;
        this.Client.getEventManager().registerEvents(this);
        Minecraft mc = Minecraft.getMinecraft();
    }

    @EventHandler
    public void Render(Render2DEvent event) {
        this.update();
        if (Minecraft.getMinecraft().currentScreen instanceof GuiManagerDisplayScreen) {
            this.render();
        } else {
            this.renderPinned();
        }
        if (System.nanoTime() / 1000000L >= this.lastMS + 9001L) {
            this.saveFrames();
            this.lastMS = System.nanoTime() / 1000000L;
        }
    }

    @Override
    public void setup() {
        if (!this.setup.compareAndSet(false, true)) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        this.updateModuleFrames();
        this.createInfoFrame();
        this.createValuesFrame();
        this.createArrayListFrame();
        this.autoPosition();
        this.loadFrames();
        this.saveFrames();
    }

    private void createValuesFrame() {
        ValuesFrame frame = new ValuesFrame();
        frame.setTheme(this.getTheme());
        frame.setLayoutManager(new GridLayoutManager(1, 0));
        frame.setVisible(true);
        frame.setClosable(false);
        frame.setMinimized(true);
        Values target = this.Client.getModManager().Values;
        BasicCheckButton checkbutton = new BasicCheckButton("Weapon");
        checkbutton.setSelected(target.weapon);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.weapon = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        checkbutton = new BasicCheckButton("Invisible");
        checkbutton.setSelected(target.invisible);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.invisible = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        checkbutton = new BasicCheckButton("Players");
        checkbutton.setSelected(target.players);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.players = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        checkbutton = new BasicCheckButton("Mobs");
        checkbutton.setSelected(target.mobs);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.mobs = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        checkbutton = new BasicCheckButton("Animals");
        checkbutton.setSelected(target.animals);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.animals = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        checkbutton = new BasicCheckButton("Teams");
        checkbutton.setSelected(target.teams);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.teams = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        checkbutton = new BasicCheckButton("In Inventory");
        checkbutton.setSelected(target.inInventory);
        checkbutton.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                if (button instanceof CheckButton) {
                    CheckButton check = (CheckButton)button;
                    Values target2 = PhantomClient.Instance.getModManager().Values;
                    target2.inInventory = check.isSelected();
                    target2.save();
                }
            }

            @Override
            public void onButtonRightPress(Button button) {
            }
        });
        frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL);
        this.addFrame(frame);
    }

    private void createInfoFrame() {
        InfoFrame frame = new InfoFrame();
        frame.setTheme(this.getTheme());
        frame.setLayoutManager(new GridLayoutManager(1, 0));
        frame.setVisible(true);
        frame.setClosable(false);
        frame.setMinimized(true);
        Minecraft mc = Minecraft.getMinecraft();
        frame.add(new BasicLabel("Version: " + PhantomClient.Version), GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.fpsLabel = new BasicLabel("FPS: " + Minecraft.debugFPS);
        frame.add(this.fpsLabel, GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.pingLabel = new BasicLabel("Ping: " + UtilPing.getPing());
        frame.add(this.pingLabel, GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.xLabel = new BasicLabel("X: 0");
        frame.add(this.xLabel, GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.yLabel = new BasicLabel("Y: 0");
        frame.add(this.yLabel, GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.zLabel = new BasicLabel("Z: 0");
        frame.add(this.zLabel, GridLayoutManager.HorizontalGridConstraint.CENTER);
        this.addFrame(frame);
    }

    @EventHandler
    public void Tick(TickEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        if (this.fpsLabel != null) {
            this.fpsLabel.setText("FPS: " + Minecraft.debugFPS);
        }
        if (this.pingLabel != null) {
            this.pingLabel.setText("Ping: " + UtilPing.getPing());
        }
        if (mc.thePlayer == null) {
            return;
        }
        if (this.xLabel != null) {
            this.xLabel.setText("X: " + Math.round(mc.thePlayer.posX));
        }
        if (this.yLabel != null) {
            this.yLabel.setText("Y: " + Math.round(mc.thePlayer.posY));
        }
        if (this.yLabel != null) {
            this.zLabel.setText("Z: " + Math.round(mc.thePlayer.posZ));
        }
    }

    private void createArrayListFrame() {
        this.arrayListFrame = new ArrayListFrame();
        this.arrayListFrame.setTheme(this.getTheme());
        this.arrayListFrame.setLayoutManager(new GridLayoutManager(1, 0));
        this.arrayListFrame.setVisible(true);
        this.arrayListFrame.setClosable(false);
        this.arrayListFrame.setMinimized(true);
        this.addFrame(this.arrayListFrame);
    }

    @EventHandler
    public void renderArrayList(Render2DEvent event) {
        if (this.arrayListFrame == null) {
            return;
        }
        if (Minecraft.getMinecraft().currentScreen == null && !this.arrayListFrame.isPinned()) {
            return;
        }
        if (Minecraft.getMinecraft().currentScreen != null && !(Minecraft.getMinecraft().currentScreen instanceof GuiManagerDisplayScreen) && !this.arrayListFrame.isPinned()) {
            return;
        }
        GL11.glPushMatrix();
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (Module module : PhantomClient.Instance.getModManager().Modules) {
            if (!module.isToggled() || module.getClass() == Commands.class) continue;
            moduleNames.add(module.getName());
        }
        Collections.sort(moduleNames);
        GL11.glTranslated((double)this.arrayListFrame.getX(), (double)this.arrayListFrame.getY(), (double)0.0);
        int i = 0;
        while (i < moduleNames.size()) {
            String moduleName = (String)moduleNames.get(i);
            Module module = PhantomClient.Instance.getModManager().getModuleByName(moduleName);
            Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(module.getName(), 5, 18 + 10 * i, module.color);
            ++i;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderPinned() {
        Frame[] frames = this.getFrames();
        int i = frames.length - 1;
        while (i >= 0) {
            if (frames[i].isPinned() && frames[i] != this.arrayListFrame) {
                frames[i].render();
            }
            --i;
        }
    }

    @Override
    public void render() {
        super.render();
    }

    private Frame createModuleFrame(Module module) {
        ModuleFrame frame = this.categoryFrames.get((Object)module.getCategory());
        if (frame == null) {
            frame = new ModuleFrame(module.getCategory());
            frame.setTheme(this.getTheme());
            frame.setLayoutManager(new GridLayoutManager(1, 0));
            frame.setVisible(true);
            frame.setClosable(false);
            frame.setMinimized(true);
            this.addFrame(frame);
            this.categoryFrames.put(module.getCategory(), frame);
        }
        final Module updateModule = module;
        ModuleButton button = new ModuleButton(this, module){

            @Override
            public void update() {
                this.setForegroundColor(Color.WHITE);
                this.setBackgroundColor(updateModule.isToggled() ? new Color(54, 96, 212) : new Color(0, 0, 0, 0));
            }
        };
        button.addButtonListener(new ButtonListener(){

            @Override
            public void onButtonPress(Button button) {
                GUIManager.this.updateModuleFrames();
                updateModule.Toggle();
                button.setForegroundColor(Color.WHITE);
                button.setBackgroundColor(updateModule.isToggled() ? new Color(54, 96, 212) : new Color(0, 0, 0, 0));
            }

            @Override
            public void onButtonRightPress(Button button) {
                if (updateModule.getValues().size() <= 0) {
                    return;
                }
                if (GUIManager.this.moduleSelected.contains(updateModule)) {
                    GUIManager.this.moduleSelected.remove(updateModule);
                } else {
                    GUIManager.this.moduleSelected.add(updateModule);
                }
                GUIManager.this.updateModuleFrames();
            }
        });
        frame.add(button, new Constraint[0]);
        if (module.getValues().size() > 0 && this.moduleSelected.contains(module)) {
            for (final Value value : module.getValues()) {
                if (!(value instanceof BoolValue)) {
                    BasicSlider slider = new BasicSlider(value.getName());
                    slider.setValueDisplay(value.getDisplay());
                    slider.setMaximumValue(value.getMax());
                    slider.setMinimumValue(value.getMin());
                    slider.setIncrement(value.getIncrement());
                    slider.setValue(value.getValue());
                    slider.setEnabled(true);
                    slider.setSlideColor(new Color(54, 96, 212));
                    slider.addSliderListener(new SliderListener(){

                        @Override
                        public void onSliderValueChanged(Slider slider) {
                            value.setValue(slider.getValue());
                            updateModule.saveValues();
                        }
                    });
                    frame.add(slider, GridLayoutManager.HorizontalGridConstraint.FILL, GridLayoutManager.VerticalGridConstraint.TOP);
                    continue;
                }
                final BoolValue bvalue = (BoolValue)value;
                BasicCheckButton checkbutton = new BasicCheckButton(value.getName());
                checkbutton.setSelected(bvalue.getBoolean());
                checkbutton.addButtonListener(new ButtonListener(){

                    @Override
                    public void onButtonPress(Button button) {
                        if (button instanceof CheckButton) {
                            CheckButton check = (CheckButton)button;
                            bvalue.setBoolean(check.isSelected());
                            updateModule.saveValues();
                        }
                    }

                    @Override
                    public void onButtonRightPress(Button button) {
                    }
                });
                frame.add(checkbutton, GridLayoutManager.HorizontalGridConstraint.FILL, GridLayoutManager.VerticalGridConstraint.CENTER);
            }
        }
        return frame;
    }

    public void updateModuleFrames() {
        HashMap frames = (HashMap)((HashMap)this.categoryFrames).clone();
        for (ModuleFrame frame : this.categoryFrames.values()) {
            this.removeFrame(frame);
        }
        this.categoryFrames.clear();
        for (Module module : this.Client.getModManager().Modules) {
            Frame frame = this.createModuleFrame(module);
            if (frames.get((Object)module.getCategory()) == null) continue;
            Frame theotherframe = (Frame)frames.get((Object)module.getCategory());
            frame.setX(theotherframe.getX());
            frame.setY(theotherframe.getY());
            frame.setMinimized(theotherframe.isMinimized());
        }
        this.resizeComponents();
    }

    @Override
    protected void resizeComponents() {
        this.recalculateSizes();
    }

    private Dimension recalculateSizes() {
        Frame frame;
        Frame[] frames = this.getFrames();
        int maxWidth = 0;
        int maxHeight = 0;
        Frame[] arrayOfFrame1 = frames;
        int j = frames.length;
        int i = 0;
        while (i < j) {
            frame = arrayOfFrame1[i];
            Dimension defaultDimension = frame.getTheme().getUIForComponent(frame).getDefaultSize(frame);
            maxWidth = Math.max(maxWidth, defaultDimension.width);
            frame.setHeight(defaultDimension.height);
            if (frame.isMinimized()) {
                Rectangle[] arrayOfRectangle = frame.getTheme().getUIForComponent(frame).getInteractableRegions(frame);
                int m = arrayOfRectangle.length;
                int k = 0;
                while (k < m) {
                    Rectangle area = arrayOfRectangle[k];
                    maxHeight = Math.max(maxHeight, area.height);
                    ++k;
                }
            } else {
                maxHeight = Math.max(maxHeight, defaultDimension.height);
            }
            ++i;
        }
        arrayOfFrame1 = frames;
        j = frames.length;
        i = 0;
        while (i < j) {
            frame = arrayOfFrame1[i];
            frame.setWidth(maxWidth);
            frame.layoutChildren();
            ++i;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private void autoPosition() {
        this.resizeComponents();
        Minecraft minecraft = Minecraft.getMinecraft();
        Dimension maxSize = this.recalculateSizes();
        int offsetX = 5;
        int offsetY = 5;
        int scale = minecraft.gameSettings.guiScale;
        if (scale == 0) {
            scale = 1000;
        }
        int scaleFactor = 0;
        while (scaleFactor < scale && minecraft.displayWidth / (scaleFactor + 1) >= 320 && minecraft.displayHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        Frame[] arrayOfFrame = this.getFrames();
        int j = arrayOfFrame.length;
        int i = 0;
        while (i < j) {
            Frame frame = arrayOfFrame[i];
            frame.setX(offsetX);
            frame.setY(offsetY);
            if ((offsetX += maxSize.width + 5) + maxSize.width + 5 > minecraft.displayWidth / scaleFactor) {
                offsetX = 5;
                offsetY += maxSize.height + 5;
            }
            ++i;
        }
    }

    public class ArrayListFrame
    extends BasicFrame {
        public ArrayListFrame() {
            super("Array List");
        }
    }

    public class InfoFrame
    extends BasicFrame {
        public InfoFrame() {
            super("Info");
        }
    }

    public class ModuleButton
    extends BasicButton {
        private Module module;

        private ModuleButton(Module module) {
            super(module.getName());
            this.module = module;
        }

        public Module getModule() {
            return this.module;
        }
    }

    public class ModuleFrame
    extends BasicFrame {
        private Category category;

        private ModuleFrame(Category category) {
            super(String.valueOf(Character.toUpperCase(category.name().toLowerCase().charAt(0))) + category.name().toLowerCase().substring(1));
            this.category = category;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    public class ValuesFrame
    extends BasicFrame {
        public ValuesFrame() {
            super("Values");
        }
    }
}

