/*
 * Decompiled with CFR 0.152.
 */
package b.gui.theme;

import b.gui.GUIManager;
import b.gui.theme.PhantomTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import y.gui.component.Button;
import y.gui.component.Container;
import y.gui.theme.AbstractComponentUI;
import y.gui.util.RenderUtil;

public class PhantomButtonUI
extends AbstractComponentUI<Button> {
    private final PhantomTheme theme;

    public PhantomButtonUI(PhantomTheme theme) {
        super(Button.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(54, 96, 212);
    }

    @Override
    protected void renderComponent(Button button) {
        GUIManager.ModuleButton mbutton;
        this.translateComponent(button, false);
        Rectangle area = button.getArea();
        area.width = button.getParent().getWidth() - 4;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        RenderUtil.setColor(button.getBackgroundColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        RenderUtil.setColor(new Color(0, 0, 0, 255));
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = button.getParent();
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        if (area.contains(mouse)) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.5f : 0.3f));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)area.height);
            GL11.glVertex2d((double)0.0, (double)area.height);
            GL11.glEnd();
        }
        String text = button.getText();
        this.theme.getFontRenderer().drawString(text, area.width / 2 - this.theme.getFontRenderer().getStringWidth(text) / 2, area.height / 2 - this.theme.getFontRenderer().FONT_HEIGHT / 2, RenderUtil.toRGBA(button.getForegroundColor()));
        if (button instanceof GUIManager.ModuleButton && (mbutton = (GUIManager.ModuleButton)button).getModule().getValues().size() > 0) {
            this.theme.getFontRenderer().drawString("...", area.width - 10 - this.theme.getFontRenderer().getStringWidth("...") / 2, area.height / 2 - this.theme.getFontRenderer().FONT_HEIGHT / 2, RenderUtil.toRGBA(button.getForegroundColor()));
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.translateComponent(button, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(Button component) {
        return new Dimension(this.theme.getFontRenderer().getStringWidth(component.getText()) + 37, this.theme.getFontRenderer().FONT_HEIGHT + 7);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Button component) {
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), component.getHeight())};
    }

    @Override
    protected void handleComponentInteraction(Button component, Point location, int button) {
        if (location.x <= component.getWidth() && location.y <= component.getHeight()) {
            if (button == 0) {
                component.press();
            } else if (button == 1) {
                component.rightpress();
            }
        }
    }
}

