/*
 * Decompiled with CFR 0.152.
 */
package b.gui.theme;

import b.gui.theme.PhantomTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import y.gui.component.Container;
import y.gui.component.Slider;
import y.gui.theme.AbstractComponentUI;
import y.gui.util.RenderUtil;

public class PhantomSliderUI
extends AbstractComponentUI<Slider> {
    private PhantomTheme theme;

    public PhantomSliderUI(PhantomTheme theme) {
        super(Slider.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = Color.CYAN;
    }

    @Override
    protected void renderComponent(Slider component) {
        this.translateComponent(component, false);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        Rectangle area = component.getArea();
        int fontSize = this.theme.getFontRenderer().FONT_HEIGHT;
        FontRenderer fontRenderer = this.theme.getFontRenderer();
        fontRenderer.drawString(component.getText(), 0, 0, component.getForegroundColor().getRGB());
        String content = null;
        switch (component.getValueDisplay()) {
            case DECIMAL: {
                DecimalFormat df = new DecimalFormat("#.####");
                df.setRoundingMode(RoundingMode.FLOOR);
                content = df.format(component.getValue());
                break;
            }
            case INTEGER: {
                content = String.format("%,d", Math.round(component.getValue()));
                break;
            }
            case PERCENTAGE: {
                int percent = (int)Math.round((component.getValue() - component.getMinimumValue()) / (component.getMaximumValue() - component.getMinimumValue()) * 100.0);
                content = String.format("%d%%", percent);
                break;
            }
            case NONE: {
                content = String.valueOf(component.getValue());
            }
        }
        if (content != null) {
            String suffix = component.getContentSuffix();
            if (suffix != null && !suffix.trim().isEmpty()) {
                content = content.concat(" ").concat(suffix);
            }
            fontRenderer.drawString(content, component.getWidth() - fontRenderer.getStringWidth(content), 0, component.getForegroundColor().getRGB());
        }
        GL11.glDisable((int)3553);
        RenderUtil.setColor(component.getSlideColor());
        GL11.glLineWidth((float)0.9f);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)0.0, (double)((double)fontSize + 2.0));
        GL11.glVertex2d((double)area.width, (double)((double)fontSize + 2.0));
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        double sliderPercentage = (component.getValue() - component.getMinimumValue()) / (component.getMaximumValue() - component.getMinimumValue());
        RenderUtil.setColor(component.getSlideColor() == null ? Color.BLACK : component.getSlideColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)((double)fontSize + 2.0));
        GL11.glVertex2d((double)((double)area.width * sliderPercentage), (double)((double)fontSize + 2.0));
        GL11.glVertex2d((double)((double)area.width * sliderPercentage), (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        this.translateComponent(component, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(Slider component) {
        return new Dimension(82, 6 + this.theme.getFontRenderer().FONT_HEIGHT);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Slider component) {
        return new Rectangle[]{new Rectangle(0, this.theme.getFontRenderer().FONT_HEIGHT + 2, component.getWidth(), component.getHeight() - this.theme.getFontRenderer().FONT_HEIGHT)};
    }

    @Override
    protected void handleComponentInteraction(Slider component, Point location, int button) {
        if (this.getInteractableComponentRegions(component)[0].contains(location) && button == 0) {
            if (Mouse.isButtonDown((int)button) && !component.isValueChanging()) {
                component.setValueChanging(true);
            } else if (!Mouse.isButtonDown((int)button) && component.isValueChanging()) {
                component.setValueChanging(false);
            }
        }
    }

    @Override
    protected void handleComponentUpdate(Slider component) {
        if (component.isValueChanging()) {
            double percent;
            if (!Mouse.isButtonDown((int)0)) {
                component.setValueChanging(false);
                return;
            }
            Point mouse = RenderUtil.calculateMouseLocation();
            Container parent = component.getParent();
            if (parent != null) {
                mouse.translate(-parent.getX(), -parent.getY());
            }
            if ((percent = (double)mouse.x / (double)component.getWidth()) < 0.0) {
                percent = 0.0;
            }
            double value = component.getMinimumValue() + percent * (component.getMaximumValue() - component.getMinimumValue());
            double avalue = component.getIncrement() * Math.floor(Math.abs(value / component.getIncrement()));
            component.setValue(avalue);
        }
    }
}

