/*
 * Decompiled with CFR 0.152.
 */
package b.mods;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.scoreboard.ScorePlayerTeam;

public class Values {
    public boolean players = true;
    public boolean mobs = true;
    public boolean animals = false;
    public boolean weapon = true;
    public boolean teams = true;
    public boolean invisible = false;
    public boolean inInventory = false;

    public Values() {
        this.load();
        this.save();
    }

    public boolean isTargetValid(Entity target) {
        Minecraft mc;
        if (target.isInvisible() && !this.invisible) {
            return false;
        }
        if (!this.inInventory) {
            mc = Minecraft.getMinecraft();
            if (mc.currentScreen != null) {
                return false;
            }
        }
        if (target instanceof EntityMob) {
            if (!this.mobs) {
                return false;
            }
        } else if (target instanceof EntityAnimal) {
            if (!this.animals) {
                return false;
            }
        } else if (target instanceof EntityPlayer) {
            if (this.teams) {
                ScorePlayerTeam playerteam;
                mc = Minecraft.getMinecraft();
                EntityPlayer player = (EntityPlayer)target;
                if (mc.thePlayer.getTeam() != null && (playerteam = (ScorePlayerTeam)mc.thePlayer.getTeam()).getMembershipCollection().contains(player.getGameProfile().getName())) {
                    return false;
                }
            }
            if (!this.players) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean holdWeapon() {
        if (!this.weapon) {
            return true;
        }
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.thePlayer.getCurrentEquippedItem() == null) {
            return false;
        }
        return mc.thePlayer.getCurrentEquippedItem().getItem() instanceof ItemSword || mc.thePlayer.getCurrentEquippedItem().getItem() instanceof ItemTool;
    }

    private File getTargetFile() {
        File file;
        File dir = new File("phantom");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir, "target.properties")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public void load() {
        try {
            String Line2;
            FileReader fr = new FileReader(this.getTargetFile());
            BufferedReader br = new BufferedReader(fr);
            while ((Line2 = br.readLine()) != null) {
                String[] args = Line2.split(":");
                String name = args[0];
                boolean value = Boolean.parseBoolean(args[1]);
                if (name.equalsIgnoreCase("weapon")) {
                    this.weapon = value;
                    continue;
                }
                if (name.equalsIgnoreCase("invisible")) {
                    this.invisible = value;
                    continue;
                }
                if (name.equalsIgnoreCase("mobs")) {
                    this.mobs = value;
                    continue;
                }
                if (name.equalsIgnoreCase("animals")) {
                    this.animals = value;
                    continue;
                }
                if (name.equalsIgnoreCase("players")) {
                    this.players = value;
                    continue;
                }
                if (name.equalsIgnoreCase("teams")) {
                    this.teams = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("inInventory")) continue;
                this.inInventory = value;
            }
            br.close();
            fr.close();
        }
        catch (Exception exx) {
            exx.printStackTrace();
        }
    }

    public void save() {
        try {
            FileWriter fw = new FileWriter(this.getTargetFile(), false);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("weapon:" + this.weapon);
            bw.newLine();
            bw.write("invisible:" + this.invisible);
            bw.newLine();
            bw.write("players:" + this.players);
            bw.newLine();
            bw.write("mobs:" + this.mobs);
            bw.newLine();
            bw.write("animals:" + this.animals);
            bw.newLine();
            bw.write("teams:" + this.teams);
            bw.newLine();
            bw.write("inInventory:" + this.inInventory);
            bw.close();
            fw.close();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }
}

