/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetHandlerLoginClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.login.client.C00PacketLoginStart;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiConnecting
extends GuiScreen {
    private static final AtomicInteger field_146372_a = new AtomicInteger(0);
    private static final Logger logger = LogManager.getLogger();
    private NetworkManager field_146371_g;
    private boolean field_146373_h;
    private final GuiScreen field_146374_i;
    private static final String __OBFID = "CL_00000685";

    public GuiConnecting(GuiScreen p_i1181_1_, Minecraft p_i1181_2_, ServerData p_i1181_3_) {
        this.mc = p_i1181_2_;
        this.field_146374_i = p_i1181_1_;
        ServerAddress var4 = ServerAddress.func_78860_a(p_i1181_3_.serverIP);
        p_i1181_2_.loadWorld(null);
        p_i1181_2_.setServerData(p_i1181_3_);
        this.func_146367_a(var4.getIP(), var4.getPort());
    }

    public GuiConnecting(GuiScreen p_i1182_1_, Minecraft p_i1182_2_, String p_i1182_3_, int p_i1182_4_) {
        this.mc = p_i1182_2_;
        this.field_146374_i = p_i1182_1_;
        p_i1182_2_.loadWorld(null);
        this.func_146367_a(p_i1182_3_, p_i1182_4_);
    }

    private void func_146367_a(final String p_146367_1_, final int p_146367_2_) {
        logger.info("Connecting to " + p_146367_1_ + ", " + p_146367_2_);
        new Thread("Server Connector #" + field_146372_a.incrementAndGet()){
            private static final String __OBFID = "CL_00000686";

            @Override
            public void run() {
                InetAddress var1 = null;
                try {
                    if (GuiConnecting.this.field_146373_h) {
                        return;
                    }
                    var1 = InetAddress.getByName(p_146367_1_);
                    GuiConnecting.this.field_146371_g = NetworkManager.provideLanClient(var1, p_146367_2_);
                    GuiConnecting.this.field_146371_g.setNetHandler(new NetHandlerLoginClient(GuiConnecting.this.field_146371_g, GuiConnecting.this.mc, GuiConnecting.this.field_146374_i));
                    GuiConnecting.this.field_146371_g.scheduleOutboundPacket(new C00Handshake(5, p_146367_1_, p_146367_2_, EnumConnectionState.LOGIN), new GenericFutureListener[0]);
                    GuiConnecting.this.field_146371_g.scheduleOutboundPacket(new C00PacketLoginStart(GuiConnecting.this.mc.getSession().func_148256_e()), new GenericFutureListener[0]);
                }
                catch (UnknownHostException var5) {
                    if (GuiConnecting.this.field_146373_h) {
                        return;
                    }
                    logger.error("Couldn't connect to server", (Throwable)var5);
                    GuiConnecting.this.mc.displayGuiScreen(new GuiDisconnected(GuiConnecting.this.field_146374_i, "connect.failed", new ChatComponentTranslation("disconnect.genericReason", "Unknown host")));
                }
                catch (Exception var6) {
                    if (GuiConnecting.this.field_146373_h) {
                        return;
                    }
                    logger.error("Couldn't connect to server", (Throwable)var6);
                    String var3 = var6.toString();
                    if (var1 != null) {
                        String var4 = String.valueOf(var1.toString()) + ":" + p_146367_2_;
                        var3 = var3.replaceAll(var4, "");
                    }
                    GuiConnecting.this.mc.displayGuiScreen(new GuiDisconnected(GuiConnecting.this.field_146374_i, "connect.failed", new ChatComponentTranslation("disconnect.genericReason", var3)));
                }
            }
        }.start();
    }

    @Override
    public void updateScreen() {
        if (this.field_146371_g != null) {
            if (this.field_146371_g.isChannelOpen()) {
                this.field_146371_g.processReceivedPackets();
            } else if (this.field_146371_g.getExitMessage() != null) {
                this.field_146371_g.getNetHandler().onDisconnect(this.field_146371_g.getExitMessage());
            }
        }
    }

    @Override
    protected void keyTyped(char p_73869_1_, int p_73869_2_) {
    }

    @Override
    public void initGui() {
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 2 + 50, I18n.format("gui.cancel", new Object[0])));
    }

    @Override
    protected void actionPerformed(GuiButton p_146284_1_) {
        if (p_146284_1_.id == 0) {
            this.field_146373_h = true;
            if (this.field_146371_g != null) {
                this.field_146371_g.closeChannel(new ChatComponentText("Aborted"));
            }
            this.mc.displayGuiScreen(this.field_146374_i);
        }
    }

    @Override
    public void drawScreen(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        this.drawDefaultBackground();
        if (this.field_146371_g == null) {
            this.drawCenteredString(this.fontRendererObj, I18n.format("connect.connecting", new Object[0]), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.fontRendererObj, I18n.format("connect.authorizing", new Object[0]), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
        }
        super.drawScreen(p_73863_1_, p_73863_2_, p_73863_3_);
    }
}

