/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFX
extends Entity {
    protected int particleTextureIndexX;
    protected int particleTextureIndexY;
    protected float particleTextureJitterX;
    protected float particleTextureJitterY;
    protected int particleAge;
    protected int particleMaxAge;
    protected float particleScale;
    protected float particleGravity;
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    protected float particleAlpha = 1.0f;
    protected IIcon particleIcon;
    public static double interpPosX;
    public static double interpPosY;
    public static double interpPosZ;
    private static final String __OBFID = "CL_00000914";

    protected EntityFX(World p_i1218_1_, double p_i1218_2_, double p_i1218_4_, double p_i1218_6_) {
        super(p_i1218_1_);
        this.setSize(0.2f, 0.2f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(p_i1218_2_, p_i1218_4_, p_i1218_6_);
        this.lastTickPosX = p_i1218_2_;
        this.lastTickPosY = p_i1218_4_;
        this.lastTickPosZ = p_i1218_6_;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleTextureJitterX = this.rand.nextFloat() * 3.0f;
        this.particleTextureJitterY = this.rand.nextFloat() * 3.0f;
        this.particleScale = (this.rand.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particleMaxAge = (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f));
        this.particleAge = 0;
    }

    public EntityFX(World p_i1219_1_, double p_i1219_2_, double p_i1219_4_, double p_i1219_6_, double p_i1219_8_, double p_i1219_10_, double p_i1219_12_) {
        this(p_i1219_1_, p_i1219_2_, p_i1219_4_, p_i1219_6_);
        this.motionX = p_i1219_8_ + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.motionY = p_i1219_10_ + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.motionZ = p_i1219_12_ + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        float var14 = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float var15 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
        this.motionX = this.motionX / (double)var15 * (double)var14 * (double)0.4f;
        this.motionY = this.motionY / (double)var15 * (double)var14 * (double)0.4f + (double)0.1f;
        this.motionZ = this.motionZ / (double)var15 * (double)var14 * (double)0.4f;
    }

    public EntityFX multiplyVelocity(float p_70543_1_) {
        this.motionX *= (double)p_70543_1_;
        this.motionY = (this.motionY - (double)0.1f) * (double)p_70543_1_ + (double)0.1f;
        this.motionZ *= (double)p_70543_1_;
        return this;
    }

    public EntityFX multipleParticleScaleBy(float p_70541_1_) {
        this.setSize(0.2f * p_70541_1_, 0.2f * p_70541_1_);
        this.particleScale *= p_70541_1_;
        return this;
    }

    public void setRBGColorF(float p_70538_1_, float p_70538_2_, float p_70538_3_) {
        this.particleRed = p_70538_1_;
        this.particleGreen = p_70538_2_;
        this.particleBlue = p_70538_3_;
    }

    public void setAlphaF(float p_82338_1_) {
        this.particleAlpha = p_82338_1_;
    }

    public float getRedColorF() {
        return this.particleRed;
    }

    public float getGreenColorF() {
        return this.particleGreen;
    }

    public float getBlueColorF() {
        return this.particleBlue;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.motionY -= 0.04 * (double)this.particleGravity;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    public void renderParticle(Tessellator p_70539_1_, float p_70539_2_, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_) {
        float var8 = (float)this.particleTextureIndexX / 16.0f;
        float var9 = var8 + 0.0624375f;
        float var10 = (float)this.particleTextureIndexY / 16.0f;
        float var11 = var10 + 0.0624375f;
        float var12 = 0.1f * this.particleScale;
        if (this.particleIcon != null) {
            var8 = this.particleIcon.getMinU();
            var9 = this.particleIcon.getMaxU();
            var10 = this.particleIcon.getMinV();
            var11 = this.particleIcon.getMaxV();
        }
        float var13 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)p_70539_2_ - interpPosX);
        float var14 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)p_70539_2_ - interpPosY);
        float var15 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)p_70539_2_ - interpPosZ);
        p_70539_1_.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha);
        p_70539_1_.addVertexWithUV(var13 - p_70539_3_ * var12 - p_70539_6_ * var12, var14 - p_70539_4_ * var12, var15 - p_70539_5_ * var12 - p_70539_7_ * var12, var9, var11);
        p_70539_1_.addVertexWithUV(var13 - p_70539_3_ * var12 + p_70539_6_ * var12, var14 + p_70539_4_ * var12, var15 - p_70539_5_ * var12 + p_70539_7_ * var12, var9, var10);
        p_70539_1_.addVertexWithUV(var13 + p_70539_3_ * var12 + p_70539_6_ * var12, var14 + p_70539_4_ * var12, var15 + p_70539_5_ * var12 + p_70539_7_ * var12, var8, var10);
        p_70539_1_.addVertexWithUV(var13 + p_70539_3_ * var12 - p_70539_6_ * var12, var14 - p_70539_4_ * var12, var15 + p_70539_5_ * var12 - p_70539_7_ * var12, var8, var11);
    }

    public int getFXLayer() {
        return 0;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound p_70014_1_) {
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound p_70037_1_) {
    }

    public void setParticleIcon(IIcon p_110125_1_) {
        if (this.getFXLayer() == 1) {
            this.particleIcon = p_110125_1_;
        } else {
            if (this.getFXLayer() != 2) {
                throw new RuntimeException("Invalid call to Particle.setTex, use coordinate methods");
            }
            this.particleIcon = p_110125_1_;
        }
    }

    public void setParticleTextureIndex(int p_70536_1_) {
        if (this.getFXLayer() != 0) {
            throw new RuntimeException("Invalid call to Particle.setMiscTex");
        }
        this.particleTextureIndexX = p_70536_1_ % 16;
        this.particleTextureIndexY = p_70536_1_ / 16;
    }

    public void nextTextureIndexX() {
        ++this.particleTextureIndexX;
    }

    @Override
    public boolean canAttackWithItem() {
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ", Pos (" + this.posX + "," + this.posY + "," + this.posZ + "), RGBA (" + this.particleRed + "," + this.particleGreen + "," + this.particleBlue + "," + this.particleAlpha + "), Age " + this.particleAge;
    }
}

