/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkOverlayFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFireworkStarterFX
extends EntityFX {
    private int fireworkAge;
    private final EffectRenderer theEffectRenderer;
    private NBTTagList fireworkExplosions;
    boolean twinkle;
    private static final String __OBFID = "CL_00000906";

    public EntityFireworkStarterFX(World p_i1208_1_, double p_i1208_2_, double p_i1208_4_, double p_i1208_6_, double p_i1208_8_, double p_i1208_10_, double p_i1208_12_, EffectRenderer p_i1208_14_, NBTTagCompound p_i1208_15_) {
        super(p_i1208_1_, p_i1208_2_, p_i1208_4_, p_i1208_6_, 0.0, 0.0, 0.0);
        this.motionX = p_i1208_8_;
        this.motionY = p_i1208_10_;
        this.motionZ = p_i1208_12_;
        this.theEffectRenderer = p_i1208_14_;
        this.particleMaxAge = 8;
        if (p_i1208_15_ != null) {
            this.fireworkExplosions = p_i1208_15_.getTagList("Explosions", 10);
            if (this.fireworkExplosions.tagCount() == 0) {
                this.fireworkExplosions = null;
            } else {
                this.particleMaxAge = this.fireworkExplosions.tagCount() * 2 - 1;
                int var16 = 0;
                while (var16 < this.fireworkExplosions.tagCount()) {
                    NBTTagCompound var17 = this.fireworkExplosions.getCompoundTagAt(var16);
                    if (var17.getBoolean("Flicker")) {
                        this.twinkle = true;
                        this.particleMaxAge += 15;
                        break;
                    }
                    ++var16;
                }
            }
        }
    }

    @Override
    public void renderParticle(Tessellator p_70539_1_, float p_70539_2_, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_) {
    }

    @Override
    public void onUpdate() {
        boolean var1;
        if (this.fireworkAge == 0 && this.fireworkExplosions != null) {
            var1 = this.func_92037_i();
            boolean var2 = false;
            if (this.fireworkExplosions.tagCount() >= 3) {
                var2 = true;
            } else {
                int var3 = 0;
                while (var3 < this.fireworkExplosions.tagCount()) {
                    NBTTagCompound var4 = this.fireworkExplosions.getCompoundTagAt(var3);
                    if (var4.getByte("Type") == 1) {
                        var2 = true;
                        break;
                    }
                    ++var3;
                }
            }
            String var16 = "fireworks." + (var2 ? "largeBlast" : "blast") + (var1 ? "_far" : "");
            this.worldObj.playSound(this.posX, this.posY, this.posZ, var16, 20.0f, 0.95f + this.rand.nextFloat() * 0.1f, true);
        }
        if (this.fireworkAge % 2 == 0 && this.fireworkExplosions != null && this.fireworkAge / 2 < this.fireworkExplosions.tagCount()) {
            int var13 = this.fireworkAge / 2;
            NBTTagCompound var14 = this.fireworkExplosions.getCompoundTagAt(var13);
            byte var17 = var14.getByte("Type");
            boolean var18 = var14.getBoolean("Trail");
            boolean var5 = var14.getBoolean("Flicker");
            int[] var6 = var14.getIntArray("Colors");
            int[] var7 = var14.getIntArray("FadeColors");
            if (var17 == 1) {
                this.createBall(0.5, 4, var6, var7, var18, var5);
            } else if (var17 == 2) {
                this.createShaped(0.5, new double[][]{{0.0, 1.0}, {0.3455, 0.309}, {0.9511, 0.309}, {0.3795918367346939, -0.12653061224489795}, {0.6122448979591837, -0.8040816326530612}, {0.0, -0.35918367346938773}}, var6, var7, var18, var5, false);
            } else if (var17 == 3) {
                this.createShaped(0.5, new double[][]{{0.0, 0.2}, {0.2, 0.2}, {0.2, 0.6}, {0.6, 0.6}, {0.6, 0.2}, {0.2, 0.2}, {0.2, 0.0}, {0.4, 0.0}, {0.4, -0.6}, {0.2, -0.6}, {0.2, -0.4}, {0.0, -0.4}}, var6, var7, var18, var5, true);
            } else if (var17 == 4) {
                this.createBurst(var6, var7, var18, var5);
            } else {
                this.createBall(0.25, 2, var6, var7, var18, var5);
            }
            int var8 = var6[0];
            float var9 = (float)((var8 & 0xFF0000) >> 16) / 255.0f;
            float var10 = (float)((var8 & 0xFF00) >> 8) / 255.0f;
            float var11 = (float)((var8 & 0xFF) >> 0) / 255.0f;
            EntityFireworkOverlayFX var12 = new EntityFireworkOverlayFX(this.worldObj, this.posX, this.posY, this.posZ);
            var12.setRBGColorF(var9, var10, var11);
            this.theEffectRenderer.addEffect(var12);
        }
        ++this.fireworkAge;
        if (this.fireworkAge > this.particleMaxAge) {
            if (this.twinkle) {
                var1 = this.func_92037_i();
                String var15 = "fireworks." + (var1 ? "twinkle_far" : "twinkle");
                this.worldObj.playSound(this.posX, this.posY, this.posZ, var15, 20.0f, 0.9f + this.rand.nextFloat() * 0.15f, true);
            }
            this.setDead();
        }
    }

    private boolean func_92037_i() {
        Minecraft var1 = Minecraft.getMinecraft();
        return var1 == null || var1.renderViewEntity == null || var1.renderViewEntity.getDistanceSq(this.posX, this.posY, this.posZ) >= 256.0;
    }

    private void createParticle(double p_92034_1_, double p_92034_3_, double p_92034_5_, double p_92034_7_, double p_92034_9_, double p_92034_11_, int[] p_92034_13_, int[] p_92034_14_, boolean p_92034_15_, boolean p_92034_16_) {
        EntityFireworkSparkFX var17 = new EntityFireworkSparkFX(this.worldObj, p_92034_1_, p_92034_3_, p_92034_5_, p_92034_7_, p_92034_9_, p_92034_11_, this.theEffectRenderer);
        var17.setTrail(p_92034_15_);
        var17.setTwinkle(p_92034_16_);
        int var18 = this.rand.nextInt(p_92034_13_.length);
        var17.setColour(p_92034_13_[var18]);
        if (p_92034_14_ != null && p_92034_14_.length > 0) {
            var17.setFadeColour(p_92034_14_[this.rand.nextInt(p_92034_14_.length)]);
        }
        this.theEffectRenderer.addEffect(var17);
    }

    private void createBall(double p_92035_1_, int p_92035_3_, int[] p_92035_4_, int[] p_92035_5_, boolean p_92035_6_, boolean p_92035_7_) {
        double var8 = this.posX;
        double var10 = this.posY;
        double var12 = this.posZ;
        int var14 = -p_92035_3_;
        while (var14 <= p_92035_3_) {
            int var15 = -p_92035_3_;
            while (var15 <= p_92035_3_) {
                int var16 = -p_92035_3_;
                while (var16 <= p_92035_3_) {
                    double var17 = (double)var15 + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                    double var19 = (double)var14 + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                    double var21 = (double)var16 + (this.rand.nextDouble() - this.rand.nextDouble()) * 0.5;
                    double var23 = (double)MathHelper.sqrt_double(var17 * var17 + var19 * var19 + var21 * var21) / p_92035_1_ + this.rand.nextGaussian() * 0.05;
                    this.createParticle(var8, var10, var12, var17 / var23, var19 / var23, var21 / var23, p_92035_4_, p_92035_5_, p_92035_6_, p_92035_7_);
                    if (var14 != -p_92035_3_ && var14 != p_92035_3_ && var15 != -p_92035_3_ && var15 != p_92035_3_) {
                        var16 += p_92035_3_ * 2 - 1;
                    }
                    ++var16;
                }
                ++var15;
            }
            ++var14;
        }
    }

    private void createShaped(double p_92038_1_, double[][] p_92038_3_, int[] p_92038_4_, int[] p_92038_5_, boolean p_92038_6_, boolean p_92038_7_, boolean p_92038_8_) {
        double var9 = p_92038_3_[0][0];
        double var11 = p_92038_3_[0][1];
        this.createParticle(this.posX, this.posY, this.posZ, var9 * p_92038_1_, var11 * p_92038_1_, 0.0, p_92038_4_, p_92038_5_, p_92038_6_, p_92038_7_);
        float var13 = this.rand.nextFloat() * (float)Math.PI;
        double var14 = p_92038_8_ ? 0.034 : 0.34;
        int var16 = 0;
        while (var16 < 3) {
            double var17 = (double)var13 + (double)((float)var16 * (float)Math.PI) * var14;
            double var19 = var9;
            double var21 = var11;
            int var23 = 1;
            while (var23 < p_92038_3_.length) {
                double var24 = p_92038_3_[var23][0];
                double var26 = p_92038_3_[var23][1];
                double var28 = 0.25;
                while (var28 <= 1.0) {
                    double var30 = (var19 + (var24 - var19) * var28) * p_92038_1_;
                    double var32 = (var21 + (var26 - var21) * var28) * p_92038_1_;
                    double var34 = var30 * Math.sin(var17);
                    var30 *= Math.cos(var17);
                    double var36 = -1.0;
                    while (var36 <= 1.0) {
                        this.createParticle(this.posX, this.posY, this.posZ, var30 * var36, var32, var34 * var36, p_92038_4_, p_92038_5_, p_92038_6_, p_92038_7_);
                        var36 += 2.0;
                    }
                    var28 += 0.25;
                }
                var19 = var24;
                var21 = var26;
                ++var23;
            }
            ++var16;
        }
    }

    private void createBurst(int[] p_92036_1_, int[] p_92036_2_, boolean p_92036_3_, boolean p_92036_4_) {
        double var5 = this.rand.nextGaussian() * 0.05;
        double var7 = this.rand.nextGaussian() * 0.05;
        int var9 = 0;
        while (var9 < 70) {
            double var10 = this.motionX * 0.5 + this.rand.nextGaussian() * 0.15 + var5;
            double var12 = this.motionZ * 0.5 + this.rand.nextGaussian() * 0.15 + var7;
            double var14 = this.motionY * 0.5 + this.rand.nextDouble() * 0.5;
            this.createParticle(this.posX, this.posY, this.posZ, var10, var14, var12, p_92036_1_, p_92036_2_, p_92036_3_, p_92036_4_);
            ++var9;
        }
    }

    @Override
    public int getFXLayer() {
        return 0;
    }
}

