/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import b.PhantomClient;
import b.events.events.RenderNametagEvent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class Render {
    private static final ResourceLocation shadowTextures = new ResourceLocation("textures/misc/shadow.png");
    protected RenderManager renderManager;
    protected RenderBlocks field_147909_c = new RenderBlocks();
    protected float shadowSize;
    protected float shadowOpaque = 1.0f;
    private boolean field_147908_f = false;
    private static final String __OBFID = "CL_00000992";

    public abstract void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9);

    protected abstract ResourceLocation getEntityTexture(Entity var1);

    public boolean func_147905_a() {
        return this.field_147908_f;
    }

    protected void bindEntityTexture(Entity p_110777_1_) {
        this.bindTexture(this.getEntityTexture(p_110777_1_));
    }

    protected void bindTexture(ResourceLocation p_110776_1_) {
        this.renderManager.renderEngine.bindTexture(p_110776_1_);
    }

    private void renderEntityOnFire(Entity p_76977_1_, double p_76977_2_, double p_76977_4_, double p_76977_6_, float p_76977_8_) {
        GL11.glDisable((int)2896);
        IIcon var9 = Blocks.fire.func_149840_c(0);
        IIcon var10 = Blocks.fire.func_149840_c(1);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)p_76977_2_), (float)((float)p_76977_4_), (float)((float)p_76977_6_));
        float var11 = p_76977_1_.width * 1.4f;
        GL11.glScalef((float)var11, (float)var11, (float)var11);
        Tessellator var12 = Tessellator.instance;
        float var13 = 0.5f;
        float var14 = 0.0f;
        float var15 = p_76977_1_.height / var11;
        float var16 = (float)(p_76977_1_.posY - p_76977_1_.boundingBox.minY);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)var15) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var17 = 0.0f;
        int var18 = 0;
        var12.startDrawingQuads();
        while (var15 > 0.0f) {
            IIcon var19 = var18 % 2 == 0 ? var9 : var10;
            this.bindTexture(TextureMap.locationBlocksTexture);
            float var20 = var19.getMinU();
            float var21 = var19.getMinV();
            float var22 = var19.getMaxU();
            float var23 = var19.getMaxV();
            if (var18 / 2 % 2 == 0) {
                float var24 = var22;
                var22 = var20;
                var20 = var24;
            }
            var12.addVertexWithUV(var13 - var14, 0.0f - var16, var17, var22, var23);
            var12.addVertexWithUV(-var13 - var14, 0.0f - var16, var17, var20, var23);
            var12.addVertexWithUV(-var13 - var14, 1.4f - var16, var17, var20, var21);
            var12.addVertexWithUV(var13 - var14, 1.4f - var16, var17, var22, var21);
            var15 -= 0.45f;
            var16 -= 0.45f;
            var13 *= 0.9f;
            var17 += 0.03f;
            ++var18;
        }
        var12.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(Entity p_76975_1_, double p_76975_2_, double p_76975_4_, double p_76975_6_, float p_76975_8_, float p_76975_9_) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderManager.renderEngine.bindTexture(shadowTextures);
        World var10 = this.getWorldFromRenderManager();
        GL11.glDepthMask((boolean)false);
        float var11 = this.shadowSize;
        if (p_76975_1_ instanceof EntityLiving) {
            EntityLiving var12 = (EntityLiving)p_76975_1_;
            var11 *= var12.getRenderSizeModifier();
            if (var12.isChild()) {
                var11 *= 0.5f;
            }
        }
        double var35 = p_76975_1_.lastTickPosX + (p_76975_1_.posX - p_76975_1_.lastTickPosX) * (double)p_76975_9_;
        double var14 = p_76975_1_.lastTickPosY + (p_76975_1_.posY - p_76975_1_.lastTickPosY) * (double)p_76975_9_ + (double)p_76975_1_.getShadowSize();
        double var16 = p_76975_1_.lastTickPosZ + (p_76975_1_.posZ - p_76975_1_.lastTickPosZ) * (double)p_76975_9_;
        int var18 = MathHelper.floor_double(var35 - (double)var11);
        int var19 = MathHelper.floor_double(var35 + (double)var11);
        int var20 = MathHelper.floor_double(var14 - (double)var11);
        int var21 = MathHelper.floor_double(var14);
        int var22 = MathHelper.floor_double(var16 - (double)var11);
        int var23 = MathHelper.floor_double(var16 + (double)var11);
        double var24 = p_76975_2_ - var35;
        double var26 = p_76975_4_ - var14;
        double var28 = p_76975_6_ - var16;
        Tessellator var30 = Tessellator.instance;
        var30.startDrawingQuads();
        int var31 = var18;
        while (var31 <= var19) {
            int var32 = var20;
            while (var32 <= var21) {
                int var33 = var22;
                while (var33 <= var23) {
                    Block var34 = var10.getBlock(var31, var32 - 1, var33);
                    if (var34.getMaterial() != Material.air && var10.getBlockLightValue(var31, var32, var33) > 3) {
                        this.func_147907_a(var34, p_76975_2_, p_76975_4_ + (double)p_76975_1_.getShadowSize(), p_76975_6_, var31, var32, var33, p_76975_8_, var11, var24, var26 + (double)p_76975_1_.getShadowSize(), var28);
                    }
                    ++var33;
                }
                ++var32;
            }
            ++var31;
        }
        var30.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private World getWorldFromRenderManager() {
        return this.renderManager.worldObj;
    }

    private void func_147907_a(Block p_147907_1_, double p_147907_2_, double p_147907_4_, double p_147907_6_, int p_147907_8_, int p_147907_9_, int p_147907_10_, float p_147907_11_, float p_147907_12_, double p_147907_13_, double p_147907_15_, double p_147907_17_) {
        double var20;
        Tessellator var19 = Tessellator.instance;
        if (p_147907_1_.renderAsNormalBlock() && (var20 = ((double)p_147907_11_ - (p_147907_4_ - ((double)p_147907_9_ + p_147907_15_)) / 2.0) * 0.5 * (double)this.getWorldFromRenderManager().getLightBrightness(p_147907_8_, p_147907_9_, p_147907_10_)) >= 0.0) {
            if (var20 > 1.0) {
                var20 = 1.0;
            }
            var19.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)var20);
            double var22 = (double)p_147907_8_ + p_147907_1_.getBlockBoundsMinX() + p_147907_13_;
            double var24 = (double)p_147907_8_ + p_147907_1_.getBlockBoundsMaxX() + p_147907_13_;
            double var26 = (double)p_147907_9_ + p_147907_1_.getBlockBoundsMinY() + p_147907_15_ + 0.015625;
            double var28 = (double)p_147907_10_ + p_147907_1_.getBlockBoundsMinZ() + p_147907_17_;
            double var30 = (double)p_147907_10_ + p_147907_1_.getBlockBoundsMaxZ() + p_147907_17_;
            float var32 = (float)((p_147907_2_ - var22) / 2.0 / (double)p_147907_12_ + 0.5);
            float var33 = (float)((p_147907_2_ - var24) / 2.0 / (double)p_147907_12_ + 0.5);
            float var34 = (float)((p_147907_6_ - var28) / 2.0 / (double)p_147907_12_ + 0.5);
            float var35 = (float)((p_147907_6_ - var30) / 2.0 / (double)p_147907_12_ + 0.5);
            var19.addVertexWithUV(var22, var26, var28, var32, var34);
            var19.addVertexWithUV(var22, var26, var30, var32, var35);
            var19.addVertexWithUV(var24, var26, var30, var33, var35);
            var19.addVertexWithUV(var24, var26, var28, var33, var34);
        }
    }

    public static void renderOffsetAABB(AxisAlignedBB p_76978_0_, double p_76978_1_, double p_76978_3_, double p_76978_5_) {
        GL11.glDisable((int)3553);
        Tessellator var7 = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var7.startDrawingQuads();
        var7.setTranslation(p_76978_1_, p_76978_3_, p_76978_5_);
        var7.setNormal(0.0f, 0.0f, -1.0f);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.maxY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.maxY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.minY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.minY, p_76978_0_.minZ);
        var7.setNormal(0.0f, 0.0f, 1.0f);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.minY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.minY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.maxY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.maxY, p_76978_0_.maxZ);
        var7.setNormal(0.0f, -1.0f, 0.0f);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.minY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.minY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.minY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.minY, p_76978_0_.maxZ);
        var7.setNormal(0.0f, 1.0f, 0.0f);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.maxY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.maxY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.maxY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.maxY, p_76978_0_.minZ);
        var7.setNormal(-1.0f, 0.0f, 0.0f);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.minY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.maxY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.maxY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.minX, p_76978_0_.minY, p_76978_0_.minZ);
        var7.setNormal(1.0f, 0.0f, 0.0f);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.minY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.maxY, p_76978_0_.minZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.maxY, p_76978_0_.maxZ);
        var7.addVertex(p_76978_0_.maxX, p_76978_0_.minY, p_76978_0_.maxZ);
        var7.setTranslation(0.0, 0.0, 0.0);
        var7.draw();
        GL11.glEnable((int)3553);
    }

    public static void renderAABB(AxisAlignedBB p_76980_0_) {
        Tessellator var1 = Tessellator.instance;
        var1.startDrawingQuads();
        var1.addVertex(p_76980_0_.minX, p_76980_0_.maxY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.maxY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.minY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.minY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.minY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.minY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.maxY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.maxY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.minY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.minY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.minY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.minY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.maxY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.maxY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.maxY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.maxY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.minY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.maxY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.maxY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.minX, p_76980_0_.minY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.minY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.maxY, p_76980_0_.minZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.maxY, p_76980_0_.maxZ);
        var1.addVertex(p_76980_0_.maxX, p_76980_0_.minY, p_76980_0_.maxZ);
        var1.draw();
    }

    public void setRenderManager(RenderManager p_76976_1_) {
        this.renderManager = p_76976_1_;
    }

    public void doRenderShadowAndFire(Entity p_76979_1_, double p_76979_2_, double p_76979_4_, double p_76979_6_, float p_76979_8_, float p_76979_9_) {
        double var10;
        float var12;
        if (this.renderManager.options.fancyGraphics && this.shadowSize > 0.0f && !p_76979_1_.isInvisible() && (var12 = (float)((1.0 - (var10 = this.renderManager.getDistanceToCamera(p_76979_1_.posX, p_76979_1_.posY, p_76979_1_.posZ)) / 256.0) * (double)this.shadowOpaque)) > 0.0f) {
            this.renderShadow(p_76979_1_, p_76979_2_, p_76979_4_, p_76979_6_, var12, p_76979_9_);
        }
        if (p_76979_1_.canRenderOnFire()) {
            this.renderEntityOnFire(p_76979_1_, p_76979_2_, p_76979_4_, p_76979_6_, p_76979_9_);
        }
    }

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }

    public void updateIcons(IIconRegister p_94143_1_) {
    }

    protected void func_147906_a(Entity p_147906_1_, String p_147906_2_, double p_147906_3_, double p_147906_5_, double p_147906_7_, int p_147906_9_) {
        double var10 = p_147906_1_.getDistanceSqToEntity(this.renderManager.livingPlayer);
        if (var10 <= (double)(p_147906_9_ * p_147906_9_)) {
            FontRenderer var12 = this.getFontRendererFromRenderManager();
            float var13 = 1.6f;
            float var14 = 0.016666668f * var13;
            if (PhantomClient.Instance != null) {
                RenderNametagEvent event = new RenderNametagEvent(p_147906_1_, p_147906_2_, var14);
                PhantomClient.Instance.getEventManager().callEvent(event);
                p_147906_2_ = event.getNameTag();
                var14 = event.getSize();
                if (event.isCancelled()) {
                    return;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)p_147906_3_ + 0.0f), (float)((float)p_147906_5_ + p_147906_1_.height + 0.5f), (float)((float)p_147906_7_));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-var14), (float)(-var14), (float)var14);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc(770, 771, 1, 0);
            Tessellator var15 = Tessellator.instance;
            int var16 = 0;
            if (p_147906_2_.equals("deadmau5")) {
                var16 = -10;
            }
            GL11.glDisable((int)3553);
            var15.startDrawingQuads();
            int var17 = var12.getStringWidth(p_147906_2_) / 2;
            var15.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
            var15.addVertex(-var17 - 1, -1 + var16, 0.0);
            var15.addVertex(-var17 - 1, 8 + var16, 0.0);
            var15.addVertex(var17 + 1, 8 + var16, 0.0);
            var15.addVertex(var17 + 1, -1 + var16, 0.0);
            var15.draw();
            GL11.glEnable((int)3553);
            var12.drawString(p_147906_2_, -var12.getStringWidth(p_147906_2_) / 2, var16, 0x20FFFFFF);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            var12.drawString(p_147906_2_, -var12.getStringWidth(p_147906_2_) / 2, var16, -1);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }
}

