/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderDragon
extends RenderLiving {
    private static final ResourceLocation enderDragonExplodingTextures = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("textures/entity/endercrystal/endercrystal_beam.png");
    private static final ResourceLocation enderDragonEyesTextures = new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png");
    private static final ResourceLocation enderDragonTextures = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    protected ModelDragon modelDragon;
    private static final String __OBFID = "CL_00000988";

    public RenderDragon() {
        super(new ModelDragon(0.0f), 0.5f);
        this.modelDragon = (ModelDragon)this.mainModel;
        this.setRenderPassModel(this.mainModel);
    }

    protected void rotateCorpse(EntityDragon p_77043_1_, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        float var5 = (float)p_77043_1_.getMovementOffsets(7, p_77043_4_)[0];
        float var6 = (float)(p_77043_1_.getMovementOffsets(5, p_77043_4_)[1] - p_77043_1_.getMovementOffsets(10, p_77043_4_)[1]);
        GL11.glRotatef((float)(-var5), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(var6 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
        if (p_77043_1_.deathTime > 0) {
            float var7 = ((float)p_77043_1_.deathTime + p_77043_4_ - 1.0f) / 20.0f * 1.6f;
            if ((var7 = MathHelper.sqrt_float(var7)) > 1.0f) {
                var7 = 1.0f;
            }
            GL11.glRotatef((float)(var7 * this.getDeathMaxRotation(p_77043_1_)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected void renderModel(EntityDragon p_77036_1_, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_) {
        if (p_77036_1_.deathTicks > 0) {
            float var8 = (float)p_77036_1_.deathTicks / 200.0f;
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)var8);
            this.bindTexture(enderDragonExplodingTextures);
            this.mainModel.render(p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthFunc((int)514);
        }
        this.bindEntityTexture(p_77036_1_);
        this.mainModel.render(p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
        if (p_77036_1_.hurtTime > 0) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.mainModel.render(p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glDepthFunc((int)515);
        }
    }

    public void doRender(EntityDragon p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        BossStatus.setBossStatus(p_76986_1_, false);
        super.doRender(p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
        if (p_76986_1_.healingEnderCrystal != null) {
            float var10 = (float)p_76986_1_.healingEnderCrystal.innerRotation + p_76986_9_;
            float var11 = MathHelper.sin(var10 * 0.2f) / 2.0f + 0.5f;
            var11 = (var11 * var11 + var11) * 0.2f;
            float var12 = (float)(p_76986_1_.healingEnderCrystal.posX - p_76986_1_.posX - (p_76986_1_.prevPosX - p_76986_1_.posX) * (double)(1.0f - p_76986_9_));
            float var13 = (float)((double)var11 + p_76986_1_.healingEnderCrystal.posY - 1.0 - p_76986_1_.posY - (p_76986_1_.prevPosY - p_76986_1_.posY) * (double)(1.0f - p_76986_9_));
            float var14 = (float)(p_76986_1_.healingEnderCrystal.posZ - p_76986_1_.posZ - (p_76986_1_.prevPosZ - p_76986_1_.posZ) * (double)(1.0f - p_76986_9_));
            float var15 = MathHelper.sqrt_float(var12 * var12 + var14 * var14);
            float var16 = MathHelper.sqrt_float(var12 * var12 + var13 * var13 + var14 * var14);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)p_76986_2_), (float)((float)p_76986_4_ + 2.0f), (float)((float)p_76986_6_));
            GL11.glRotatef((float)((float)(-Math.atan2(var14, var12)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-Math.atan2(var15, var13)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator var17 = Tessellator.instance;
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2884);
            this.bindTexture(enderDragonCrystalBeamTextures);
            GL11.glShadeModel((int)7425);
            float var18 = 0.0f - ((float)p_76986_1_.ticksExisted + p_76986_9_) * 0.01f;
            float var19 = MathHelper.sqrt_float(var12 * var12 + var13 * var13 + var14 * var14) / 32.0f - ((float)p_76986_1_.ticksExisted + p_76986_9_) * 0.01f;
            var17.startDrawing(5);
            int var20 = 8;
            int var21 = 0;
            while (var21 <= var20) {
                float var22 = MathHelper.sin((float)(var21 % var20) * (float)Math.PI * 2.0f / (float)var20) * 0.75f;
                float var23 = MathHelper.cos((float)(var21 % var20) * (float)Math.PI * 2.0f / (float)var20) * 0.75f;
                float var24 = (float)(var21 % var20) * 1.0f / (float)var20;
                var17.setColorOpaque_I(0);
                var17.addVertexWithUV(var22 * 0.2f, var23 * 0.2f, 0.0, var24, var19);
                var17.setColorOpaque_I(0xFFFFFF);
                var17.addVertexWithUV(var22, var23, var16, var24, var18);
                ++var21;
            }
            var17.draw();
            GL11.glEnable((int)2884);
            GL11.glShadeModel((int)7424);
            RenderHelper.enableStandardItemLighting();
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation getEntityTexture(EntityDragon p_110775_1_) {
        return enderDragonTextures;
    }

    protected void renderEquippedItems(EntityDragon p_77029_1_, float p_77029_2_) {
        super.renderEquippedItems(p_77029_1_, p_77029_2_);
        Tessellator var3 = Tessellator.instance;
        if (p_77029_1_.deathTicks > 0) {
            RenderHelper.disableStandardItemLighting();
            float var4 = ((float)p_77029_1_.deathTicks + p_77029_2_) / 200.0f;
            float var5 = 0.0f;
            if (var4 > 0.8f) {
                var5 = (var4 - 0.8f) / 0.2f;
            }
            Random var6 = new Random(432L);
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2884);
            GL11.glDepthMask((boolean)false);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)-2.0f);
            int var7 = 0;
            while ((float)var7 < (var4 + var4 * var4) / 2.0f * 60.0f) {
                GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(var6.nextFloat() * 360.0f + var4 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                var3.startDrawing(6);
                float var8 = var6.nextFloat() * 20.0f + 5.0f + var5 * 10.0f;
                float var9 = var6.nextFloat() * 2.0f + 1.0f + var5 * 2.0f;
                var3.setColorRGBA_I(0xFFFFFF, (int)(255.0f * (1.0f - var5)));
                var3.addVertex(0.0, 0.0, 0.0);
                var3.setColorRGBA_I(0xFF00FF, 0);
                var3.addVertex(-0.866 * (double)var9, var8, -0.5f * var9);
                var3.addVertex(0.866 * (double)var9, var8, -0.5f * var9);
                var3.addVertex(0.0, var8, 1.0f * var9);
                var3.addVertex(-0.866 * (double)var9, var8, -0.5f * var9);
                var3.draw();
                ++var7;
            }
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glShadeModel((int)7424);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            RenderHelper.enableStandardItemLighting();
        }
    }

    protected int shouldRenderPass(EntityDragon p_77032_1_, int p_77032_2_, float p_77032_3_) {
        if (p_77032_2_ == 1) {
            GL11.glDepthFunc((int)515);
        }
        if (p_77032_2_ != 0) {
            return -1;
        }
        this.bindTexture(enderDragonEyesTextures);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthFunc((int)514);
        int var4 = 61680;
        int var5 = var4 % 65536;
        int var6 = var4 / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, (float)var5 / 1.0f, (float)var6 / 1.0f);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return 1;
    }

    @Override
    public void doRender(EntityLiving p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityDragon)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }

    @Override
    protected int shouldRenderPass(EntityLivingBase p_77032_1_, int p_77032_2_, float p_77032_3_) {
        return this.shouldRenderPass((EntityDragon)p_77032_1_, p_77032_2_, p_77032_3_);
    }

    @Override
    protected void renderEquippedItems(EntityLivingBase p_77029_1_, float p_77029_2_) {
        this.renderEquippedItems((EntityDragon)p_77029_1_, p_77029_2_);
    }

    @Override
    protected void rotateCorpse(EntityLivingBase p_77043_1_, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        this.rotateCorpse((EntityDragon)p_77043_1_, p_77043_2_, p_77043_3_, p_77043_4_);
    }

    @Override
    protected void renderModel(EntityLivingBase p_77036_1_, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_) {
        this.renderModel((EntityDragon)p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
    }

    @Override
    public void doRender(EntityLivingBase p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityDragon)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return this.getEntityTexture((EntityDragon)p_110775_1_);
    }

    @Override
    public void doRender(Entity p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityDragon)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }
}

