/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.Random;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderItem
extends Render {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private RenderBlocks field_147913_i = new RenderBlocks();
    private Random random = new Random();
    public boolean renderWithColor = true;
    public float zLevel;
    public static boolean renderInFrame;
    private static final String __OBFID = "CL_00001003";

    public RenderItem() {
        this.shadowSize = 0.15f;
        this.shadowOpaque = 0.75f;
    }

    public void doRender(EntityItem p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        ItemStack var10 = p_76986_1_.getEntityItem();
        if (var10.getItem() != null) {
            this.bindEntityTexture(p_76986_1_);
            TextureUtil.func_152777_a(false, false, 1.0f);
            this.random.setSeed(187L);
            GL11.glPushMatrix();
            float var11 = MathHelper.sin(((float)p_76986_1_.age + p_76986_9_) / 10.0f + p_76986_1_.hoverStart) * 0.1f + 0.1f;
            float var12 = (((float)p_76986_1_.age + p_76986_9_) / 20.0f + p_76986_1_.hoverStart) * 57.295776f;
            int var13 = 1;
            if (p_76986_1_.getEntityItem().stackSize > 1) {
                var13 = 2;
            }
            if (p_76986_1_.getEntityItem().stackSize > 5) {
                var13 = 3;
            }
            if (p_76986_1_.getEntityItem().stackSize > 20) {
                var13 = 4;
            }
            if (p_76986_1_.getEntityItem().stackSize > 40) {
                var13 = 5;
            }
            GL11.glTranslatef((float)((float)p_76986_2_), (float)((float)p_76986_4_ + var11), (float)((float)p_76986_6_));
            GL11.glEnable((int)32826);
            if (var10.getItemSpriteNumber() == 0 && var10.getItem() instanceof ItemBlock && RenderBlocks.renderItemIn3d(Block.getBlockFromItem(var10.getItem()).getRenderType())) {
                Block var22 = Block.getBlockFromItem(var10.getItem());
                GL11.glRotatef((float)var12, (float)0.0f, (float)1.0f, (float)0.0f);
                if (renderInFrame) {
                    GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                    GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                float var24 = 0.25f;
                int var25 = var22.getRenderType();
                if (var25 == 1 || var25 == 19 || var25 == 12 || var25 == 2) {
                    var24 = 0.5f;
                }
                if (var22.getRenderBlockPass() > 0) {
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.glBlendFunc(770, 771, 1, 0);
                }
                GL11.glScalef((float)var24, (float)var24, (float)var24);
                int var26 = 0;
                while (var26 < var13) {
                    GL11.glPushMatrix();
                    if (var26 > 0) {
                        float var18 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / var24;
                        float var19 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / var24;
                        float var20 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / var24;
                        GL11.glTranslatef((float)var18, (float)var19, (float)var20);
                    }
                    this.field_147913_i.renderBlockAsItem(var22, var10.getItemDamage(), 1.0f);
                    GL11.glPopMatrix();
                    ++var26;
                }
                if (var22.getRenderBlockPass() > 0) {
                    GL11.glDisable((int)3042);
                }
            } else if (var10.getItemSpriteNumber() == 1 && var10.getItem().requiresMultipleRenderPasses()) {
                if (renderInFrame) {
                    GL11.glScalef((float)0.5128205f, (float)0.5128205f, (float)0.5128205f);
                    GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                } else {
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                int var21 = 0;
                while (var21 <= 1) {
                    this.random.setSeed(187L);
                    IIcon var23 = var10.getItem().getIconFromDamageForRenderPass(var10.getItemDamage(), var21);
                    if (this.renderWithColor) {
                        int var25 = var10.getItem().getColorFromItemStack(var10, var21);
                        float var17 = (float)(var25 >> 16 & 0xFF) / 255.0f;
                        float var18 = (float)(var25 >> 8 & 0xFF) / 255.0f;
                        float var19 = (float)(var25 & 0xFF) / 255.0f;
                        GL11.glColor4f((float)var17, (float)var18, (float)var19, (float)1.0f);
                        this.renderDroppedItem(p_76986_1_, var23, var13, p_76986_9_, var17, var18, var19);
                    } else {
                        this.renderDroppedItem(p_76986_1_, var23, var13, p_76986_9_, 1.0f, 1.0f, 1.0f);
                    }
                    ++var21;
                }
            } else {
                if (var10 != null && var10.getItem() instanceof ItemCloth) {
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.glBlendFunc(770, 771, 1, 0);
                }
                if (renderInFrame) {
                    GL11.glScalef((float)0.5128205f, (float)0.5128205f, (float)0.5128205f);
                    GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                } else {
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                IIcon var14 = var10.getIconIndex();
                if (this.renderWithColor) {
                    int var15 = var10.getItem().getColorFromItemStack(var10, 0);
                    float var16 = (float)(var15 >> 16 & 0xFF) / 255.0f;
                    float var17 = (float)(var15 >> 8 & 0xFF) / 255.0f;
                    float var18 = (float)(var15 & 0xFF) / 255.0f;
                    this.renderDroppedItem(p_76986_1_, var14, var13, p_76986_9_, var16, var17, var18);
                } else {
                    this.renderDroppedItem(p_76986_1_, var14, var13, p_76986_9_, 1.0f, 1.0f, 1.0f);
                }
                if (var10 != null && var10.getItem() instanceof ItemCloth) {
                    GL11.glDisable((int)3042);
                }
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            this.bindEntityTexture(p_76986_1_);
            TextureUtil.func_147945_b();
        }
    }

    protected ResourceLocation getEntityTexture(EntityItem p_110775_1_) {
        return this.renderManager.renderEngine.getResourceLocation(p_110775_1_.getEntityItem().getItemSpriteNumber());
    }

    private void renderDroppedItem(EntityItem p_77020_1_, IIcon p_77020_2_, int p_77020_3_, float p_77020_4_, float p_77020_5_, float p_77020_6_, float p_77020_7_) {
        Tessellator var8 = Tessellator.instance;
        if (p_77020_2_ == null) {
            TextureManager var9 = Minecraft.getMinecraft().getTextureManager();
            ResourceLocation var10 = var9.getResourceLocation(p_77020_1_.getEntityItem().getItemSpriteNumber());
            p_77020_2_ = ((TextureMap)var9.getTexture(var10)).getAtlasSprite("missingno");
        }
        float var25 = p_77020_2_.getMinU();
        float var26 = p_77020_2_.getMaxU();
        float var11 = p_77020_2_.getMinV();
        float var12 = p_77020_2_.getMaxV();
        float var13 = 1.0f;
        float var14 = 0.5f;
        float var15 = 0.25f;
        if (this.renderManager.options.fancyGraphics) {
            GL11.glPushMatrix();
            if (renderInFrame) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)((((float)p_77020_1_.age + p_77020_4_) / 20.0f + p_77020_1_.hoverStart) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            float var16 = 0.0625f;
            float var17 = 0.021875f;
            ItemStack var18 = p_77020_1_.getEntityItem();
            int var19 = var18.stackSize;
            int var24 = var19 < 2 ? 1 : (var19 < 16 ? 2 : (var19 < 32 ? 3 : 4));
            GL11.glTranslatef((float)(-var14), (float)(-var15), (float)(-((var16 + var17) * (float)var24 / 2.0f)));
            int var20 = 0;
            while (var20 < var24) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(var16 + var17));
                if (var18.getItemSpriteNumber() == 0) {
                    this.bindTexture(TextureMap.locationBlocksTexture);
                } else {
                    this.bindTexture(TextureMap.locationItemsTexture);
                }
                GL11.glColor4f((float)p_77020_5_, (float)p_77020_6_, (float)p_77020_7_, (float)1.0f);
                ItemRenderer.renderItemIn2D(var8, var26, var11, var25, var12, p_77020_2_.getIconWidth(), p_77020_2_.getIconHeight(), var16);
                if (var18.hasEffect()) {
                    GL11.glDepthFunc((int)514);
                    GL11.glDisable((int)2896);
                    this.renderManager.renderEngine.bindTexture(RES_ITEM_GLINT);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)768, (int)1);
                    float var21 = 0.76f;
                    GL11.glColor4f((float)(0.5f * var21), (float)(0.25f * var21), (float)(0.8f * var21), (float)1.0f);
                    GL11.glMatrixMode((int)5890);
                    GL11.glPushMatrix();
                    float var22 = 0.125f;
                    GL11.glScalef((float)var22, (float)var22, (float)var22);
                    float var23 = (float)(Minecraft.getSystemTime() % 3000L) / 3000.0f * 8.0f;
                    GL11.glTranslatef((float)var23, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ItemRenderer.renderItemIn2D(var8, 0.0f, 0.0f, 1.0f, 1.0f, 255, 255, var16);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)var22, (float)var22, (float)var22);
                    var23 = (float)(Minecraft.getSystemTime() % 4873L) / 4873.0f * 8.0f;
                    GL11.glTranslatef((float)(-var23), (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ItemRenderer.renderItemIn2D(var8, 0.0f, 0.0f, 1.0f, 1.0f, 255, 255, var16);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5888);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)2896);
                    GL11.glDepthFunc((int)515);
                }
                ++var20;
            }
            GL11.glPopMatrix();
        } else {
            int var27 = 0;
            while (var27 < p_77020_3_) {
                GL11.glPushMatrix();
                if (var27 > 0) {
                    float var17 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float var28 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float var29 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)var17, (float)var28, (float)var29);
                }
                if (!renderInFrame) {
                    GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glColor4f((float)p_77020_5_, (float)p_77020_6_, (float)p_77020_7_, (float)1.0f);
                var8.startDrawingQuads();
                var8.setNormal(0.0f, 1.0f, 0.0f);
                var8.addVertexWithUV(0.0f - var14, 0.0f - var15, 0.0, var25, var12);
                var8.addVertexWithUV(var13 - var14, 0.0f - var15, 0.0, var26, var12);
                var8.addVertexWithUV(var13 - var14, 1.0f - var15, 0.0, var26, var11);
                var8.addVertexWithUV(0.0f - var14, 1.0f - var15, 0.0, var25, var11);
                var8.draw();
                GL11.glPopMatrix();
                ++var27;
            }
        }
    }

    public void renderItemIntoGUI(FontRenderer p_77015_1_, TextureManager p_77015_2_, ItemStack p_77015_3_, int p_77015_4_, int p_77015_5_) {
        int var6 = p_77015_3_.getItemDamage();
        IIcon var7 = p_77015_3_.getIconIndex();
        if (p_77015_3_.getItemSpriteNumber() == 0 && RenderBlocks.renderItemIn3d(Block.getBlockFromItem(p_77015_3_.getItem()).getRenderType())) {
            p_77015_2_.bindTexture(TextureMap.locationBlocksTexture);
            Block var16 = Block.getBlockFromItem(p_77015_3_.getItem());
            GL11.glEnable((int)3008);
            if (var16.getRenderBlockPass() != 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.glBlendFunc(770, 771, 1, 0);
            } else {
                GL11.glAlphaFunc((int)516, (float)0.5f);
                GL11.glDisable((int)3042);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(p_77015_4_ - 2), (float)(p_77015_5_ + 3), (float)(-3.0f + this.zLevel));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int var9 = p_77015_3_.getItem().getColorFromItemStack(p_77015_3_, 0);
            float var17 = (float)(var9 >> 16 & 0xFF) / 255.0f;
            float var18 = (float)(var9 >> 8 & 0xFF) / 255.0f;
            float var12 = (float)(var9 & 0xFF) / 255.0f;
            if (this.renderWithColor) {
                GL11.glColor4f((float)var17, (float)var18, (float)var12, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.field_147913_i.useInventoryTint = this.renderWithColor;
            this.field_147913_i.renderBlockAsItem(var16, var6, 1.0f);
            this.field_147913_i.useInventoryTint = true;
            if (var16.getRenderBlockPass() == 0) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            GL11.glPopMatrix();
        } else if (p_77015_3_.getItem().requiresMultipleRenderPasses()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            p_77015_2_.bindTexture(TextureMap.locationItemsTexture);
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc(0, 0, 0, 0);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator var8 = Tessellator.instance;
            var8.startDrawingQuads();
            var8.setColorOpaque_I(-1);
            var8.addVertex(p_77015_4_ - 2, p_77015_5_ + 18, this.zLevel);
            var8.addVertex(p_77015_4_ + 18, p_77015_5_ + 18, this.zLevel);
            var8.addVertex(p_77015_4_ + 18, p_77015_5_ - 2, this.zLevel);
            var8.addVertex(p_77015_4_ - 2, p_77015_5_ - 2, this.zLevel);
            var8.draw();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            OpenGlHelper.glBlendFunc(770, 771, 1, 0);
            int var9 = 0;
            while (var9 <= 1) {
                IIcon var10 = p_77015_3_.getItem().getIconFromDamageForRenderPass(var6, var9);
                int var11 = p_77015_3_.getItem().getColorFromItemStack(p_77015_3_, var9);
                float var12 = (float)(var11 >> 16 & 0xFF) / 255.0f;
                float var13 = (float)(var11 >> 8 & 0xFF) / 255.0f;
                float var14 = (float)(var11 & 0xFF) / 255.0f;
                if (this.renderWithColor) {
                    GL11.glColor4f((float)var12, (float)var13, (float)var14, (float)1.0f);
                }
                this.renderIcon(p_77015_4_, p_77015_5_, var10, 16, 16);
                ++var9;
            }
            GL11.glEnable((int)2896);
        } else {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc(770, 771, 1, 0);
            ResourceLocation var15 = p_77015_2_.getResourceLocation(p_77015_3_.getItemSpriteNumber());
            p_77015_2_.bindTexture(var15);
            if (var7 == null) {
                var7 = ((TextureMap)Minecraft.getMinecraft().getTextureManager().getTexture(var15)).getAtlasSprite("missingno");
            }
            int var9 = p_77015_3_.getItem().getColorFromItemStack(p_77015_3_, 0);
            float var17 = (float)(var9 >> 16 & 0xFF) / 255.0f;
            float var18 = (float)(var9 >> 8 & 0xFF) / 255.0f;
            float var12 = (float)(var9 & 0xFF) / 255.0f;
            if (this.renderWithColor) {
                GL11.glColor4f((float)var17, (float)var18, (float)var12, (float)1.0f);
            }
            this.renderIcon(p_77015_4_, p_77015_5_, var7, 16, 16);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
        GL11.glEnable((int)2884);
    }

    public void renderItemAndEffectIntoGUI(FontRenderer p_82406_1_, TextureManager p_82406_2_, final ItemStack p_82406_3_, int p_82406_4_, int p_82406_5_) {
        if (p_82406_3_ != null) {
            this.zLevel += 50.0f;
            try {
                this.renderItemIntoGUI(p_82406_1_, p_82406_2_, p_82406_3_, p_82406_4_, p_82406_5_);
            }
            catch (Throwable var9) {
                CrashReport var7 = CrashReport.makeCrashReport(var9, "Rendering item");
                CrashReportCategory var8 = var7.makeCategory("Item being rendered");
                var8.addCrashSectionCallable("Item Type", new Callable(){
                    private static final String __OBFID = "CL_00001004";

                    public String call() {
                        return String.valueOf(p_82406_3_.getItem());
                    }
                });
                var8.addCrashSectionCallable("Item Aux", new Callable(){
                    private static final String __OBFID = "CL_00001005";

                    public String call() {
                        return String.valueOf(p_82406_3_.getItemDamage());
                    }
                });
                var8.addCrashSectionCallable("Item NBT", new Callable(){
                    private static final String __OBFID = "CL_00001006";

                    public String call() {
                        return String.valueOf(p_82406_3_.getTagCompound());
                    }
                });
                var8.addCrashSectionCallable("Item Foil", new Callable(){
                    private static final String __OBFID = "CL_00001007";

                    public String call() {
                        return String.valueOf(p_82406_3_.hasEffect());
                    }
                });
                throw new ReportedException(var7);
            }
            if (p_82406_3_.hasEffect()) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)false);
                p_82406_2_.bindTexture(RES_ITEM_GLINT);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
                this.renderGlint(p_82406_4_ * 431278612 + p_82406_5_ * 32178161, p_82406_4_ - 2, p_82406_5_ - 2, 20, 20);
                OpenGlHelper.glBlendFunc(770, 771, 1, 0);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            this.zLevel -= 50.0f;
        }
    }

    private void renderGlint(int p_77018_1_, int p_77018_2_, int p_77018_3_, int p_77018_4_, int p_77018_5_) {
        int var6 = 0;
        while (var6 < 2) {
            OpenGlHelper.glBlendFunc(772, 1, 0, 0);
            float var7 = 0.00390625f;
            float var8 = 0.00390625f;
            float var9 = (float)(Minecraft.getSystemTime() % (long)(3000 + var6 * 1873)) / (3000.0f + (float)(var6 * 1873)) * 256.0f;
            float var10 = 0.0f;
            Tessellator var11 = Tessellator.instance;
            float var12 = 4.0f;
            if (var6 == 1) {
                var12 = -1.0f;
            }
            var11.startDrawingQuads();
            var11.addVertexWithUV(p_77018_2_ + 0, p_77018_3_ + p_77018_5_, this.zLevel, (var9 + (float)p_77018_5_ * var12) * var7, (var10 + (float)p_77018_5_) * var8);
            var11.addVertexWithUV(p_77018_2_ + p_77018_4_, p_77018_3_ + p_77018_5_, this.zLevel, (var9 + (float)p_77018_4_ + (float)p_77018_5_ * var12) * var7, (var10 + (float)p_77018_5_) * var8);
            var11.addVertexWithUV(p_77018_2_ + p_77018_4_, p_77018_3_ + 0, this.zLevel, (var9 + (float)p_77018_4_) * var7, (var10 + 0.0f) * var8);
            var11.addVertexWithUV(p_77018_2_ + 0, p_77018_3_ + 0, this.zLevel, (var9 + 0.0f) * var7, (var10 + 0.0f) * var8);
            var11.draw();
            ++var6;
        }
    }

    public void renderItemOverlayIntoGUI(FontRenderer p_77021_1_, TextureManager p_77021_2_, ItemStack p_77021_3_, int p_77021_4_, int p_77021_5_) {
        this.renderItemOverlayIntoGUI(p_77021_1_, p_77021_2_, p_77021_3_, p_77021_4_, p_77021_5_, null);
    }

    public void renderItemOverlayIntoGUI(FontRenderer p_94148_1_, TextureManager p_94148_2_, ItemStack p_94148_3_, int p_94148_4_, int p_94148_5_, String p_94148_6_) {
        if (p_94148_3_ != null) {
            if (p_94148_3_.stackSize > 1 || p_94148_6_ != null) {
                String var7 = p_94148_6_ == null ? String.valueOf(p_94148_3_.stackSize) : p_94148_6_;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3042);
                p_94148_1_.drawStringWithShadow(var7, p_94148_4_ + 19 - 2 - p_94148_1_.getStringWidth(var7), p_94148_5_ + 6 + 3, 0xFFFFFF);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            if (p_94148_3_.isItemDamaged()) {
                int var12 = (int)Math.round(13.0 - (double)p_94148_3_.getItemDamageForDisplay() * 13.0 / (double)p_94148_3_.getMaxDamage());
                int var8 = (int)Math.round(255.0 - (double)p_94148_3_.getItemDamageForDisplay() * 255.0 / (double)p_94148_3_.getMaxDamage());
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                Tessellator var9 = Tessellator.instance;
                int var10 = 255 - var8 << 16 | var8 << 8;
                int var11 = (255 - var8) / 4 << 16 | 0x3F00;
                this.renderQuad(var9, p_94148_4_ + 2, p_94148_5_ + 13, 13, 2, 0);
                this.renderQuad(var9, p_94148_4_ + 2, p_94148_5_ + 13, 12, 1, var11);
                this.renderQuad(var9, p_94148_4_ + 2, p_94148_5_ + 13, var12, 1, var10);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void renderQuad(Tessellator p_77017_1_, int p_77017_2_, int p_77017_3_, int p_77017_4_, int p_77017_5_, int p_77017_6_) {
        p_77017_1_.startDrawingQuads();
        p_77017_1_.setColorOpaque_I(p_77017_6_);
        p_77017_1_.addVertex(p_77017_2_ + 0, p_77017_3_ + 0, 0.0);
        p_77017_1_.addVertex(p_77017_2_ + 0, p_77017_3_ + p_77017_5_, 0.0);
        p_77017_1_.addVertex(p_77017_2_ + p_77017_4_, p_77017_3_ + p_77017_5_, 0.0);
        p_77017_1_.addVertex(p_77017_2_ + p_77017_4_, p_77017_3_ + 0, 0.0);
        p_77017_1_.draw();
    }

    public void renderIcon(int p_94149_1_, int p_94149_2_, IIcon p_94149_3_, int p_94149_4_, int p_94149_5_) {
        Tessellator var6 = Tessellator.instance;
        var6.startDrawingQuads();
        var6.addVertexWithUV(p_94149_1_ + 0, p_94149_2_ + p_94149_5_, this.zLevel, p_94149_3_.getMinU(), p_94149_3_.getMaxV());
        var6.addVertexWithUV(p_94149_1_ + p_94149_4_, p_94149_2_ + p_94149_5_, this.zLevel, p_94149_3_.getMaxU(), p_94149_3_.getMaxV());
        var6.addVertexWithUV(p_94149_1_ + p_94149_4_, p_94149_2_ + 0, this.zLevel, p_94149_3_.getMaxU(), p_94149_3_.getMinV());
        var6.addVertexWithUV(p_94149_1_ + 0, p_94149_2_ + 0, this.zLevel, p_94149_3_.getMinU(), p_94149_3_.getMinV());
        var6.draw();
    }

    @Override
    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return this.getEntityTexture((EntityItem)p_110775_1_);
    }

    @Override
    public void doRender(Entity p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityItem)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }
}

