/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RendererLivingEntity {
    private static final ResourceLocation steveTextures = new ResourceLocation("textures/entity/steve.png");
    private ModelBiped modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private static final String __OBFID = "CL_00001020";

    public RenderPlayer() {
        super(new ModelBiped(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
    }

    protected int shouldRenderPass(AbstractClientPlayer p_77032_1_, int p_77032_2_, float p_77032_3_) {
        Item var5;
        ItemStack var4 = p_77032_1_.inventory.armorItemInSlot(3 - p_77032_2_);
        if (var4 != null && (var5 = var4.getItem()) instanceof ItemArmor) {
            ItemArmor var6 = (ItemArmor)var5;
            this.bindTexture(RenderBiped.func_110857_a(var6, p_77032_2_));
            ModelBiped var7 = p_77032_2_ == 2 ? this.modelArmor : this.modelArmorChestplate;
            var7.bipedHead.showModel = p_77032_2_ == 0;
            var7.bipedHeadwear.showModel = p_77032_2_ == 0;
            var7.bipedBody.showModel = p_77032_2_ == 1 || p_77032_2_ == 2;
            var7.bipedRightArm.showModel = p_77032_2_ == 1;
            var7.bipedLeftArm.showModel = p_77032_2_ == 1;
            var7.bipedRightLeg.showModel = p_77032_2_ == 2 || p_77032_2_ == 3;
            var7.bipedLeftLeg.showModel = p_77032_2_ == 2 || p_77032_2_ == 3;
            this.setRenderPassModel(var7);
            var7.onGround = this.mainModel.onGround;
            var7.isRiding = this.mainModel.isRiding;
            var7.isChild = this.mainModel.isChild;
            if (var6.getArmorMaterial() == ItemArmor.ArmorMaterial.CLOTH) {
                int var8 = var6.getColor(var4);
                float var9 = (float)(var8 >> 16 & 0xFF) / 255.0f;
                float var10 = (float)(var8 >> 8 & 0xFF) / 255.0f;
                float var11 = (float)(var8 & 0xFF) / 255.0f;
                GL11.glColor3f((float)var9, (float)var10, (float)var11);
                if (var4.isItemEnchanted()) {
                    return 31;
                }
                return 16;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (var4.isItemEnchanted()) {
                return 15;
            }
            return 1;
        }
        return -1;
    }

    protected void func_82408_c(AbstractClientPlayer p_82408_1_, int p_82408_2_, float p_82408_3_) {
        Item var5;
        ItemStack var4 = p_82408_1_.inventory.armorItemInSlot(3 - p_82408_2_);
        if (var4 != null && (var5 = var4.getItem()) instanceof ItemArmor) {
            this.bindTexture(RenderBiped.func_110858_a((ItemArmor)var5, p_82408_2_, "overlay"));
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void doRender(AbstractClientPlayer p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack var10 = p_76986_1_.inventory.getCurrentItem();
        this.modelBipedMain.heldItemRight = var10 != null ? 1 : 0;
        this.modelArmor.heldItemRight = this.modelBipedMain.heldItemRight;
        this.modelArmorChestplate.heldItemRight = this.modelBipedMain.heldItemRight;
        if (var10 != null && p_76986_1_.getItemInUseCount() > 0) {
            EnumAction var11 = var10.getItemUseAction();
            if (var11 == EnumAction.block) {
                this.modelBipedMain.heldItemRight = 3;
                this.modelArmor.heldItemRight = 3;
                this.modelArmorChestplate.heldItemRight = 3;
            } else if (var11 == EnumAction.bow) {
                this.modelBipedMain.aimedBow = true;
                this.modelArmor.aimedBow = true;
                this.modelArmorChestplate.aimedBow = true;
            }
        }
        this.modelArmor.isSneak = this.modelBipedMain.isSneak = p_76986_1_.isSneaking();
        this.modelArmorChestplate.isSneak = this.modelBipedMain.isSneak;
        double var13 = p_76986_4_ - (double)p_76986_1_.yOffset;
        if (p_76986_1_.isSneaking() && !(p_76986_1_ instanceof EntityPlayerSP)) {
            var13 -= 0.125;
        }
        super.doRender(p_76986_1_, p_76986_2_, var13, p_76986_6_, p_76986_8_, p_76986_9_);
        this.modelBipedMain.aimedBow = false;
        this.modelArmor.aimedBow = false;
        this.modelArmorChestplate.aimedBow = false;
        this.modelBipedMain.isSneak = false;
        this.modelArmor.isSneak = false;
        this.modelArmorChestplate.isSneak = false;
        this.modelBipedMain.heldItemRight = 0;
        this.modelArmor.heldItemRight = 0;
        this.modelArmorChestplate.heldItemRight = 0;
    }

    protected ResourceLocation getEntityTexture(AbstractClientPlayer p_110775_1_) {
        return p_110775_1_.getLocationSkin();
    }

    protected void renderEquippedItems(AbstractClientPlayer p_77029_1_, float p_77029_2_) {
        ItemStack var24;
        boolean var21;
        float var7;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        super.renderEquippedItems(p_77029_1_, p_77029_2_);
        super.renderArrowsStuckInEntity(p_77029_1_, p_77029_2_);
        ItemStack var3 = p_77029_1_.inventory.armorItemInSlot(3);
        if (var3 != null) {
            float var4;
            GL11.glPushMatrix();
            this.modelBipedMain.bipedHead.postRender(0.0625f);
            if (var3.getItem() instanceof ItemBlock) {
                if (RenderBlocks.renderItemIn3d(Block.getBlockFromItem(var3.getItem()).getRenderType())) {
                    var4 = 0.625f;
                    GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glScalef((float)var4, (float)(-var4), (float)(-var4));
                }
                this.renderManager.itemRenderer.renderItem(p_77029_1_, var3, 0);
            } else if (var3.getItem() == Items.skull) {
                var4 = 1.0625f;
                GL11.glScalef((float)var4, (float)(-var4), (float)(-var4));
                GameProfile var5 = null;
                if (var3.hasTagCompound()) {
                    NBTTagCompound var6 = var3.getTagCompound();
                    if (var6.func_150297_b("SkullOwner", 10)) {
                        var5 = NBTUtil.func_152459_a(var6.getCompoundTag("SkullOwner"));
                    } else if (var6.func_150297_b("SkullOwner", 8) && !StringUtils.isNullOrEmpty(var6.getString("SkullOwner"))) {
                        var5 = new GameProfile(null, var6.getString("SkullOwner"));
                    }
                }
                TileEntitySkullRenderer.field_147536_b.func_152674_a(-0.5f, 0.0f, -0.5f, 1, 180.0f, var3.getItemDamage(), var5);
            }
            GL11.glPopMatrix();
        }
        if (p_77029_1_.getCommandSenderName().equals("deadmau5") && p_77029_1_.func_152123_o()) {
            this.bindTexture(p_77029_1_.getLocationSkin());
            int var20 = 0;
            while (var20 < 2) {
                float var22 = p_77029_1_.prevRotationYaw + (p_77029_1_.rotationYaw - p_77029_1_.prevRotationYaw) * p_77029_2_ - (p_77029_1_.prevRenderYawOffset + (p_77029_1_.renderYawOffset - p_77029_1_.prevRenderYawOffset) * p_77029_2_);
                float var25 = p_77029_1_.prevRotationPitch + (p_77029_1_.rotationPitch - p_77029_1_.prevRotationPitch) * p_77029_2_;
                GL11.glPushMatrix();
                GL11.glRotatef((float)var22, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)var25, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.375f * (float)(var20 * 2 - 1)), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                GL11.glRotatef((float)(-var25), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-var22), (float)0.0f, (float)1.0f, (float)0.0f);
                var7 = 1.3333334f;
                GL11.glScalef((float)var7, (float)var7, (float)var7);
                this.modelBipedMain.renderEars(0.0625f);
                GL11.glPopMatrix();
                ++var20;
            }
        }
        if ((var21 = p_77029_1_.func_152122_n()) && !p_77029_1_.isInvisible() && !p_77029_1_.getHideCape()) {
            this.bindTexture(p_77029_1_.getLocationCape());
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double var23 = p_77029_1_.field_71091_bM + (p_77029_1_.field_71094_bP - p_77029_1_.field_71091_bM) * (double)p_77029_2_ - (p_77029_1_.prevPosX + (p_77029_1_.posX - p_77029_1_.prevPosX) * (double)p_77029_2_);
            double var27 = p_77029_1_.field_71096_bN + (p_77029_1_.field_71095_bQ - p_77029_1_.field_71096_bN) * (double)p_77029_2_ - (p_77029_1_.prevPosY + (p_77029_1_.posY - p_77029_1_.prevPosY) * (double)p_77029_2_);
            double var9 = p_77029_1_.field_71097_bO + (p_77029_1_.field_71085_bR - p_77029_1_.field_71097_bO) * (double)p_77029_2_ - (p_77029_1_.prevPosZ + (p_77029_1_.posZ - p_77029_1_.prevPosZ) * (double)p_77029_2_);
            float var11 = p_77029_1_.prevRenderYawOffset + (p_77029_1_.renderYawOffset - p_77029_1_.prevRenderYawOffset) * p_77029_2_;
            double var12 = MathHelper.sin(var11 * (float)Math.PI / 180.0f);
            double var14 = -MathHelper.cos(var11 * (float)Math.PI / 180.0f);
            float var16 = (float)var27 * 10.0f;
            if (var16 < -6.0f) {
                var16 = -6.0f;
            }
            if (var16 > 32.0f) {
                var16 = 32.0f;
            }
            float var17 = (float)(var23 * var12 + var9 * var14) * 100.0f;
            float var18 = (float)(var23 * var14 - var9 * var12) * 100.0f;
            if (var17 < 0.0f) {
                var17 = 0.0f;
            }
            float var19 = p_77029_1_.prevCameraYaw + (p_77029_1_.cameraYaw - p_77029_1_.prevCameraYaw) * p_77029_2_;
            var16 += MathHelper.sin((p_77029_1_.prevDistanceWalkedModified + (p_77029_1_.distanceWalkedModified - p_77029_1_.prevDistanceWalkedModified) * p_77029_2_) * 6.0f) * 32.0f * var19;
            if (p_77029_1_.isSneaking()) {
                var16 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + var17 / 2.0f + var16), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(var18 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-var18 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((var24 = p_77029_1_.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (p_77029_1_.fishEntity != null) {
                var24 = new ItemStack(Items.stick);
            }
            EnumAction var26 = null;
            if (p_77029_1_.getItemInUseCount() > 0) {
                var26 = var24.getItemUseAction();
            }
            if (var24.getItem() instanceof ItemBlock && RenderBlocks.renderItemIn3d(Block.getBlockFromItem(var24.getItem()).getRenderType())) {
                var7 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(-(var7 *= 0.75f)), (float)(-var7), (float)var7);
            } else if (var24.getItem() == Items.bow) {
                var7 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)var7, (float)(-var7), (float)var7);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (var24.getItem().isFull3D()) {
                var7 = 0.625f;
                if (var24.getItem().shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                if (p_77029_1_.getItemInUseCount() > 0 && var26 == EnumAction.block) {
                    GL11.glTranslatef((float)0.05f, (float)0.0f, (float)-0.1f);
                    GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)var7, (float)(-var7), (float)var7);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                var7 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)var7, (float)var7, (float)var7);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (var24.getItem().requiresMultipleRenderPasses()) {
                int var28 = 0;
                while (var28 <= 1) {
                    int var8 = var24.getItem().getColorFromItemStack(var24, var28);
                    float var30 = (float)(var8 >> 16 & 0xFF) / 255.0f;
                    float var10 = (float)(var8 >> 8 & 0xFF) / 255.0f;
                    float var11 = (float)(var8 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)var30, (float)var10, (float)var11, (float)1.0f);
                    this.renderManager.itemRenderer.renderItem(p_77029_1_, var24, var28);
                    ++var28;
                }
            } else {
                int var28 = var24.getItem().getColorFromItemStack(var24, 0);
                float var29 = (float)(var28 >> 16 & 0xFF) / 255.0f;
                float var30 = (float)(var28 >> 8 & 0xFF) / 255.0f;
                float var10 = (float)(var28 & 0xFF) / 255.0f;
                GL11.glColor4f((float)var29, (float)var30, (float)var10, (float)1.0f);
                this.renderManager.itemRenderer.renderItem(p_77029_1_, var24, 0);
            }
            GL11.glPopMatrix();
        }
    }

    protected void preRenderCallback(AbstractClientPlayer p_77041_1_, float p_77041_2_) {
        float var3 = 0.9375f;
        GL11.glScalef((float)var3, (float)var3, (float)var3);
    }

    protected void func_96449_a(AbstractClientPlayer p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_, float p_96449_9_, double p_96449_10_) {
        Scoreboard var12;
        ScoreObjective var13;
        if (p_96449_10_ < 100.0 && (var13 = (var12 = p_96449_1_.getWorldScoreboard()).func_96539_a(2)) != null) {
            Score var14 = var12.func_96529_a(p_96449_1_.getCommandSenderName(), var13);
            if (p_96449_1_.isPlayerSleeping()) {
                this.func_147906_a(p_96449_1_, String.valueOf(var14.getScorePoints()) + " " + var13.getDisplayName(), p_96449_2_, p_96449_4_ - 1.5, p_96449_6_, 64);
            } else {
                this.func_147906_a(p_96449_1_, String.valueOf(var14.getScorePoints()) + " " + var13.getDisplayName(), p_96449_2_, p_96449_4_, p_96449_6_, 64);
            }
            p_96449_4_ += (double)((float)this.getFontRendererFromRenderManager().FONT_HEIGHT * 1.15f * p_96449_9_);
        }
        super.func_96449_a(p_96449_1_, p_96449_2_, p_96449_4_, p_96449_6_, p_96449_8_, p_96449_9_, p_96449_10_);
    }

    public void renderFirstPersonArm(EntityPlayer p_82441_1_) {
        float var2 = 1.0f;
        GL11.glColor3f((float)var2, (float)var2, (float)var2);
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, p_82441_1_);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    protected void renderLivingAt(AbstractClientPlayer p_77039_1_, double p_77039_2_, double p_77039_4_, double p_77039_6_) {
        if (p_77039_1_.isEntityAlive() && p_77039_1_.isPlayerSleeping()) {
            super.renderLivingAt(p_77039_1_, p_77039_2_ + (double)p_77039_1_.field_71079_bU, p_77039_4_ + (double)p_77039_1_.field_71082_cx, p_77039_6_ + (double)p_77039_1_.field_71089_bV);
        } else {
            super.renderLivingAt(p_77039_1_, p_77039_2_, p_77039_4_, p_77039_6_);
        }
    }

    protected void rotateCorpse(AbstractClientPlayer p_77043_1_, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        if (p_77043_1_.isEntityAlive() && p_77043_1_.isPlayerSleeping()) {
            GL11.glRotatef((float)p_77043_1_.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getDeathMaxRotation(p_77043_1_), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.rotateCorpse(p_77043_1_, p_77043_2_, p_77043_3_, p_77043_4_);
        }
    }

    @Override
    protected void func_96449_a(EntityLivingBase p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_, float p_96449_9_, double p_96449_10_) {
        this.func_96449_a((AbstractClientPlayer)p_96449_1_, p_96449_2_, p_96449_4_, p_96449_6_, p_96449_8_, p_96449_9_, p_96449_10_);
    }

    @Override
    protected void preRenderCallback(EntityLivingBase p_77041_1_, float p_77041_2_) {
        this.preRenderCallback((AbstractClientPlayer)p_77041_1_, p_77041_2_);
    }

    @Override
    protected void func_82408_c(EntityLivingBase p_82408_1_, int p_82408_2_, float p_82408_3_) {
        this.func_82408_c((AbstractClientPlayer)p_82408_1_, p_82408_2_, p_82408_3_);
    }

    @Override
    protected int shouldRenderPass(EntityLivingBase p_77032_1_, int p_77032_2_, float p_77032_3_) {
        return this.shouldRenderPass((AbstractClientPlayer)p_77032_1_, p_77032_2_, p_77032_3_);
    }

    @Override
    protected void renderEquippedItems(EntityLivingBase p_77029_1_, float p_77029_2_) {
        this.renderEquippedItems((AbstractClientPlayer)p_77029_1_, p_77029_2_);
    }

    @Override
    protected void rotateCorpse(EntityLivingBase p_77043_1_, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        this.rotateCorpse((AbstractClientPlayer)p_77043_1_, p_77043_2_, p_77043_3_, p_77043_4_);
    }

    @Override
    protected void renderLivingAt(EntityLivingBase p_77039_1_, double p_77039_2_, double p_77039_4_, double p_77039_6_) {
        this.renderLivingAt((AbstractClientPlayer)p_77039_1_, p_77039_2_, p_77039_4_, p_77039_6_);
    }

    @Override
    public void doRender(EntityLivingBase p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((AbstractClientPlayer)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }

    @Override
    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return this.getEntityTexture((AbstractClientPlayer)p_110775_1_);
    }

    @Override
    public void doRender(Entity p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((AbstractClientPlayer)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }
}

