/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderWolf
extends RenderLiving {
    private static final ResourceLocation wolfTextures = new ResourceLocation("textures/entity/wolf/wolf.png");
    private static final ResourceLocation tamedWolfTextures = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    private static final ResourceLocation anrgyWolfTextures = new ResourceLocation("textures/entity/wolf/wolf_angry.png");
    private static final ResourceLocation wolfCollarTextures = new ResourceLocation("textures/entity/wolf/wolf_collar.png");
    private static final String __OBFID = "CL_00001036";

    public RenderWolf(ModelBase p_i1269_1_, ModelBase p_i1269_2_, float p_i1269_3_) {
        super(p_i1269_1_, p_i1269_3_);
        this.setRenderPassModel(p_i1269_2_);
    }

    protected float handleRotationFloat(EntityWolf p_77044_1_, float p_77044_2_) {
        return p_77044_1_.getTailRotation();
    }

    protected int shouldRenderPass(EntityWolf p_77032_1_, int p_77032_2_, float p_77032_3_) {
        if (p_77032_2_ == 0 && p_77032_1_.getWolfShaking()) {
            float var5 = p_77032_1_.getBrightness(p_77032_3_) * p_77032_1_.getShadingWhileShaking(p_77032_3_);
            this.bindTexture(wolfTextures);
            GL11.glColor3f((float)var5, (float)var5, (float)var5);
            return 1;
        }
        if (p_77032_2_ == 1 && p_77032_1_.isTamed()) {
            this.bindTexture(wolfCollarTextures);
            int var4 = p_77032_1_.getCollarColor();
            GL11.glColor3f((float)EntitySheep.fleeceColorTable[var4][0], (float)EntitySheep.fleeceColorTable[var4][1], (float)EntitySheep.fleeceColorTable[var4][2]);
            return 1;
        }
        return -1;
    }

    protected ResourceLocation getEntityTexture(EntityWolf p_110775_1_) {
        return p_110775_1_.isTamed() ? tamedWolfTextures : (p_110775_1_.isAngry() ? anrgyWolfTextures : wolfTextures);
    }

    @Override
    protected int shouldRenderPass(EntityLivingBase p_77032_1_, int p_77032_2_, float p_77032_3_) {
        return this.shouldRenderPass((EntityWolf)p_77032_1_, p_77032_2_, p_77032_3_);
    }

    @Override
    protected float handleRotationFloat(EntityLivingBase p_77044_1_, float p_77044_2_) {
        return this.handleRotationFloat((EntityWolf)p_77044_1_, p_77044_2_);
    }

    @Override
    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return this.getEntityTexture((EntityWolf)p_110775_1_);
    }
}

