/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class RendererLivingEntity
extends Render {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;
    private static final String __OBFID = "CL_00001012";

    public RendererLivingEntity(ModelBase p_i1261_1_, float p_i1261_2_) {
        this.mainModel = p_i1261_1_;
        this.shadowSize = p_i1261_2_;
    }

    public void setRenderPassModel(ModelBase p_77042_1_) {
        this.renderPassModel = p_77042_1_;
    }

    private float interpolateRotation(float p_77034_1_, float p_77034_2_, float p_77034_3_) {
        float var4 = p_77034_2_ - p_77034_1_;
        while (var4 < -180.0f) {
            var4 += 360.0f;
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        return p_77034_1_ + p_77034_3_ * var4;
    }

    public void doRender(EntityLivingBase p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.renderSwingProgress(p_76986_1_, p_76986_9_);
        if (this.renderPassModel != null) {
            this.renderPassModel.onGround = this.mainModel.onGround;
        }
        this.mainModel.isRiding = p_76986_1_.isRiding();
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        this.mainModel.isChild = p_76986_1_.isChild();
        if (this.renderPassModel != null) {
            this.renderPassModel.isChild = this.mainModel.isChild;
        }
        try {
            float var22;
            float var20;
            float var19;
            int var18;
            float var13;
            float var10 = this.interpolateRotation(p_76986_1_.prevRenderYawOffset, p_76986_1_.renderYawOffset, p_76986_9_);
            float var11 = this.interpolateRotation(p_76986_1_.prevRotationYawHead, p_76986_1_.rotationYawHead, p_76986_9_);
            if (p_76986_1_.isRiding() && p_76986_1_.ridingEntity instanceof EntityLivingBase) {
                EntityLivingBase var12 = (EntityLivingBase)p_76986_1_.ridingEntity;
                var10 = this.interpolateRotation(var12.prevRenderYawOffset, var12.renderYawOffset, p_76986_9_);
                var13 = MathHelper.wrapAngleTo180_float(var11 - var10);
                if (var13 < -85.0f) {
                    var13 = -85.0f;
                }
                if (var13 >= 85.0f) {
                    var13 = 85.0f;
                }
                var10 = var11 - var13;
                if (var13 * var13 > 2500.0f) {
                    var10 += var13 * 0.2f;
                }
            }
            float var26 = p_76986_1_.prevRotationPitch + (p_76986_1_.rotationPitch - p_76986_1_.prevRotationPitch) * p_76986_9_;
            this.renderLivingAt(p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_);
            var13 = this.handleRotationFloat(p_76986_1_, p_76986_9_);
            this.rotateCorpse(p_76986_1_, var13, var10, p_76986_9_);
            float var14 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(p_76986_1_, p_76986_9_);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * var14 - 0.0078125f), (float)0.0f);
            float var15 = p_76986_1_.prevLimbSwingAmount + (p_76986_1_.limbSwingAmount - p_76986_1_.prevLimbSwingAmount) * p_76986_9_;
            float var16 = p_76986_1_.limbSwing - p_76986_1_.limbSwingAmount * (1.0f - p_76986_9_);
            if (p_76986_1_.isChild()) {
                var16 *= 3.0f;
            }
            if (var15 > 1.0f) {
                var15 = 1.0f;
            }
            GL11.glEnable((int)3008);
            this.mainModel.setLivingAnimations(p_76986_1_, var16, var15, p_76986_9_);
            this.renderModel(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
            int var17 = 0;
            while (var17 < 4) {
                var18 = this.shouldRenderPass(p_76986_1_, var17, p_76986_9_);
                if (var18 > 0) {
                    this.renderPassModel.setLivingAnimations(p_76986_1_, var16, var15, p_76986_9_);
                    this.renderPassModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                    if ((var18 & 0xF0) == 16) {
                        this.func_82408_c(p_76986_1_, var17, p_76986_9_);
                        this.renderPassModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                    }
                    if ((var18 & 0xF) == 15) {
                        var19 = (float)p_76986_1_.ticksExisted + p_76986_9_;
                        this.bindTexture(RES_ITEM_GLINT);
                        GL11.glEnable((int)3042);
                        var20 = 0.5f;
                        GL11.glColor4f((float)var20, (float)var20, (float)var20, (float)1.0f);
                        GL11.glDepthFunc((int)514);
                        GL11.glDepthMask((boolean)false);
                        int var21 = 0;
                        while (var21 < 2) {
                            GL11.glDisable((int)2896);
                            var22 = 0.76f;
                            GL11.glColor4f((float)(0.5f * var22), (float)(0.25f * var22), (float)(0.8f * var22), (float)1.0f);
                            GL11.glBlendFunc((int)768, (int)1);
                            GL11.glMatrixMode((int)5890);
                            GL11.glLoadIdentity();
                            float var23 = var19 * (0.001f + (float)var21 * 0.003f) * 20.0f;
                            float var24 = 0.33333334f;
                            GL11.glScalef((float)var24, (float)var24, (float)var24);
                            GL11.glRotatef((float)(30.0f - (float)var21 * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.0f, (float)var23, (float)0.0f);
                            GL11.glMatrixMode((int)5888);
                            this.renderPassModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                            ++var21;
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glMatrixMode((int)5890);
                        GL11.glDepthMask((boolean)true);
                        GL11.glLoadIdentity();
                        GL11.glMatrixMode((int)5888);
                        GL11.glEnable((int)2896);
                        GL11.glDisable((int)3042);
                        GL11.glDepthFunc((int)515);
                    }
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                }
                ++var17;
            }
            GL11.glDepthMask((boolean)true);
            this.renderEquippedItems(p_76986_1_, p_76986_9_);
            float var27 = p_76986_1_.getBrightness(p_76986_9_);
            var18 = this.getColorMultiplier(p_76986_1_, var27, p_76986_9_);
            OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
            GL11.glDisable((int)3553);
            OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
            if ((var18 >> 24 & 0xFF) > 0 || p_76986_1_.hurtTime > 0 || p_76986_1_.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (p_76986_1_.hurtTime > 0 || p_76986_1_.deathTime > 0) {
                    GL11.glColor4f((float)var27, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                    int var28 = 0;
                    while (var28 < 4) {
                        if (this.inheritRenderPass(p_76986_1_, var28, p_76986_9_) >= 0) {
                            GL11.glColor4f((float)var27, (float)0.0f, (float)0.0f, (float)0.4f);
                            this.renderPassModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                        }
                        ++var28;
                    }
                }
                if ((var18 >> 24 & 0xFF) > 0) {
                    var19 = (float)(var18 >> 16 & 0xFF) / 255.0f;
                    var20 = (float)(var18 >> 8 & 0xFF) / 255.0f;
                    float var29 = (float)(var18 & 0xFF) / 255.0f;
                    var22 = (float)(var18 >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)var19, (float)var20, (float)var29, (float)var22);
                    this.mainModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                    int var30 = 0;
                    while (var30 < 4) {
                        if (this.inheritRenderPass(p_76986_1_, var30, p_76986_9_) >= 0) {
                            GL11.glColor4f((float)var19, (float)var20, (float)var29, (float)var22);
                            this.renderPassModel.render(p_76986_1_, var16, var15, var13, var11 - var10, var26, var14);
                        }
                        ++var30;
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception var25) {
            logger.error("Couldn't render entity", (Throwable)var25);
        }
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glEnable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_);
    }

    protected void renderModel(EntityLivingBase p_77036_1_, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_) {
        this.bindEntityTexture(p_77036_1_);
        if (!p_77036_1_.isInvisible()) {
            this.mainModel.render(p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
        } else if (!p_77036_1_.isInvisibleToPlayer(Minecraft.getMinecraft().thePlayer)) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            this.mainModel.render(p_77036_1_, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
        } else {
            this.mainModel.setRotationAngles(p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_, p_77036_1_);
        }
    }

    protected void renderLivingAt(EntityLivingBase p_77039_1_, double p_77039_2_, double p_77039_4_, double p_77039_6_) {
        GL11.glTranslatef((float)((float)p_77039_2_), (float)((float)p_77039_4_), (float)((float)p_77039_6_));
    }

    protected void rotateCorpse(EntityLivingBase p_77043_1_, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        GL11.glRotatef((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        if (p_77043_1_.deathTime > 0) {
            float var5 = ((float)p_77043_1_.deathTime + p_77043_4_ - 1.0f) / 20.0f * 1.6f;
            if ((var5 = MathHelper.sqrt_float(var5)) > 1.0f) {
                var5 = 1.0f;
            }
            GL11.glRotatef((float)(var5 * this.getDeathMaxRotation(p_77043_1_)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String var6 = EnumChatFormatting.getTextWithoutFormattingCodes(p_77043_1_.getCommandSenderName());
            if (!(!var6.equals("Dinnerbone") && !var6.equals("Grumm") || p_77043_1_ instanceof EntityPlayer && ((EntityPlayer)p_77043_1_).getHideCape())) {
                GL11.glTranslatef((float)0.0f, (float)(p_77043_1_.height + 0.1f), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected float renderSwingProgress(EntityLivingBase p_77040_1_, float p_77040_2_) {
        return p_77040_1_.getSwingProgress(p_77040_2_);
    }

    protected float handleRotationFloat(EntityLivingBase p_77044_1_, float p_77044_2_) {
        return (float)p_77044_1_.ticksExisted + p_77044_2_;
    }

    protected void renderEquippedItems(EntityLivingBase p_77029_1_, float p_77029_2_) {
    }

    protected void renderArrowsStuckInEntity(EntityLivingBase p_85093_1_, float p_85093_2_) {
        int var3 = p_85093_1_.getArrowCountInEntity();
        if (var3 > 0) {
            EntityArrow var4 = new EntityArrow(p_85093_1_.worldObj, p_85093_1_.posX, p_85093_1_.posY, p_85093_1_.posZ);
            Random var5 = new Random(p_85093_1_.getEntityId());
            RenderHelper.disableStandardItemLighting();
            int var6 = 0;
            while (var6 < var3) {
                GL11.glPushMatrix();
                ModelRenderer var7 = this.mainModel.getRandomModelBox(var5);
                ModelBox var8 = (ModelBox)var7.cubeList.get(var5.nextInt(var7.cubeList.size()));
                var7.postRender(0.0625f);
                float var9 = var5.nextFloat();
                float var10 = var5.nextFloat();
                float var11 = var5.nextFloat();
                float var12 = (var8.posX1 + (var8.posX2 - var8.posX1) * var9) / 16.0f;
                float var13 = (var8.posY1 + (var8.posY2 - var8.posY1) * var10) / 16.0f;
                float var14 = (var8.posZ1 + (var8.posZ2 - var8.posZ1) * var11) / 16.0f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
                var9 = var9 * 2.0f - 1.0f;
                var10 = var10 * 2.0f - 1.0f;
                var11 = var11 * 2.0f - 1.0f;
                float var15 = MathHelper.sqrt_float((var9 *= -1.0f) * var9 + (var11 *= -1.0f) * var11);
                var4.prevRotationYaw = var4.rotationYaw = (float)(Math.atan2(var9, var11) * 180.0 / Math.PI);
                var4.prevRotationPitch = var4.rotationPitch = (float)(Math.atan2(var10 *= -1.0f, var15) * 180.0 / Math.PI);
                double var16 = 0.0;
                double var18 = 0.0;
                double var20 = 0.0;
                float var22 = 0.0f;
                this.renderManager.func_147940_a(var4, var16, var18, var20, var22, p_85093_2_);
                GL11.glPopMatrix();
                ++var6;
            }
            RenderHelper.enableStandardItemLighting();
        }
    }

    protected int inheritRenderPass(EntityLivingBase p_77035_1_, int p_77035_2_, float p_77035_3_) {
        return this.shouldRenderPass(p_77035_1_, p_77035_2_, p_77035_3_);
    }

    protected int shouldRenderPass(EntityLivingBase p_77032_1_, int p_77032_2_, float p_77032_3_) {
        return -1;
    }

    protected void func_82408_c(EntityLivingBase p_82408_1_, int p_82408_2_, float p_82408_3_) {
    }

    protected float getDeathMaxRotation(EntityLivingBase p_77037_1_) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityLivingBase p_77030_1_, float p_77030_2_, float p_77030_3_) {
        return 0;
    }

    protected void preRenderCallback(EntityLivingBase p_77041_1_, float p_77041_2_) {
    }

    protected void passSpecialRender(EntityLivingBase p_77033_1_, double p_77033_2_, double p_77033_4_, double p_77033_6_) {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        if (this.func_110813_b(p_77033_1_)) {
            float var12;
            float var8 = 1.6f;
            float var9 = 0.016666668f * var8;
            double var10 = p_77033_1_.getDistanceSqToEntity(this.renderManager.livingPlayer);
            float f = var12 = p_77033_1_.isSneaking() ? 32.0f : 64.0f;
            if (var10 < (double)(var12 * var12)) {
                String var13 = p_77033_1_.func_145748_c_().getFormattedText();
                if (p_77033_1_.isSneaking()) {
                    FontRenderer var14 = this.getFontRendererFromRenderManager();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)p_77033_2_ + 0.0f), (float)((float)p_77033_4_ + p_77033_1_.height + 0.5f), (float)((float)p_77033_6_));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-var9), (float)(-var9), (float)var9);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / var9), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.glBlendFunc(770, 771, 1, 0);
                    Tessellator var15 = Tessellator.instance;
                    GL11.glDisable((int)3553);
                    var15.startDrawingQuads();
                    int var16 = var14.getStringWidth(var13) / 2;
                    var15.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    var15.addVertex(-var16 - 1, -1.0, 0.0);
                    var15.addVertex(-var16 - 1, 8.0, 0.0);
                    var15.addVertex(var16 + 1, 8.0, 0.0);
                    var15.addVertex(var16 + 1, -1.0, 0.0);
                    var15.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    var14.drawString(var13, -var14.getStringWidth(var13) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                } else {
                    this.func_96449_a(p_77033_1_, p_77033_2_, p_77033_4_, p_77033_6_, var13, var9, var10);
                }
            }
        }
    }

    protected boolean func_110813_b(EntityLivingBase p_110813_1_) {
        return Minecraft.isGuiEnabled() && p_110813_1_ != this.renderManager.livingPlayer && !p_110813_1_.isInvisibleToPlayer(Minecraft.getMinecraft().thePlayer) && p_110813_1_.riddenByEntity == null;
    }

    protected void func_96449_a(EntityLivingBase p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_, float p_96449_9_, double p_96449_10_) {
        if (p_96449_1_.isPlayerSleeping()) {
            this.func_147906_a(p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_ - 1.5, p_96449_6_, 64);
        } else {
            this.func_147906_a(p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_, p_96449_6_, 64);
        }
    }

    @Override
    public void doRender(Entity p_76986_1_, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityLivingBase)p_76986_1_, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }
}

