/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.stream;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.stream.TwitchStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.twitch.AuthToken;
import tv.twitch.ErrorCode;
import tv.twitch.chat.Chat;
import tv.twitch.chat.ChatAPI;
import tv.twitch.chat.ChatChannelInfo;
import tv.twitch.chat.ChatEvent;
import tv.twitch.chat.ChatMessage;
import tv.twitch.chat.ChatMessageList;
import tv.twitch.chat.ChatTokenizedMessage;
import tv.twitch.chat.ChatUserInfo;
import tv.twitch.chat.ChatUserList;
import tv.twitch.chat.IChatCallbacks;
import tv.twitch.chat.StandardChatAPI;

public class ChatController
implements IChatCallbacks {
    private static final Logger field_153018_p = LogManager.getLogger();
    protected ChatListener field_153003_a = null;
    protected String field_153004_b = "";
    protected String field_153005_c = "";
    protected String field_153006_d = "";
    protected String field_153007_e = "";
    protected Chat field_153008_f = null;
    protected boolean field_153009_g = false;
    protected boolean field_153010_h = false;
    protected ChatState field_153011_i = ChatState.Uninitialized;
    protected AuthToken field_153012_j = new AuthToken();
    protected List field_153013_k = new ArrayList();
    protected LinkedList field_153014_l = new LinkedList();
    protected int field_153015_m = 128;
    protected boolean field_153016_n = false;
    protected boolean field_153017_o = false;
    private static final String __OBFID = "CL_00001819";

    public void chatStatusCallback(ErrorCode p_chatStatusCallback_1_) {
        if (!ErrorCode.succeeded((ErrorCode)p_chatStatusCallback_1_)) {
            this.field_153011_i = ChatState.Disconnected;
        }
    }

    public void chatChannelMembershipCallback(ChatEvent p_chatChannelMembershipCallback_1_, ChatChannelInfo p_chatChannelMembershipCallback_2_) {
        switch (p_chatChannelMembershipCallback_1_) {
            case TTV_CHAT_JOINED_CHANNEL: {
                this.field_153011_i = ChatState.Connected;
                this.func_152999_p();
                break;
            }
            case TTV_CHAT_LEFT_CHANNEL: {
                this.field_153011_i = ChatState.Disconnected;
            }
        }
    }

    public void chatChannelUserChangeCallback(ChatUserList p_chatChannelUserChangeCallback_1_, ChatUserList p_chatChannelUserChangeCallback_2_, ChatUserList p_chatChannelUserChangeCallback_3_) {
        int var5;
        int var4 = 0;
        while (var4 < p_chatChannelUserChangeCallback_2_.userList.length) {
            var5 = this.field_153013_k.indexOf(p_chatChannelUserChangeCallback_2_.userList[var4]);
            if (var5 >= 0) {
                this.field_153013_k.remove(var5);
            }
            ++var4;
        }
        var4 = 0;
        while (var4 < p_chatChannelUserChangeCallback_3_.userList.length) {
            var5 = this.field_153013_k.indexOf(p_chatChannelUserChangeCallback_3_.userList[var4]);
            if (var5 >= 0) {
                this.field_153013_k.remove(var5);
            }
            this.field_153013_k.add(p_chatChannelUserChangeCallback_3_.userList[var4]);
            ++var4;
        }
        var4 = 0;
        while (var4 < p_chatChannelUserChangeCallback_1_.userList.length) {
            this.field_153013_k.add(p_chatChannelUserChangeCallback_1_.userList[var4]);
            ++var4;
        }
        try {
            if (this.field_153003_a != null) {
                this.field_153003_a.func_152904_a(p_chatChannelUserChangeCallback_1_.userList, p_chatChannelUserChangeCallback_2_.userList, p_chatChannelUserChangeCallback_3_.userList);
            }
        }
        catch (Exception var6) {
            this.func_152995_h(var6.toString());
        }
    }

    public void chatQueryChannelUsersCallback(ChatUserList p_chatQueryChannelUsersCallback_1_) {
    }

    public void chatChannelMessageCallback(ChatMessageList p_chatChannelMessageCallback_1_) {
        int var2 = 0;
        while (var2 < p_chatChannelMessageCallback_1_.messageList.length) {
            this.field_153014_l.addLast(p_chatChannelMessageCallback_1_.messageList[var2]);
            ++var2;
        }
        try {
            if (this.field_153003_a != null) {
                this.field_153003_a.func_152903_a(p_chatChannelMessageCallback_1_.messageList);
            }
        }
        catch (Exception var3) {
            this.func_152995_h(var3.toString());
        }
        while (this.field_153014_l.size() > this.field_153015_m) {
            this.field_153014_l.removeFirst();
        }
    }

    public void chatClearCallback(String p_chatClearCallback_1_) {
        this.func_152987_o();
    }

    public void emoticonDataDownloadCallback(ErrorCode p_emoticonDataDownloadCallback_1_) {
        if (ErrorCode.succeeded((ErrorCode)p_emoticonDataDownloadCallback_1_)) {
            this.func_152988_s();
        }
    }

    public void chatChannelTokenizedMessageCallback(ChatTokenizedMessage[] p_chatChannelTokenizedMessageCallback_1_) {
    }

    public void func_152990_a(ChatListener p_152990_1_) {
        this.field_153003_a = p_152990_1_;
    }

    public boolean func_152991_c() {
        return this.field_153011_i == ChatState.Connected;
    }

    public void func_152994_a(AuthToken p_152994_1_) {
        this.field_153012_j = p_152994_1_;
    }

    public void func_152984_a(String p_152984_1_) {
        this.field_153006_d = p_152984_1_;
    }

    public void func_152998_c(String p_152998_1_) {
        this.field_153004_b = p_152998_1_;
    }

    public ChatState func_153000_j() {
        return this.field_153011_i;
    }

    public ChatController() {
        this.field_153008_f = new Chat((ChatAPI)new StandardChatAPI());
    }

    public boolean func_152986_d(String p_152986_1_) {
        this.func_153002_l();
        this.field_153010_h = false;
        this.field_153005_c = p_152986_1_;
        return this.func_152985_f(p_152986_1_);
    }

    public boolean func_153002_l() {
        if (this.field_153011_i != ChatState.Connected && this.field_153011_i != ChatState.Connecting) {
            if (this.field_153011_i == ChatState.Disconnected) {
                this.func_152989_q();
            }
        } else {
            ErrorCode var1 = this.field_153008_f.disconnect();
            if (ErrorCode.failed((ErrorCode)var1)) {
                String var2 = ErrorCode.getString((ErrorCode)var1);
                this.func_152995_h(String.format("Error disconnecting: %s", var2));
                return false;
            }
            this.func_152989_q();
        }
        return this.func_152993_m();
    }

    protected boolean func_152985_f(String p_152985_1_) {
        if (this.field_153009_g) {
            return false;
        }
        ErrorCode var2 = this.field_153008_f.initialize(p_152985_1_, false);
        if (ErrorCode.failed((ErrorCode)var2)) {
            String var3 = ErrorCode.getString((ErrorCode)var2);
            this.func_152995_h(String.format("Error initializing chat: %s", var3));
            this.func_152989_q();
            return false;
        }
        this.field_153009_g = true;
        this.field_153008_f.setChatCallbacks((IChatCallbacks)this);
        this.field_153011_i = ChatState.Initialized;
        return true;
    }

    protected boolean func_152993_m() {
        ErrorCode var1;
        if (this.field_153009_g && ErrorCode.failed((ErrorCode)(var1 = this.field_153008_f.shutdown()))) {
            String var2 = ErrorCode.getString((ErrorCode)var1);
            this.func_152995_h(String.format("Error shutting down chat: %s", var2));
            return false;
        }
        this.field_153011_i = ChatState.Uninitialized;
        this.field_153009_g = false;
        this.func_152996_t();
        this.field_153008_f.setChatCallbacks(null);
        return true;
    }

    public void func_152997_n() {
        if (this.field_153009_g) {
            String var2;
            ErrorCode var1 = this.field_153008_f.flushEvents();
            if (ErrorCode.failed((ErrorCode)var1)) {
                var2 = ErrorCode.getString((ErrorCode)var1);
                this.func_152995_h(String.format("Error flushing chat events: %s", var2));
            }
            switch (this.field_153011_i) {
                default: {
                    break;
                }
                case Initialized: {
                    var1 = this.field_153010_h ? this.field_153008_f.connectAnonymous() : this.field_153008_f.connect(this.field_153005_c, this.field_153012_j.data);
                    if (ErrorCode.failed((ErrorCode)var1)) {
                        var2 = ErrorCode.getString((ErrorCode)var1);
                        this.func_152995_h(String.format("Error connecting: %s", var2));
                        this.func_152993_m();
                        this.func_152989_q();
                        break;
                    }
                    this.field_153011_i = ChatState.Connecting;
                    this.func_153001_r();
                    break;
                }
                case Disconnected: {
                    this.func_153002_l();
                }
            }
        }
    }

    public boolean func_152992_g(String p_152992_1_) {
        if (this.field_153011_i != ChatState.Connected) {
            return false;
        }
        ErrorCode var2 = this.field_153008_f.sendMessage(p_152992_1_);
        if (ErrorCode.failed((ErrorCode)var2)) {
            String var3 = ErrorCode.getString((ErrorCode)var2);
            this.func_152995_h(String.format("Error sending chat message: %s", var3));
            return false;
        }
        return true;
    }

    public void func_152987_o() {
        this.field_153014_l.clear();
        try {
            if (this.field_153003_a != null) {
                this.field_153003_a.func_152902_f();
            }
        }
        catch (Exception var2) {
            this.func_152995_h(var2.toString());
        }
    }

    protected void func_152999_p() {
        try {
            if (this.field_153003_a != null) {
                this.field_153003_a.func_152906_d();
            }
        }
        catch (Exception var2) {
            this.func_152995_h(var2.toString());
        }
    }

    protected void func_152989_q() {
        try {
            if (this.field_153003_a != null) {
                this.field_153003_a.func_152905_e();
            }
        }
        catch (Exception var2) {
            this.func_152995_h(var2.toString());
        }
    }

    protected void func_153001_r() {
    }

    protected void func_152988_s() {
    }

    protected void func_152996_t() {
    }

    protected void func_152995_h(String p_152995_1_) {
        field_153018_p.error(TwitchStream.field_152949_a, "[Chat controller] {}", new Object[]{p_152995_1_});
    }

    public static interface ChatListener {
        public void func_152903_a(ChatMessage[] var1);

        public void func_152904_a(ChatUserInfo[] var1, ChatUserInfo[] var2, ChatUserInfo[] var3);

        public void func_152906_d();

        public void func_152905_e();

        public void func_152902_f();
    }

    public static enum ChatState {
        Uninitialized("Uninitialized", 0),
        Initialized("Initialized", 1),
        Connecting("Connecting", 2),
        Connected("Connected", 3),
        Disconnected("Disconnected", 4);

        private static final ChatState[] $VALUES;
        private static final String __OBFID = "CL_00001817";

        static {
            $VALUES = new ChatState[]{Uninitialized, Initialized, Connecting, Connected, Disconnected};
        }

        private ChatState(String p_i1021_1_, int p_i1021_2_) {
        }
    }
}

