/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.stream;

import java.util.ArrayList;
import java.util.List;
import tv.twitch.AuthToken;
import tv.twitch.ErrorCode;
import tv.twitch.broadcast.ArchivingState;
import tv.twitch.broadcast.AudioParams;
import tv.twitch.broadcast.ChannelInfo;
import tv.twitch.broadcast.EncodingCpuUsage;
import tv.twitch.broadcast.FrameBuffer;
import tv.twitch.broadcast.GameInfoList;
import tv.twitch.broadcast.IStatCallbacks;
import tv.twitch.broadcast.IStreamCallbacks;
import tv.twitch.broadcast.IngestList;
import tv.twitch.broadcast.IngestServer;
import tv.twitch.broadcast.PixelFormat;
import tv.twitch.broadcast.RTMPState;
import tv.twitch.broadcast.StartFlags;
import tv.twitch.broadcast.StatType;
import tv.twitch.broadcast.Stream;
import tv.twitch.broadcast.StreamInfo;
import tv.twitch.broadcast.UserInfo;
import tv.twitch.broadcast.VideoParams;

public class IngestServerTester
implements IStatCallbacks,
IStreamCallbacks {
    protected final boolean field_153043_a = true;
    protected IngestTestListener field_153044_b = null;
    protected Stream field_153045_c = null;
    protected IngestList field_153046_d = null;
    protected IngestTestState field_153047_e = IngestTestState.Uninitalized;
    protected long field_153048_f = 8000L;
    protected long field_153049_g = 1000L;
    protected long field_153050_h = 0L;
    protected RTMPState field_153051_i = RTMPState.Invalid;
    protected VideoParams field_153052_j = null;
    protected AudioParams field_153053_k = null;
    protected long field_153054_l = 0L;
    protected List field_153055_m = null;
    protected boolean field_153056_n = false;
    protected IStreamCallbacks field_153057_o = null;
    protected IStatCallbacks field_153058_p = null;
    protected IngestServer field_153059_q = null;
    protected boolean field_153060_r = false;
    protected boolean field_153061_s = false;
    protected int field_153062_t = -1;
    protected int field_153063_u = 0;
    protected long field_153064_v = 0L;
    protected float field_153065_w = 0.0f;
    protected float field_153066_x = 0.0f;
    protected boolean field_153067_y = false;
    private static final String __OBFID = "CL_00001816";

    public void func_153042_a(IngestTestListener p_153042_1_) {
        this.field_153044_b = p_153042_1_;
    }

    public IngestServer func_153040_c() {
        return this.field_153059_q;
    }

    public boolean func_153032_e() {
        return this.field_153047_e == IngestTestState.Finished || this.field_153047_e == IngestTestState.Cancelled || this.field_153047_e == IngestTestState.Failed;
    }

    public float func_153030_h() {
        return this.field_153066_x;
    }

    public void requestAuthTokenCallback(ErrorCode p_requestAuthTokenCallback_1_, AuthToken p_requestAuthTokenCallback_2_) {
    }

    public void loginCallback(ErrorCode p_loginCallback_1_, ChannelInfo p_loginCallback_2_) {
    }

    public void getIngestServersCallback(ErrorCode p_getIngestServersCallback_1_, IngestList p_getIngestServersCallback_2_) {
    }

    public void getUserInfoCallback(ErrorCode p_getUserInfoCallback_1_, UserInfo p_getUserInfoCallback_2_) {
    }

    public void getStreamInfoCallback(ErrorCode p_getStreamInfoCallback_1_, StreamInfo p_getStreamInfoCallback_2_) {
    }

    public void getArchivingStateCallback(ErrorCode p_getArchivingStateCallback_1_, ArchivingState p_getArchivingStateCallback_2_) {
    }

    public void runCommercialCallback(ErrorCode p_runCommercialCallback_1_) {
    }

    public void setStreamInfoCallback(ErrorCode p_setStreamInfoCallback_1_) {
    }

    public void getGameNameListCallback(ErrorCode p_getGameNameListCallback_1_, GameInfoList p_getGameNameListCallback_2_) {
    }

    public void bufferUnlockCallback(long p_bufferUnlockCallback_1_) {
    }

    public void startCallback(ErrorCode p_startCallback_1_) {
        this.field_153067_y = false;
        if (ErrorCode.succeeded((ErrorCode)p_startCallback_1_)) {
            this.func_153034_a(IngestTestState.ConnectingToServer);
            this.field_153054_l = System.currentTimeMillis();
        } else {
            this.field_153056_n = false;
            this.func_153034_a(IngestTestState.DoneTestingServer);
        }
    }

    public void stopCallback(ErrorCode p_stopCallback_1_) {
        this.field_153067_y = false;
        this.func_153034_a(IngestTestState.DoneTestingServer);
    }

    public void sendActionMetaDataCallback(ErrorCode p_sendActionMetaDataCallback_1_) {
    }

    public void sendStartSpanMetaDataCallback(ErrorCode p_sendStartSpanMetaDataCallback_1_) {
    }

    public void sendEndSpanMetaDataCallback(ErrorCode p_sendEndSpanMetaDataCallback_1_) {
    }

    public void statCallback(StatType p_statCallback_1_, long p_statCallback_2_) {
        switch (p_statCallback_1_) {
            case TTV_ST_RTMPSTATE: {
                this.field_153051_i = RTMPState.lookupValue((int)((int)p_statCallback_2_));
                break;
            }
            case TTV_ST_RTMPDATASENT: {
                this.field_153050_h = p_statCallback_2_;
            }
        }
    }

    public IngestServerTester(Stream p_i1019_1_, IngestList p_i1019_2_) {
        this.field_153045_c = p_i1019_1_;
        this.field_153046_d = p_i1019_2_;
    }

    protected void finalize() throws Throwable {
        if (this.field_153059_q != null) {
            this.func_153035_b(this.field_153059_q);
        }
        this.func_153031_o();
        super.finalize();
    }

    public void func_153033_i() {
        if (this.field_153047_e == IngestTestState.Uninitalized) {
            this.field_153062_t = 0;
            this.field_153060_r = false;
            this.field_153061_s = false;
            this.field_153058_p = this.field_153045_c.getStatCallbacks();
            this.field_153045_c.setStatCallbacks((IStatCallbacks)this);
            this.field_153057_o = this.field_153045_c.getStreamCallbacks();
            this.field_153045_c.setStreamCallbacks((IStreamCallbacks)this);
            this.field_153052_j = new VideoParams();
            this.field_153052_j.targetFps = 60;
            this.field_153052_j.maxKbps = 3500;
            this.field_153052_j.outputWidth = 1280;
            this.field_153052_j.outputHeight = 720;
            this.field_153052_j.pixelFormat = PixelFormat.TTV_PF_BGRA;
            this.field_153052_j.encodingCpuUsage = EncodingCpuUsage.TTV_ECU_HIGH;
            this.field_153052_j.disableAdaptiveBitrate = true;
            this.field_153052_j.verticalFlip = false;
            this.field_153045_c.getDefaultParams(this.field_153052_j);
            this.field_153053_k = new AudioParams();
            this.field_153053_k.audioEnabled = false;
            this.field_153055_m = new ArrayList();
            int var1 = 3;
            int var2 = 0;
            while (var2 < var1) {
                FrameBuffer var3 = this.field_153045_c.allocateFrameBuffer(this.field_153052_j.outputWidth * this.field_153052_j.outputHeight * 4);
                if (!var3.getIsValid()) {
                    this.func_153031_o();
                    this.func_153034_a(IngestTestState.Failed);
                    return;
                }
                this.field_153055_m.add(var3);
                this.field_153045_c.randomizeFrameBuffer(var3);
                ++var2;
            }
            this.func_153034_a(IngestTestState.Starting);
            this.field_153054_l = System.currentTimeMillis();
        }
    }

    public void func_153041_j() {
        if (!this.func_153032_e() && this.field_153047_e != IngestTestState.Uninitalized && !this.field_153067_y) {
            if (this.field_153060_r) {
                this.func_153034_a(IngestTestState.Cancelled);
            }
            switch (this.field_153047_e) {
                case Starting: 
                case DoneTestingServer: {
                    if (this.field_153059_q != null) {
                        if (!this.field_153061_s && this.field_153056_n) {
                            this.func_153035_b(this.field_153059_q);
                        } else {
                            this.field_153059_q.bitrateKbps = 0.0f;
                            this.field_153054_l = 0L;
                            this.field_153067_y = false;
                        }
                        this.field_153059_q = null;
                        break;
                    }
                    if (this.field_153067_y || this.func_153037_m() < this.field_153049_g) break;
                    this.field_153054_l = 0L;
                    this.field_153061_s = false;
                    this.field_153056_n = true;
                    if (this.field_153047_e != IngestTestState.Starting) {
                        ++this.field_153062_t;
                    }
                    if (this.field_153062_t < this.field_153046_d.getServers().length) {
                        this.field_153059_q = this.field_153046_d.getServers()[this.field_153062_t];
                        this.func_153036_a(this.field_153059_q);
                        break;
                    }
                    this.func_153034_a(IngestTestState.Finished);
                    break;
                }
                case ConnectingToServer: 
                case TestingServer: {
                    this.func_153029_c(this.field_153059_q);
                }
            }
            this.func_153038_n();
            if (this.field_153047_e == IngestTestState.Cancelled || this.field_153047_e == IngestTestState.Finished) {
                if (this.field_153059_q != null) {
                    if (this.field_153047_e == IngestTestState.Cancelled) {
                        this.field_153059_q.bitrateKbps = 0.0f;
                    }
                    this.func_153035_b(this.field_153059_q);
                    this.field_153059_q = null;
                }
                if (this.field_153055_m != null) {
                    this.func_153031_o();
                }
            }
        }
    }

    public void func_153039_l() {
        if (!this.func_153032_e()) {
            this.field_153060_r = true;
        }
    }

    protected boolean func_153036_a(IngestServer p_153036_1_) {
        this.field_153056_n = true;
        this.field_153050_h = 0L;
        this.field_153051_i = RTMPState.Idle;
        this.field_153059_q = p_153036_1_;
        this.func_153034_a(IngestTestState.ConnectingToServer);
        this.field_153067_y = true;
        ErrorCode var2 = this.field_153045_c.start(this.field_153052_j, this.field_153053_k, p_153036_1_, StartFlags.TTV_Start_BandwidthTest, true);
        if (ErrorCode.failed((ErrorCode)var2)) {
            this.field_153056_n = false;
            this.func_153034_a(IngestTestState.DoneTestingServer);
            return false;
        }
        this.field_153064_v = this.field_153050_h;
        p_153036_1_.bitrateKbps = 0.0f;
        this.field_153063_u = 0;
        return true;
    }

    protected void func_153035_b(IngestServer p_153035_1_) {
        this.field_153067_y = true;
        this.field_153045_c.stop(true);
        this.field_153045_c.pollStats();
    }

    protected long func_153037_m() {
        return System.currentTimeMillis() - this.field_153054_l;
    }

    protected void func_153038_n() {
        float var1 = this.func_153037_m();
        switch (this.field_153047_e) {
            case Starting: 
            case ConnectingToServer: 
            case Uninitalized: 
            case Finished: 
            case Cancelled: 
            case Failed: {
                this.field_153066_x = 0.0f;
                break;
            }
            case DoneTestingServer: {
                this.field_153066_x = 1.0f;
                break;
            }
            default: {
                this.field_153066_x = var1 / (float)this.field_153048_f;
            }
        }
        switch (this.field_153047_e) {
            case Finished: 
            case Cancelled: 
            case Failed: {
                this.field_153065_w = 1.0f;
                break;
            }
            default: {
                this.field_153065_w = (float)this.field_153062_t / (float)this.field_153046_d.getServers().length;
                this.field_153065_w += this.field_153066_x / (float)this.field_153046_d.getServers().length;
            }
        }
    }

    protected boolean func_153029_c(IngestServer p_153029_1_) {
        if (!this.field_153061_s && this.func_153037_m() < this.field_153048_f) {
            if (this.field_153067_y) {
                return true;
            }
            ErrorCode var2 = this.field_153045_c.submitVideoFrame((FrameBuffer)this.field_153055_m.get(this.field_153063_u));
            if (ErrorCode.failed((ErrorCode)var2)) {
                this.field_153056_n = false;
                this.func_153034_a(IngestTestState.DoneTestingServer);
                return false;
            }
            this.field_153063_u = (this.field_153063_u + 1) % this.field_153055_m.size();
            this.field_153045_c.pollStats();
            if (this.field_153051_i == RTMPState.SendVideo) {
                this.func_153034_a(IngestTestState.TestingServer);
                long var3 = this.func_153037_m();
                if (var3 > 0L && this.field_153050_h > this.field_153064_v) {
                    p_153029_1_.bitrateKbps = (float)(this.field_153050_h * 8L) / (float)this.func_153037_m();
                    this.field_153064_v = this.field_153050_h;
                }
            }
            return true;
        }
        this.func_153034_a(IngestTestState.DoneTestingServer);
        return true;
    }

    protected void func_153031_o() {
        this.field_153059_q = null;
        if (this.field_153055_m != null) {
            int var1 = 0;
            while (var1 < this.field_153055_m.size()) {
                ((FrameBuffer)this.field_153055_m.get(var1)).free();
                ++var1;
            }
            this.field_153055_m = null;
        }
        if (this.field_153045_c.getStatCallbacks() == this) {
            this.field_153045_c.setStatCallbacks(this.field_153058_p);
            this.field_153058_p = null;
        }
        if (this.field_153045_c.getStreamCallbacks() == this) {
            this.field_153045_c.setStreamCallbacks(this.field_153057_o);
            this.field_153057_o = null;
        }
    }

    protected void func_153034_a(IngestTestState p_153034_1_) {
        if (p_153034_1_ != this.field_153047_e) {
            this.field_153047_e = p_153034_1_;
            if (this.field_153044_b != null) {
                this.field_153044_b.func_152907_a(this, p_153034_1_);
            }
        }
    }

    public int func_153028_p() {
        return this.field_153062_t;
    }

    public static interface IngestTestListener {
        public void func_152907_a(IngestServerTester var1, IngestTestState var2);
    }

    public static enum IngestTestState {
        Uninitalized("Uninitalized", 0),
        Starting("Starting", 1),
        ConnectingToServer("ConnectingToServer", 2),
        TestingServer("TestingServer", 3),
        DoneTestingServer("DoneTestingServer", 4),
        Finished("Finished", 5),
        Cancelled("Cancelled", 6),
        Failed("Failed", 7);

        private static final IngestTestState[] $VALUES;
        private static final String __OBFID = "CL_00001814";

        static {
            $VALUES = new IngestTestState[]{Uninitalized, Starting, ConnectingToServer, TestingServer, DoneTestingServer, Finished, Cancelled, Failed};
        }

        private IngestTestState(String p_i1016_1_, int p_i1016_2_) {
        }
    }
}

