/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public class CommandEnchant
extends CommandBase {
    private static final String __OBFID = "CL_00000377";

    @Override
    public String getCommandName() {
        return "enchant";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender p_71518_1_) {
        return "commands.enchant.usage";
    }

    @Override
    public void processCommand(ICommandSender p_71515_1_, String[] p_71515_2_) {
        NBTTagList var8;
        if (p_71515_2_.length < 2) {
            throw new WrongUsageException("commands.enchant.usage", new Object[0]);
        }
        EntityPlayerMP var3 = CommandEnchant.getPlayer(p_71515_1_, p_71515_2_[0]);
        int var4 = CommandEnchant.parseIntBounded(p_71515_1_, p_71515_2_[1], 0, Enchantment.enchantmentsList.length - 1);
        int var5 = 1;
        ItemStack var6 = var3.getCurrentEquippedItem();
        if (var6 == null) {
            throw new CommandException("commands.enchant.noItem", new Object[0]);
        }
        Enchantment var7 = Enchantment.enchantmentsList[var4];
        if (var7 == null) {
            throw new NumberInvalidException("commands.enchant.notFound", var4);
        }
        if (!var7.canApply(var6)) {
            throw new CommandException("commands.enchant.cantEnchant", new Object[0]);
        }
        if (p_71515_2_.length >= 3) {
            var5 = CommandEnchant.parseIntBounded(p_71515_1_, p_71515_2_[2], var7.getMinLevel(), var7.getMaxLevel());
        }
        if (var6.hasTagCompound() && (var8 = var6.getEnchantmentTagList()) != null) {
            int var9 = 0;
            while (var9 < var8.tagCount()) {
                Enchantment var11;
                short var10 = var8.getCompoundTagAt(var9).getShort("id");
                if (Enchantment.enchantmentsList[var10] != null && !(var11 = Enchantment.enchantmentsList[var10]).canApplyTogether(var7)) {
                    throw new CommandException("commands.enchant.cantCombine", var7.getTranslatedName(var5), var11.getTranslatedName(var8.getCompoundTagAt(var9).getShort("lvl")));
                }
                ++var9;
            }
        }
        var6.addEnchantment(var7, var5);
        CommandEnchant.func_152373_a(p_71515_1_, this, "commands.enchant.success", new Object[0]);
    }

    @Override
    public List addTabCompletionOptions(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return p_71516_2_.length == 1 ? CommandEnchant.getListOfStringsMatchingLastWord(p_71516_2_, this.getListOfPlayers()) : null;
    }

    protected String[] getListOfPlayers() {
        return MinecraftServer.getServer().getAllUsernames();
    }

    @Override
    public boolean isUsernameIndex(String[] p_82358_1_, int p_82358_2_) {
        return p_82358_2_ == 0;
    }
}

