/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandHandler
implements ICommandManager {
    private static final Logger logger = LogManager.getLogger();
    private final Map commandMap = new HashMap();
    private final Set commandSet = new HashSet();
    private static final String __OBFID = "CL_00001765";

    @Override
    public int executeCommand(ICommandSender p_71556_1_, String p_71556_2_) {
        int var7;
        block13: {
            if ((p_71556_2_ = p_71556_2_.trim()).startsWith("/")) {
                p_71556_2_ = p_71556_2_.substring(1);
            }
            String[] var3 = p_71556_2_.split(" ");
            String var4 = var3[0];
            var3 = CommandHandler.dropFirstString(var3);
            ICommand var5 = (ICommand)this.commandMap.get(var4);
            int var6 = this.getUsernameIndex(var5, var3);
            var7 = 0;
            try {
                if (var5 == null) {
                    throw new CommandNotFoundException();
                }
                if (var5.canCommandSenderUseCommand(p_71556_1_)) {
                    if (var6 > -1) {
                        EntityPlayerMP[] var8 = PlayerSelector.matchPlayers(p_71556_1_, var3[var6]);
                        String var22 = var3[var6];
                        EntityPlayerMP[] var10 = var8;
                        int var11 = var8.length;
                        int var12 = 0;
                        while (var12 < var11) {
                            EntityPlayerMP var13 = var10[var12];
                            var3[var6] = var13.getCommandSenderName();
                            try {
                                var5.processCommand(p_71556_1_, var3);
                                ++var7;
                            }
                            catch (CommandException var17) {
                                ChatComponentTranslation var15 = new ChatComponentTranslation(var17.getMessage(), var17.getErrorOjbects());
                                var15.getChatStyle().setColor(EnumChatFormatting.RED);
                                p_71556_1_.addChatMessage(var15);
                            }
                            ++var12;
                        }
                        var3[var6] = var22;
                        break block13;
                    }
                    try {
                        var5.processCommand(p_71556_1_, var3);
                        ++var7;
                    }
                    catch (CommandException var16) {
                        ChatComponentTranslation var9 = new ChatComponentTranslation(var16.getMessage(), var16.getErrorOjbects());
                        var9.getChatStyle().setColor(EnumChatFormatting.RED);
                        p_71556_1_.addChatMessage(var9);
                    }
                    break block13;
                }
                ChatComponentTranslation var21 = new ChatComponentTranslation("commands.generic.permission", new Object[0]);
                var21.getChatStyle().setColor(EnumChatFormatting.RED);
                p_71556_1_.addChatMessage(var21);
            }
            catch (WrongUsageException var18) {
                ChatComponentTranslation var9 = new ChatComponentTranslation("commands.generic.usage", new ChatComponentTranslation(var18.getMessage(), var18.getErrorOjbects()));
                var9.getChatStyle().setColor(EnumChatFormatting.RED);
                p_71556_1_.addChatMessage(var9);
            }
            catch (CommandException var19) {
                ChatComponentTranslation var9 = new ChatComponentTranslation(var19.getMessage(), var19.getErrorOjbects());
                var9.getChatStyle().setColor(EnumChatFormatting.RED);
                p_71556_1_.addChatMessage(var9);
            }
            catch (Throwable var20) {
                ChatComponentTranslation var9 = new ChatComponentTranslation("commands.generic.exception", new Object[0]);
                var9.getChatStyle().setColor(EnumChatFormatting.RED);
                p_71556_1_.addChatMessage(var9);
                logger.error("Couldn't process command: '" + p_71556_2_ + "'", var20);
            }
        }
        return var7;
    }

    public ICommand registerCommand(ICommand p_71560_1_) {
        List var2 = p_71560_1_.getCommandAliases();
        this.commandMap.put(p_71560_1_.getCommandName(), p_71560_1_);
        this.commandSet.add(p_71560_1_);
        if (var2 != null) {
            for (String var4 : var2) {
                ICommand var5 = (ICommand)this.commandMap.get(var4);
                if (var5 != null && var5.getCommandName().equals(var4)) continue;
                this.commandMap.put(var4, p_71560_1_);
            }
        }
        return p_71560_1_;
    }

    private static String[] dropFirstString(String[] p_71559_0_) {
        String[] var1 = new String[p_71559_0_.length - 1];
        int var2 = 1;
        while (var2 < p_71559_0_.length) {
            var1[var2 - 1] = p_71559_0_[var2];
            ++var2;
        }
        return var1;
    }

    @Override
    public List getPossibleCommands(ICommandSender p_71558_1_, String p_71558_2_) {
        ICommand var5;
        String[] var3 = p_71558_2_.split(" ", -1);
        String var4 = var3[0];
        if (var3.length == 1) {
            ArrayList var8 = new ArrayList();
            for (Map.Entry var7 : this.commandMap.entrySet()) {
                if (!CommandBase.doesStringStartWith(var4, (String)var7.getKey()) || !((ICommand)var7.getValue()).canCommandSenderUseCommand(p_71558_1_)) continue;
                var8.add(var7.getKey());
            }
            return var8;
        }
        if (var3.length > 1 && (var5 = (ICommand)this.commandMap.get(var4)) != null) {
            return var5.addTabCompletionOptions(p_71558_1_, CommandHandler.dropFirstString(var3));
        }
        return null;
    }

    @Override
    public List getPossibleCommands(ICommandSender p_71557_1_) {
        ArrayList<ICommand> var2 = new ArrayList<ICommand>();
        for (ICommand var4 : this.commandSet) {
            if (!var4.canCommandSenderUseCommand(p_71557_1_)) continue;
            var2.add(var4);
        }
        return var2;
    }

    @Override
    public Map getCommands() {
        return this.commandMap;
    }

    private int getUsernameIndex(ICommand p_82370_1_, String[] p_82370_2_) {
        if (p_82370_1_ == null) {
            return -1;
        }
        int var3 = 0;
        while (var3 < p_82370_2_.length) {
            if (p_82370_1_.isUsernameIndex(p_82370_2_, var3) && PlayerSelector.matchesMultiplePlayers(p_82370_2_[var3])) {
                return var3;
            }
            ++var3;
        }
        return -1;
    }
}

