/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;

public class CommandAchievement
extends CommandBase {
    private static final String __OBFID = "CL_00000113";

    @Override
    public String getCommandName() {
        return "achievement";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender p_71518_1_) {
        return "commands.achievement.usage";
    }

    @Override
    public void processCommand(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (p_71515_2_.length >= 2) {
            StatBase var3 = StatList.func_151177_a(p_71515_2_[1]);
            if (var3 == null && !p_71515_2_[1].equals("*")) {
                throw new CommandException("commands.achievement.unknownAchievement", p_71515_2_[1]);
            }
            EntityPlayerMP var4 = p_71515_2_.length >= 3 ? CommandAchievement.getPlayer(p_71515_1_, p_71515_2_[2]) : CommandAchievement.getCommandSenderAsPlayer(p_71515_1_);
            if (p_71515_2_[0].equalsIgnoreCase("give")) {
                if (var3 == null) {
                    for (Achievement var6 : AchievementList.achievementList) {
                        var4.triggerAchievement(var6);
                    }
                    CommandAchievement.func_152373_a(p_71515_1_, this, "commands.achievement.give.success.all", var4.getCommandSenderName());
                } else {
                    if (var3 instanceof Achievement) {
                        Achievement var9 = (Achievement)var3;
                        ArrayList var10 = Lists.newArrayList();
                        while (var9.parentAchievement != null && !var4.func_147099_x().hasAchievementUnlocked(var9.parentAchievement)) {
                            var10.add(var9.parentAchievement);
                            var9 = var9.parentAchievement;
                        }
                        for (Achievement var8 : Lists.reverse((List)var10)) {
                            var4.triggerAchievement(var8);
                        }
                    }
                    var4.triggerAchievement(var3);
                    CommandAchievement.func_152373_a(p_71515_1_, this, "commands.achievement.give.success.one", var4.getCommandSenderName(), var3.func_150955_j());
                }
                return;
            }
        }
        throw new WrongUsageException("commands.achievement.usage", new Object[0]);
    }

    @Override
    public List addTabCompletionOptions(ICommandSender p_71516_1_, String[] p_71516_2_) {
        if (p_71516_2_.length == 1) {
            return CommandAchievement.getListOfStringsMatchingLastWord(p_71516_2_, "give");
        }
        if (p_71516_2_.length != 2) {
            return p_71516_2_.length == 3 ? CommandAchievement.getListOfStringsMatchingLastWord(p_71516_2_, MinecraftServer.getServer().getAllUsernames()) : null;
        }
        ArrayList var3 = Lists.newArrayList();
        for (StatBase var5 : StatList.allStats) {
            var3.add(var5.statId);
        }
        return CommandAchievement.getListOfStringsFromIterableMatchingLastWord(p_71516_2_, var3);
    }

    @Override
    public boolean isUsernameIndex(String[] p_82358_1_, int p_82358_2_) {
        return p_82358_2_ == 2;
    }
}

