/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.server;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.util.IChatComponent;

public class CommandBanIp
extends CommandBase {
    public static final Pattern field_147211_a = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String __OBFID = "CL_00000139";

    @Override
    public String getCommandName() {
        return "ban-ip";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 3;
    }

    @Override
    public boolean canCommandSenderUseCommand(ICommandSender p_71519_1_) {
        return MinecraftServer.getServer().getConfigurationManager().getBannedIPs().func_152689_b() && super.canCommandSenderUseCommand(p_71519_1_);
    }

    @Override
    public String getCommandUsage(ICommandSender p_71518_1_) {
        return "commands.banip.usage";
    }

    @Override
    public void processCommand(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (p_71515_2_.length >= 1 && p_71515_2_[0].length() > 1) {
            Matcher var3 = field_147211_a.matcher(p_71515_2_[0]);
            IChatComponent var4 = null;
            if (p_71515_2_.length >= 2) {
                var4 = CommandBanIp.func_147178_a(p_71515_1_, p_71515_2_, 1);
            }
            if (var3.matches()) {
                this.func_147210_a(p_71515_1_, p_71515_2_[0], var4 == null ? null : var4.getUnformattedText());
            } else {
                EntityPlayerMP var5 = MinecraftServer.getServer().getConfigurationManager().func_152612_a(p_71515_2_[0]);
                if (var5 == null) {
                    throw new PlayerNotFoundException("commands.banip.invalid", new Object[0]);
                }
                this.func_147210_a(p_71515_1_, var5.getPlayerIP(), var4 == null ? null : var4.getUnformattedText());
            }
        } else {
            throw new WrongUsageException("commands.banip.usage", new Object[0]);
        }
    }

    @Override
    public List addTabCompletionOptions(ICommandSender p_71516_1_, String[] p_71516_2_) {
        return p_71516_2_.length == 1 ? CommandBanIp.getListOfStringsMatchingLastWord(p_71516_2_, MinecraftServer.getServer().getAllUsernames()) : null;
    }

    protected void func_147210_a(ICommandSender p_147210_1_, String p_147210_2_, String p_147210_3_) {
        IPBanEntry var4 = new IPBanEntry(p_147210_2_, null, p_147210_1_.getCommandSenderName(), null, p_147210_3_);
        MinecraftServer.getServer().getConfigurationManager().getBannedIPs().func_152687_a(var4);
        List var5 = MinecraftServer.getServer().getConfigurationManager().getPlayerList(p_147210_2_);
        Object[] var6 = new String[var5.size()];
        int var7 = 0;
        for (EntityPlayerMP var9 : var5) {
            var9.playerNetServerHandler.kickPlayerFromServer("You have been IP banned.");
            var6[var7++] = var9.getCommandSenderName();
        }
        if (var5.isEmpty()) {
            CommandBanIp.func_152373_a(p_147210_1_, this, "commands.banip.success", p_147210_2_);
        } else {
            CommandBanIp.func_152373_a(p_147210_1_, this, "commands.banip.success.players", p_147210_2_, CommandBanIp.joinNiceString(var6));
        }
    }
}

