/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBow
extends Item {
    public static final String[] bowPullIconNameArray = new String[]{"pulling_0", "pulling_1", "pulling_2"};
    private IIcon[] iconArray;
    private static final String __OBFID = "CL_00001777";

    public ItemBow() {
        this.maxStackSize = 1;
        this.setMaxDamage(384);
        this.setCreativeTab(CreativeTabs.tabCombat);
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack p_77615_1_, World p_77615_2_, EntityPlayer p_77615_3_, int p_77615_4_) {
        boolean var5;
        boolean bl = var5 = p_77615_3_.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, p_77615_1_) > 0;
        if (var5 || p_77615_3_.inventory.hasItem(Items.arrow)) {
            int var10;
            int var9;
            int var6 = this.getMaxItemUseDuration(p_77615_1_) - p_77615_4_;
            float var7 = (float)var6 / 20.0f;
            if ((double)(var7 = (var7 * var7 + var7 * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (var7 > 1.0f) {
                var7 = 1.0f;
            }
            EntityArrow var8 = new EntityArrow(p_77615_2_, p_77615_3_, var7 * 2.0f);
            if (var7 == 1.0f) {
                var8.setIsCritical(true);
            }
            if ((var9 = EnchantmentHelper.getEnchantmentLevel(Enchantment.power.effectId, p_77615_1_)) > 0) {
                var8.setDamage(var8.getDamage() + (double)var9 * 0.5 + 0.5);
            }
            if ((var10 = EnchantmentHelper.getEnchantmentLevel(Enchantment.punch.effectId, p_77615_1_)) > 0) {
                var8.setKnockbackStrength(var10);
            }
            if (EnchantmentHelper.getEnchantmentLevel(Enchantment.flame.effectId, p_77615_1_) > 0) {
                var8.setFire(100);
            }
            p_77615_1_.damageItem(1, p_77615_3_);
            p_77615_2_.playSoundAtEntity(p_77615_3_, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
            if (var5) {
                var8.canBePickedUp = 2;
            } else {
                p_77615_3_.inventory.consumeInventoryItem(Items.arrow);
            }
            if (!p_77615_2_.isClient) {
                p_77615_2_.spawnEntityInWorld(var8);
            }
        }
    }

    @Override
    public ItemStack onEaten(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        return p_77654_1_;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack p_77626_1_) {
        return 72000;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        if (p_77659_3_.capabilities.isCreativeMode || p_77659_3_.inventory.hasItem(Items.arrow)) {
            p_77659_3_.setItemInUse(p_77659_1_, this.getMaxItemUseDuration(p_77659_1_));
        }
        return p_77659_1_;
    }

    @Override
    public int getItemEnchantability() {
        return 1;
    }

    @Override
    public void registerIcons(IIconRegister p_94581_1_) {
        this.itemIcon = p_94581_1_.registerIcon(String.valueOf(this.getIconString()) + "_standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        int var2 = 0;
        while (var2 < this.iconArray.length) {
            this.iconArray[var2] = p_94581_1_.registerIcon(String.valueOf(this.getIconString()) + "_" + bowPullIconNameArray[var2]);
            ++var2;
        }
    }

    public IIcon getItemIconForUseDuration(int p_94599_1_) {
        return this.iconArray[p_94599_1_];
    }
}

