/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemPotion
extends Item {
    private HashMap effectCache = new HashMap();
    private static final Map field_77835_b = new LinkedHashMap();
    private IIcon field_94591_c;
    private IIcon field_94590_d;
    private IIcon field_94592_ct;
    private static final String __OBFID = "CL_00000055";

    public ItemPotion() {
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(CreativeTabs.tabBrewing);
    }

    public List getEffects(ItemStack p_77832_1_) {
        if (p_77832_1_.hasTagCompound() && p_77832_1_.getTagCompound().func_150297_b("CustomPotionEffects", 9)) {
            ArrayList<PotionEffect> var7 = new ArrayList<PotionEffect>();
            NBTTagList var3 = p_77832_1_.getTagCompound().getTagList("CustomPotionEffects", 10);
            int var4 = 0;
            while (var4 < var3.tagCount()) {
                NBTTagCompound var5 = var3.getCompoundTagAt(var4);
                PotionEffect var6 = PotionEffect.readCustomPotionEffectFromNBT(var5);
                if (var6 != null) {
                    var7.add(var6);
                }
                ++var4;
            }
            return var7;
        }
        List var2 = (List)this.effectCache.get(p_77832_1_.getItemDamage());
        if (var2 == null) {
            var2 = PotionHelper.getPotionEffects(p_77832_1_.getItemDamage(), false);
            this.effectCache.put(p_77832_1_.getItemDamage(), var2);
        }
        return var2;
    }

    public List getEffects(int p_77834_1_) {
        List var2 = (List)this.effectCache.get(p_77834_1_);
        if (var2 == null) {
            var2 = PotionHelper.getPotionEffects(p_77834_1_, false);
            this.effectCache.put(p_77834_1_, var2);
        }
        return var2;
    }

    @Override
    public ItemStack onEaten(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        List var4;
        if (!p_77654_3_.capabilities.isCreativeMode) {
            --p_77654_1_.stackSize;
        }
        if (!p_77654_2_.isClient && (var4 = this.getEffects(p_77654_1_)) != null) {
            for (PotionEffect var6 : var4) {
                p_77654_3_.addPotionEffect(new PotionEffect(var6));
            }
        }
        if (!p_77654_3_.capabilities.isCreativeMode) {
            if (p_77654_1_.stackSize <= 0) {
                return new ItemStack(Items.glass_bottle);
            }
            p_77654_3_.inventory.addItemStackToInventory(new ItemStack(Items.glass_bottle));
        }
        return p_77654_1_;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack p_77626_1_) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.drink;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        if (ItemPotion.isSplash(p_77659_1_.getItemDamage())) {
            if (!p_77659_3_.capabilities.isCreativeMode) {
                --p_77659_1_.stackSize;
            }
            p_77659_2_.playSoundAtEntity(p_77659_3_, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!p_77659_2_.isClient) {
                p_77659_2_.spawnEntityInWorld(new EntityPotion(p_77659_2_, (EntityLivingBase)p_77659_3_, p_77659_1_));
            }
            return p_77659_1_;
        }
        p_77659_3_.setItemInUse(p_77659_1_, this.getMaxItemUseDuration(p_77659_1_));
        return p_77659_1_;
    }

    @Override
    public boolean onItemUse(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return false;
    }

    @Override
    public IIcon getIconFromDamage(int p_77617_1_) {
        return ItemPotion.isSplash(p_77617_1_) ? this.field_94591_c : this.field_94590_d;
    }

    @Override
    public IIcon getIconFromDamageForRenderPass(int p_77618_1_, int p_77618_2_) {
        return p_77618_2_ == 0 ? this.field_94592_ct : super.getIconFromDamageForRenderPass(p_77618_1_, p_77618_2_);
    }

    public static boolean isSplash(int p_77831_0_) {
        return (p_77831_0_ & 0x4000) != 0;
    }

    public int getColorFromDamage(int p_77620_1_) {
        return PotionHelper.func_77915_a(p_77620_1_, false);
    }

    @Override
    public int getColorFromItemStack(ItemStack p_82790_1_, int p_82790_2_) {
        return p_82790_2_ > 0 ? 0xFFFFFF : this.getColorFromDamage(p_82790_1_.getItemDamage());
    }

    @Override
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public boolean isEffectInstant(int p_77833_1_) {
        List var2 = this.getEffects(p_77833_1_);
        if (var2 != null && !var2.isEmpty()) {
            PotionEffect var4;
            Iterator var3 = var2.iterator();
            do {
                if (var3.hasNext()) continue;
                return false;
            } while (!Potion.potionTypes[(var4 = (PotionEffect)var3.next()).getPotionID()].isInstant());
            return true;
        }
        return false;
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_77653_1_) {
        List var3;
        if (p_77653_1_.getItemDamage() == 0) {
            return StatCollector.translateToLocal("item.emptyPotion.name").trim();
        }
        String var2 = "";
        if (ItemPotion.isSplash(p_77653_1_.getItemDamage())) {
            var2 = String.valueOf(StatCollector.translateToLocal("potion.prefix.grenade").trim()) + " ";
        }
        if ((var3 = Items.potionitem.getEffects(p_77653_1_)) != null && !var3.isEmpty()) {
            String var4 = ((PotionEffect)var3.get(0)).getEffectName();
            var4 = String.valueOf(var4) + ".postfix";
            return String.valueOf(var2) + StatCollector.translateToLocal(var4).trim();
        }
        String var4 = PotionHelper.func_77905_c(p_77653_1_.getItemDamage());
        return String.valueOf(StatCollector.translateToLocal(var4).trim()) + " " + super.getItemStackDisplayName(p_77653_1_);
    }

    @Override
    public void addInformation(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        if (p_77624_1_.getItemDamage() != 0) {
            List var5 = Items.potionitem.getEffects(p_77624_1_);
            HashMultimap var6 = HashMultimap.create();
            if (var5 != null && !var5.isEmpty()) {
                for (PotionEffect var8 : var5) {
                    String var9 = StatCollector.translateToLocal(var8.getEffectName()).trim();
                    Potion var10 = Potion.potionTypes[var8.getPotionID()];
                    Map var11 = var10.func_111186_k();
                    if (var11 != null && var11.size() > 0) {
                        for (Map.Entry var13 : var11.entrySet()) {
                            AttributeModifier var14 = (AttributeModifier)var13.getValue();
                            AttributeModifier var15 = new AttributeModifier(var14.getName(), var10.func_111183_a(var8.getAmplifier(), var14), var14.getOperation());
                            var6.put((Object)((IAttribute)var13.getKey()).getAttributeUnlocalizedName(), (Object)var15);
                        }
                    }
                    if (var8.getAmplifier() > 0) {
                        var9 = String.valueOf(var9) + " " + StatCollector.translateToLocal("potion.potency." + var8.getAmplifier()).trim();
                    }
                    if (var8.getDuration() > 20) {
                        var9 = String.valueOf(var9) + " (" + Potion.getDurationString(var8) + ")";
                    }
                    if (var10.isBadEffect()) {
                        p_77624_3_.add((Object)((Object)EnumChatFormatting.RED) + var9);
                        continue;
                    }
                    p_77624_3_.add((Object)((Object)EnumChatFormatting.GRAY) + var9);
                }
            } else {
                String var7 = StatCollector.translateToLocal("potion.empty").trim();
                p_77624_3_.add((Object)((Object)EnumChatFormatting.GRAY) + var7);
            }
            if (!var6.isEmpty()) {
                p_77624_3_.add("");
                p_77624_3_.add((Object)((Object)EnumChatFormatting.DARK_PURPLE) + StatCollector.translateToLocal("potion.effects.whenDrank"));
                for (Map.Entry var17 : var6.entries()) {
                    AttributeModifier var18 = (AttributeModifier)var17.getValue();
                    double var19 = var18.getAmount();
                    double var20 = var18.getOperation() != 1 && var18.getOperation() != 2 ? var18.getAmount() : var18.getAmount() * 100.0;
                    if (var19 > 0.0) {
                        p_77624_3_.add((Object)((Object)EnumChatFormatting.BLUE) + StatCollector.translateToLocalFormatted("attribute.modifier.plus." + var18.getOperation(), ItemStack.field_111284_a.format(var20), StatCollector.translateToLocal("attribute.name." + (String)var17.getKey())));
                        continue;
                    }
                    if (!(var19 < 0.0)) continue;
                    p_77624_3_.add((Object)((Object)EnumChatFormatting.RED) + StatCollector.translateToLocalFormatted("attribute.modifier.take." + var18.getOperation(), ItemStack.field_111284_a.format(var20 *= -1.0), StatCollector.translateToLocal("attribute.name." + (String)var17.getKey())));
                }
            }
        }
    }

    @Override
    public boolean hasEffect(ItemStack p_77636_1_) {
        List var2 = this.getEffects(p_77636_1_);
        return var2 != null && !var2.isEmpty();
    }

    @Override
    public void getSubItems(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
        int var5;
        super.getSubItems(p_150895_1_, p_150895_2_, p_150895_3_);
        if (field_77835_b.isEmpty()) {
            int var4 = 0;
            while (var4 <= 15) {
                var5 = 0;
                while (var5 <= 1) {
                    int var6 = var5 == 0 ? var4 | 0x2000 : var4 | 0x4000;
                    int var7 = 0;
                    while (var7 <= 2) {
                        List var9;
                        int var8 = var6;
                        if (var7 != 0) {
                            if (var7 == 1) {
                                var8 = var6 | 0x20;
                            } else if (var7 == 2) {
                                var8 = var6 | 0x40;
                            }
                        }
                        if ((var9 = PotionHelper.getPotionEffects(var8, false)) != null && !var9.isEmpty()) {
                            field_77835_b.put(var9, var8);
                        }
                        ++var7;
                    }
                    ++var5;
                }
                ++var4;
            }
        }
        Iterator var10 = field_77835_b.values().iterator();
        while (var10.hasNext()) {
            var5 = (Integer)var10.next();
            p_150895_3_.add(new ItemStack(p_150895_1_, 1, var5));
        }
    }

    @Override
    public void registerIcons(IIconRegister p_94581_1_) {
        this.field_94590_d = p_94581_1_.registerIcon(String.valueOf(this.getIconString()) + "_" + "bottle_drinkable");
        this.field_94591_c = p_94581_1_.registerIcon(String.valueOf(this.getIconString()) + "_" + "bottle_splash");
        this.field_94592_ct = p_94581_1_.registerIcon(String.valueOf(this.getIconString()) + "_" + "overlay");
    }

    public static IIcon func_94589_d(String p_94589_0_) {
        return p_94589_0_.equals("bottle_drinkable") ? Items.potionitem.field_94590_d : (p_94589_0_.equals("bottle_splash") ? Items.potionitem.field_94591_c : (p_94589_0_.equals("overlay") ? Items.potionitem.field_94592_ct : null));
    }
}

