/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagCompound
extends NBTBase {
    private static final Logger logger = LogManager.getLogger();
    private Map tagMap = new HashMap();
    private static final String __OBFID = "CL_00001215";

    @Override
    void write(DataOutput p_74734_1_) throws IOException {
        for (String var3 : this.tagMap.keySet()) {
            NBTBase var4 = (NBTBase)this.tagMap.get(var3);
            NBTTagCompound.func_150298_a(var3, var4, p_74734_1_);
        }
        p_74734_1_.writeByte(0);
    }

    @Override
    void func_152446_a(DataInput p_152446_1_, int p_152446_2_, NBTSizeTracker p_152446_3_) throws IOException {
        byte var4;
        if (p_152446_2_ > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.tagMap.clear();
        while ((var4 = NBTTagCompound.func_152447_a(p_152446_1_, p_152446_3_)) != 0) {
            String var5 = NBTTagCompound.func_152448_b(p_152446_1_, p_152446_3_);
            p_152446_3_.func_152450_a(16 * var5.length());
            NBTBase var6 = NBTTagCompound.func_152449_a(var4, var5, p_152446_1_, p_152446_2_ + 1, p_152446_3_);
            this.tagMap.put(var5, var6);
        }
    }

    public Set func_150296_c() {
        return this.tagMap.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public void setTag(String p_74782_1_, NBTBase p_74782_2_) {
        this.tagMap.put(p_74782_1_, p_74782_2_);
    }

    public void setByte(String p_74774_1_, byte p_74774_2_) {
        this.tagMap.put(p_74774_1_, new NBTTagByte(p_74774_2_));
    }

    public void setShort(String p_74777_1_, short p_74777_2_) {
        this.tagMap.put(p_74777_1_, new NBTTagShort(p_74777_2_));
    }

    public void setInteger(String p_74768_1_, int p_74768_2_) {
        this.tagMap.put(p_74768_1_, new NBTTagInt(p_74768_2_));
    }

    public void setLong(String p_74772_1_, long p_74772_2_) {
        this.tagMap.put(p_74772_1_, new NBTTagLong(p_74772_2_));
    }

    public void setFloat(String p_74776_1_, float p_74776_2_) {
        this.tagMap.put(p_74776_1_, new NBTTagFloat(p_74776_2_));
    }

    public void setDouble(String p_74780_1_, double p_74780_2_) {
        this.tagMap.put(p_74780_1_, new NBTTagDouble(p_74780_2_));
    }

    public void setString(String p_74778_1_, String p_74778_2_) {
        this.tagMap.put(p_74778_1_, new NBTTagString(p_74778_2_));
    }

    public void setByteArray(String p_74773_1_, byte[] p_74773_2_) {
        this.tagMap.put(p_74773_1_, new NBTTagByteArray(p_74773_2_));
    }

    public void setIntArray(String p_74783_1_, int[] p_74783_2_) {
        this.tagMap.put(p_74783_1_, new NBTTagIntArray(p_74783_2_));
    }

    public void setBoolean(String p_74757_1_, boolean p_74757_2_) {
        this.setByte(p_74757_1_, (byte)(p_74757_2_ ? 1 : 0));
    }

    public NBTBase getTag(String p_74781_1_) {
        return (NBTBase)this.tagMap.get(p_74781_1_);
    }

    public byte func_150299_b(String p_150299_1_) {
        NBTBase var2 = (NBTBase)this.tagMap.get(p_150299_1_);
        return var2 != null ? var2.getId() : (byte)0;
    }

    public boolean hasKey(String p_74764_1_) {
        return this.tagMap.containsKey(p_74764_1_);
    }

    public boolean func_150297_b(String p_150297_1_, int p_150297_2_) {
        byte var3 = this.func_150299_b(p_150297_1_);
        return var3 == p_150297_2_ ? true : (p_150297_2_ != 99 ? false : var3 == 1 || var3 == 2 || var3 == 3 || var3 == 4 || var3 == 5 || var3 == 6);
    }

    public byte getByte(String p_74771_1_) {
        try {
            return !this.tagMap.containsKey(p_74771_1_) ? (byte)0 : ((NBTBase.NBTPrimitive)this.tagMap.get(p_74771_1_)).func_150290_f();
        }
        catch (ClassCastException var3) {
            return 0;
        }
    }

    public short getShort(String p_74765_1_) {
        try {
            return !this.tagMap.containsKey(p_74765_1_) ? (short)0 : ((NBTBase.NBTPrimitive)this.tagMap.get(p_74765_1_)).func_150289_e();
        }
        catch (ClassCastException var3) {
            return 0;
        }
    }

    public int getInteger(String p_74762_1_) {
        try {
            return !this.tagMap.containsKey(p_74762_1_) ? 0 : ((NBTBase.NBTPrimitive)this.tagMap.get(p_74762_1_)).func_150287_d();
        }
        catch (ClassCastException var3) {
            return 0;
        }
    }

    public long getLong(String p_74763_1_) {
        try {
            return !this.tagMap.containsKey(p_74763_1_) ? 0L : ((NBTBase.NBTPrimitive)this.tagMap.get(p_74763_1_)).func_150291_c();
        }
        catch (ClassCastException var3) {
            return 0L;
        }
    }

    public float getFloat(String p_74760_1_) {
        try {
            return !this.tagMap.containsKey(p_74760_1_) ? 0.0f : ((NBTBase.NBTPrimitive)this.tagMap.get(p_74760_1_)).func_150288_h();
        }
        catch (ClassCastException var3) {
            return 0.0f;
        }
    }

    public double getDouble(String p_74769_1_) {
        try {
            return !this.tagMap.containsKey(p_74769_1_) ? 0.0 : ((NBTBase.NBTPrimitive)this.tagMap.get(p_74769_1_)).func_150286_g();
        }
        catch (ClassCastException var3) {
            return 0.0;
        }
    }

    public String getString(String p_74779_1_) {
        try {
            return !this.tagMap.containsKey(p_74779_1_) ? "" : ((NBTBase)this.tagMap.get(p_74779_1_)).func_150285_a_();
        }
        catch (ClassCastException var3) {
            return "";
        }
    }

    public byte[] getByteArray(String p_74770_1_) {
        try {
            return !this.tagMap.containsKey(p_74770_1_) ? new byte[]{} : ((NBTTagByteArray)this.tagMap.get(p_74770_1_)).func_150292_c();
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createCrashReport(p_74770_1_, 7, var3));
        }
    }

    public int[] getIntArray(String p_74759_1_) {
        try {
            return !this.tagMap.containsKey(p_74759_1_) ? new int[]{} : ((NBTTagIntArray)this.tagMap.get(p_74759_1_)).func_150302_c();
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createCrashReport(p_74759_1_, 11, var3));
        }
    }

    public NBTTagCompound getCompoundTag(String p_74775_1_) {
        try {
            return !this.tagMap.containsKey(p_74775_1_) ? new NBTTagCompound() : (NBTTagCompound)this.tagMap.get(p_74775_1_);
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createCrashReport(p_74775_1_, 10, var3));
        }
    }

    public NBTTagList getTagList(String p_150295_1_, int p_150295_2_) {
        try {
            if (this.func_150299_b(p_150295_1_) != 9) {
                return new NBTTagList();
            }
            NBTTagList var3 = (NBTTagList)this.tagMap.get(p_150295_1_);
            return var3.tagCount() > 0 && var3.func_150303_d() != p_150295_2_ ? new NBTTagList() : var3;
        }
        catch (ClassCastException var4) {
            throw new ReportedException(this.createCrashReport(p_150295_1_, 9, var4));
        }
    }

    public boolean getBoolean(String p_74767_1_) {
        return this.getByte(p_74767_1_) != 0;
    }

    public void removeTag(String p_82580_1_) {
        this.tagMap.remove(p_82580_1_);
    }

    @Override
    public String toString() {
        String var1 = "{";
        for (String var3 : this.tagMap.keySet()) {
            var1 = String.valueOf(var1) + var3 + ':' + this.tagMap.get(var3) + ',';
        }
        return String.valueOf(var1) + "}";
    }

    public boolean hasNoTags() {
        return this.tagMap.isEmpty();
    }

    private CrashReport createCrashReport(final String p_82581_1_, final int p_82581_2_, ClassCastException p_82581_3_) {
        CrashReport var4 = CrashReport.makeCrashReport(p_82581_3_, "Reading NBT data");
        CrashReportCategory var5 = var4.makeCategoryDepth("Corrupt NBT tag", 1);
        var5.addCrashSectionCallable("Tag type found", new Callable(){
            private static final String __OBFID = "CL_00001216";

            public String call() {
                return NBTBase.NBTTypes[((NBTBase)NBTTagCompound.this.tagMap.get(p_82581_1_)).getId()];
            }
        });
        var5.addCrashSectionCallable("Tag type expected", new Callable(){
            private static final String __OBFID = "CL_00001217";

            public String call() {
                return NBTBase.NBTTypes[p_82581_2_];
            }
        });
        var5.addCrashSection("Tag name", p_82581_1_);
        return var4;
    }

    @Override
    public NBTBase copy() {
        NBTTagCompound var1 = new NBTTagCompound();
        for (String var3 : this.tagMap.keySet()) {
            var1.setTag(var3, ((NBTBase)this.tagMap.get(var3)).copy());
        }
        return var1;
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (super.equals(p_equals_1_)) {
            NBTTagCompound var2 = (NBTTagCompound)p_equals_1_;
            return this.tagMap.entrySet().equals(var2.tagMap.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.tagMap.hashCode();
    }

    private static void func_150298_a(String p_150298_0_, NBTBase p_150298_1_, DataOutput p_150298_2_) throws IOException {
        p_150298_2_.writeByte(p_150298_1_.getId());
        if (p_150298_1_.getId() != 0) {
            p_150298_2_.writeUTF(p_150298_0_);
            p_150298_1_.write(p_150298_2_);
        }
    }

    private static byte func_152447_a(DataInput p_152447_0_, NBTSizeTracker p_152447_1_) throws IOException {
        return p_152447_0_.readByte();
    }

    private static String func_152448_b(DataInput p_152448_0_, NBTSizeTracker p_152448_1_) throws IOException {
        return p_152448_0_.readUTF();
    }

    static NBTBase func_152449_a(byte p_152449_0_, String p_152449_1_, DataInput p_152449_2_, int p_152449_3_, NBTSizeTracker p_152449_4_) {
        NBTBase var5 = NBTBase.func_150284_a(p_152449_0_);
        try {
            var5.func_152446_a(p_152449_2_, p_152449_3_, p_152449_4_);
            return var5;
        }
        catch (IOException var9) {
            CrashReport var7 = CrashReport.makeCrashReport(var9, "Loading NBT data");
            CrashReportCategory var8 = var7.makeCategory("NBT Tag");
            var8.addCrashSection("Tag name", p_152449_1_);
            var8.addCrashSection("Tag type", p_152449_0_);
            throw new ReportedException(var7);
        }
    }
}

