/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PathNavigate {
    private EntityLiving theEntity;
    private World worldObj;
    private PathEntity currentPath;
    private double speed;
    private IAttributeInstance pathSearchRange;
    private boolean noSunPathfind;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = Vec3.createVectorHelper(0.0, 0.0, 0.0);
    private boolean canPassOpenWoodenDoors = true;
    private boolean canPassClosedWoodenDoors;
    private boolean avoidsWater;
    private boolean canSwim;
    private static final String __OBFID = "CL_00001627";

    public PathNavigate(EntityLiving p_i1671_1_, World p_i1671_2_) {
        this.theEntity = p_i1671_1_;
        this.worldObj = p_i1671_2_;
        this.pathSearchRange = p_i1671_1_.getEntityAttribute(SharedMonsterAttributes.followRange);
    }

    public void setAvoidsWater(boolean p_75491_1_) {
        this.avoidsWater = p_75491_1_;
    }

    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    public void setBreakDoors(boolean p_75498_1_) {
        this.canPassClosedWoodenDoors = p_75498_1_;
    }

    public void setEnterDoors(boolean p_75490_1_) {
        this.canPassOpenWoodenDoors = p_75490_1_;
    }

    public boolean getCanBreakDoors() {
        return this.canPassClosedWoodenDoors;
    }

    public void setAvoidSun(boolean p_75504_1_) {
        this.noSunPathfind = p_75504_1_;
    }

    public void setSpeed(double p_75489_1_) {
        this.speed = p_75489_1_;
    }

    public void setCanSwim(boolean p_75495_1_) {
        this.canSwim = p_75495_1_;
    }

    public float func_111269_d() {
        return (float)this.pathSearchRange.getAttributeValue();
    }

    public PathEntity getPathToXYZ(double p_75488_1_, double p_75488_3_, double p_75488_5_) {
        return !this.canNavigate() ? null : this.worldObj.getEntityPathToXYZ(this.theEntity, MathHelper.floor_double(p_75488_1_), (int)p_75488_3_, MathHelper.floor_double(p_75488_5_), this.func_111269_d(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean tryMoveToXYZ(double p_75492_1_, double p_75492_3_, double p_75492_5_, double p_75492_7_) {
        PathEntity var9 = this.getPathToXYZ(MathHelper.floor_double(p_75492_1_), (int)p_75492_3_, MathHelper.floor_double(p_75492_5_));
        return this.setPath(var9, p_75492_7_);
    }

    public PathEntity getPathToEntityLiving(Entity p_75494_1_) {
        return !this.canNavigate() ? null : this.worldObj.getPathEntityToEntity(this.theEntity, p_75494_1_, this.func_111269_d(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean tryMoveToEntityLiving(Entity p_75497_1_, double p_75497_2_) {
        PathEntity var4 = this.getPathToEntityLiving(p_75497_1_);
        return var4 != null ? this.setPath(var4, p_75497_2_) : false;
    }

    public boolean setPath(PathEntity p_75484_1_, double p_75484_2_) {
        if (p_75484_1_ == null) {
            this.currentPath = null;
            return false;
        }
        if (!p_75484_1_.isSamePath(this.currentPath)) {
            this.currentPath = p_75484_1_;
        }
        if (this.noSunPathfind) {
            this.removeSunnyPath();
        }
        if (this.currentPath.getCurrentPathLength() == 0) {
            return false;
        }
        this.speed = p_75484_2_;
        Vec3 var4 = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck.xCoord = var4.xCoord;
        this.lastPosCheck.yCoord = var4.yCoord;
        this.lastPosCheck.zCoord = var4.zCoord;
        return true;
    }

    public PathEntity getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (!this.noPath()) {
            Vec3 var1;
            if (this.canNavigate()) {
                this.pathFollow();
            }
            if (!this.noPath() && (var1 = this.currentPath.getPosition(this.theEntity)) != null) {
                this.theEntity.getMoveHelper().setMoveTo(var1.xCoord, var1.yCoord, var1.zCoord, this.speed);
            }
        }
    }

    private void pathFollow() {
        Vec3 var1 = this.getEntityPosition();
        int var2 = this.currentPath.getCurrentPathLength();
        int var3 = this.currentPath.getCurrentPathIndex();
        while (var3 < this.currentPath.getCurrentPathLength()) {
            if (this.currentPath.getPathPointFromIndex((int)var3).yCoord != (int)var1.yCoord) {
                var2 = var3;
                break;
            }
            ++var3;
        }
        float var8 = this.theEntity.width * this.theEntity.width;
        int var4 = this.currentPath.getCurrentPathIndex();
        while (var4 < var2) {
            if (var1.squareDistanceTo(this.currentPath.getVectorFromIndex(this.theEntity, var4)) < (double)var8) {
                this.currentPath.setCurrentPathIndex(var4 + 1);
            }
            ++var4;
        }
        var4 = MathHelper.ceiling_float_int(this.theEntity.width);
        int var5 = (int)this.theEntity.height + 1;
        int var6 = var4;
        int var7 = var2 - 1;
        while (var7 >= this.currentPath.getCurrentPathIndex()) {
            if (this.isDirectPathBetweenPoints(var1, this.currentPath.getVectorFromIndex(this.theEntity, var7), var4, var5, var6)) {
                this.currentPath.setCurrentPathIndex(var7);
                break;
            }
            --var7;
        }
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (var1.squareDistanceTo(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck.xCoord = var1.xCoord;
            this.lastPosCheck.yCoord = var1.yCoord;
            this.lastPosCheck.zCoord = var1.zCoord;
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.isFinished();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    private Vec3 getEntityPosition() {
        return Vec3.createVectorHelper(this.theEntity.posX, this.getPathableYPos(), this.theEntity.posZ);
    }

    private int getPathableYPos() {
        if (this.theEntity.isInWater() && this.canSwim) {
            int var1 = (int)this.theEntity.boundingBox.minY;
            Block var2 = this.worldObj.getBlock(MathHelper.floor_double(this.theEntity.posX), var1, MathHelper.floor_double(this.theEntity.posZ));
            int var3 = 0;
            do {
                if (var2 != Blocks.flowing_water && var2 != Blocks.water) {
                    return var1;
                }
                var2 = this.worldObj.getBlock(MathHelper.floor_double(this.theEntity.posX), ++var1, MathHelper.floor_double(this.theEntity.posZ));
            } while (++var3 <= 16);
            return (int)this.theEntity.boundingBox.minY;
        }
        return (int)(this.theEntity.boundingBox.minY + 0.5);
    }

    private boolean canNavigate() {
        return this.theEntity.onGround || this.canSwim && this.isInFluid() || this.theEntity.isRiding() && this.theEntity instanceof EntityZombie && this.theEntity.ridingEntity instanceof EntityChicken;
    }

    private boolean isInFluid() {
        return this.theEntity.isInWater() || this.theEntity.handleLavaMovement();
    }

    private void removeSunnyPath() {
        if (!this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.theEntity.posX), (int)(this.theEntity.boundingBox.minY + 0.5), MathHelper.floor_double(this.theEntity.posZ))) {
            int var1 = 0;
            while (var1 < this.currentPath.getCurrentPathLength()) {
                PathPoint var2 = this.currentPath.getPathPointFromIndex(var1);
                if (this.worldObj.canBlockSeeTheSky(var2.xCoord, var2.yCoord, var2.zCoord)) {
                    this.currentPath.setCurrentPathLength(var1 - 1);
                    return;
                }
                ++var1;
            }
        }
    }

    private boolean isDirectPathBetweenPoints(Vec3 p_75493_1_, Vec3 p_75493_2_, int p_75493_3_, int p_75493_4_, int p_75493_5_) {
        int var6 = MathHelper.floor_double(p_75493_1_.xCoord);
        int var7 = MathHelper.floor_double(p_75493_1_.zCoord);
        double var8 = p_75493_2_.xCoord - p_75493_1_.xCoord;
        double var10 = p_75493_2_.zCoord - p_75493_1_.zCoord;
        double var12 = var8 * var8 + var10 * var10;
        if (var12 < 1.0E-8) {
            return false;
        }
        double var14 = 1.0 / Math.sqrt(var12);
        if (!this.isSafeToStandAt(var6, (int)p_75493_1_.yCoord, var7, p_75493_3_ += 2, p_75493_4_, p_75493_5_ += 2, p_75493_1_, var8 *= var14, var10 *= var14)) {
            return false;
        }
        p_75493_3_ -= 2;
        p_75493_5_ -= 2;
        double var16 = 1.0 / Math.abs(var8);
        double var18 = 1.0 / Math.abs(var10);
        double var20 = (double)(var6 * 1) - p_75493_1_.xCoord;
        double var22 = (double)(var7 * 1) - p_75493_1_.zCoord;
        if (var8 >= 0.0) {
            var20 += 1.0;
        }
        if (var10 >= 0.0) {
            var22 += 1.0;
        }
        var20 /= var8;
        var22 /= var10;
        int var24 = var8 < 0.0 ? -1 : 1;
        int var25 = var10 < 0.0 ? -1 : 1;
        int var26 = MathHelper.floor_double(p_75493_2_.xCoord);
        int var27 = MathHelper.floor_double(p_75493_2_.zCoord);
        int var28 = var26 - var6;
        int var29 = var27 - var7;
        do {
            if (var28 * var24 <= 0 && var29 * var25 <= 0) {
                return true;
            }
            if (var20 < var22) {
                var20 += var16;
                var28 = var26 - (var6 += var24);
                continue;
            }
            var22 += var18;
            var29 = var27 - (var7 += var25);
        } while (this.isSafeToStandAt(var6, (int)p_75493_1_.yCoord, var7, p_75493_3_, p_75493_4_, p_75493_5_, p_75493_1_, var8, var10));
        return false;
    }

    private boolean isSafeToStandAt(int p_75483_1_, int p_75483_2_, int p_75483_3_, int p_75483_4_, int p_75483_5_, int p_75483_6_, Vec3 p_75483_7_, double p_75483_8_, double p_75483_10_) {
        int var12 = p_75483_1_ - p_75483_4_ / 2;
        int var13 = p_75483_3_ - p_75483_6_ / 2;
        if (!this.isPositionClear(var12, p_75483_2_, var13, p_75483_4_, p_75483_5_, p_75483_6_, p_75483_7_, p_75483_8_, p_75483_10_)) {
            return false;
        }
        int var14 = var12;
        while (var14 < var12 + p_75483_4_) {
            int var15 = var13;
            while (var15 < var13 + p_75483_6_) {
                double var16 = (double)var14 + 0.5 - p_75483_7_.xCoord;
                double var18 = (double)var15 + 0.5 - p_75483_7_.zCoord;
                if (var16 * p_75483_8_ + var18 * p_75483_10_ >= 0.0) {
                    Block var20 = this.worldObj.getBlock(var14, p_75483_2_ - 1, var15);
                    Material var21 = var20.getMaterial();
                    if (var21 == Material.air) {
                        return false;
                    }
                    if (var21 == Material.water && !this.theEntity.isInWater()) {
                        return false;
                    }
                    if (var21 == Material.lava) {
                        return false;
                    }
                }
                ++var15;
            }
            ++var14;
        }
        return true;
    }

    private boolean isPositionClear(int p_75496_1_, int p_75496_2_, int p_75496_3_, int p_75496_4_, int p_75496_5_, int p_75496_6_, Vec3 p_75496_7_, double p_75496_8_, double p_75496_10_) {
        int var12 = p_75496_1_;
        while (var12 < p_75496_1_ + p_75496_4_) {
            int var13 = p_75496_2_;
            while (var13 < p_75496_2_ + p_75496_5_) {
                int var14 = p_75496_3_;
                while (var14 < p_75496_3_ + p_75496_6_) {
                    Block var19;
                    double var15 = (double)var12 + 0.5 - p_75496_7_.xCoord;
                    double var17 = (double)var14 + 0.5 - p_75496_7_.zCoord;
                    if (var15 * p_75496_8_ + var17 * p_75496_10_ >= 0.0 && !(var19 = this.worldObj.getBlock(var12, var13, var14)).getBlocksMovement(this.worldObj, var12, var13, var14)) {
                        return false;
                    }
                    ++var14;
                }
                ++var13;
            }
            ++var12;
        }
        return true;
    }
}

