/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import net.minecraft.profiler.IPlayerUsage;
import net.minecraft.profiler.PlayerUsageSnooper;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldManager;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements ICommandSender,
Runnable,
IPlayerUsage {
    private static final Logger logger = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    private static MinecraftServer mcServer;
    private final ISaveFormat anvilConverterForAnvilFile;
    private final PlayerUsageSnooper usageSnooper = new PlayerUsageSnooper("server", this, MinecraftServer.getSystemTimeMillis());
    private final File anvilFile;
    private final List tickables = new ArrayList();
    private final ICommandManager commandManager;
    public final Profiler theProfiler = new Profiler();
    private final NetworkSystem field_147144_o;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private int serverPort = -1;
    public WorldServer[] worldServers;
    private ServerConfigurationManager serverConfigManager;
    private boolean serverRunning = true;
    private boolean serverStopped;
    private int tickCounter;
    protected final Proxy serverProxy;
    public String currentTask;
    public int percentDone;
    private boolean onlineMode;
    private boolean canSpawnAnimals;
    private boolean canSpawnNPCs;
    private boolean pvpEnabled;
    private boolean allowFlight;
    private String motd;
    private int buildLimit;
    private int field_143008_E = 0;
    public final long[] tickTimeArray = new long[100];
    public long[][] timeOfLastDimensionTick;
    private KeyPair serverKeyPair;
    private String serverOwner;
    private String folderName;
    private String worldName;
    private boolean isDemo;
    private boolean enableBonusChest;
    private boolean worldIsBeingDeleted;
    private String field_147141_M = "";
    private boolean serverIsRunning;
    private long timeOfLastWarning;
    private String userMessage;
    private boolean startProfiling;
    private boolean isGamemodeForced;
    private final YggdrasilAuthenticationService field_152364_T;
    private final MinecraftSessionService field_147143_S;
    private long field_147142_T = 0L;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X = new PlayerProfileCache(this, field_152367_a);
    private static final String __OBFID = "CL_00001462";

    public MinecraftServer(File p_i45281_1_, Proxy p_i45281_2_) {
        mcServer = this;
        this.serverProxy = p_i45281_2_;
        this.anvilFile = p_i45281_1_;
        this.field_147144_o = new NetworkSystem(this);
        this.commandManager = new ServerCommandManager();
        this.anvilConverterForAnvilFile = new AnvilSaveConverter(p_i45281_1_);
        this.field_152364_T = new YggdrasilAuthenticationService(p_i45281_2_, UUID.randomUUID().toString());
        this.field_147143_S = this.field_152364_T.createMinecraftSessionService();
        this.field_152365_W = this.field_152364_T.createProfileRepository();
    }

    protected abstract boolean startServer() throws IOException;

    protected void convertMapIfNeeded(String p_71237_1_) {
        if (this.getActiveAnvilConverter().isOldMapFormat(p_71237_1_)) {
            logger.info("Converting map!");
            this.setUserMessage("menu.convertingLevel");
            this.getActiveAnvilConverter().convertMapFormat(p_71237_1_, new IProgressUpdate(){
                private long field_96245_b = System.currentTimeMillis();
                private static final String __OBFID = "CL_00001417";

                @Override
                public void displayProgressMessage(String p_73720_1_) {
                }

                @Override
                public void resetProgressAndMessage(String p_73721_1_) {
                }

                @Override
                public void setLoadingProgress(int p_73718_1_) {
                    if (System.currentTimeMillis() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = System.currentTimeMillis();
                        logger.info("Converting... " + p_73718_1_ + "%");
                    }
                }

                @Override
                public void func_146586_a() {
                }

                @Override
                public void resetProgresAndWorkingMessage(String p_73719_1_) {
                }
            });
        }
    }

    protected synchronized void setUserMessage(String p_71192_1_) {
        this.userMessage = p_71192_1_;
    }

    public synchronized String getUserMessage() {
        return this.userMessage;
    }

    protected void loadAllWorlds(String p_71247_1_, String p_71247_2_, long p_71247_3_, WorldType p_71247_5_, String p_71247_6_) {
        WorldSettings var8;
        this.convertMapIfNeeded(p_71247_1_);
        this.setUserMessage("menu.loadingLevel");
        this.worldServers = new WorldServer[3];
        this.timeOfLastDimensionTick = new long[this.worldServers.length][100];
        ISaveHandler var7 = this.anvilConverterForAnvilFile.getSaveLoader(p_71247_1_, true);
        WorldInfo var9 = var7.loadWorldInfo();
        if (var9 == null) {
            var8 = new WorldSettings(p_71247_3_, this.getGameType(), this.canStructuresSpawn(), this.isHardcore(), p_71247_5_);
            var8.func_82750_a(p_71247_6_);
        } else {
            var8 = new WorldSettings(var9);
        }
        if (this.enableBonusChest) {
            var8.enableBonusChest();
        }
        int var10 = 0;
        while (var10 < this.worldServers.length) {
            int var11 = 0;
            if (var10 == 1) {
                var11 = -1;
            }
            if (var10 == 2) {
                var11 = 1;
            }
            this.worldServers[var10] = var10 == 0 ? (this.isDemo() ? new DemoWorldServer(this, var7, p_71247_2_, var11, this.theProfiler) : new WorldServer(this, var7, p_71247_2_, var11, var8, this.theProfiler)) : new WorldServerMulti(this, var7, p_71247_2_, var11, var8, this.worldServers[0], this.theProfiler);
            this.worldServers[var10].addWorldAccess(new WorldManager(this, this.worldServers[var10]));
            if (!this.isSinglePlayer()) {
                this.worldServers[var10].getWorldInfo().setGameType(this.getGameType());
            }
            this.serverConfigManager.setPlayerManager(this.worldServers);
            ++var10;
        }
        this.func_147139_a(this.func_147135_j());
        this.initialWorldChunkLoad();
    }

    protected void initialWorldChunkLoad() {
        boolean var1 = true;
        boolean var2 = true;
        boolean var3 = true;
        boolean var4 = true;
        int var5 = 0;
        this.setUserMessage("menu.generatingTerrain");
        int var6 = 0;
        logger.info("Preparing start region for level " + var6);
        WorldServer var7 = this.worldServers[var6];
        ChunkCoordinates var8 = var7.getSpawnPoint();
        long var9 = MinecraftServer.getSystemTimeMillis();
        int var11 = -192;
        while (var11 <= 192 && this.isServerRunning()) {
            int var12 = -192;
            while (var12 <= 192 && this.isServerRunning()) {
                long var13 = MinecraftServer.getSystemTimeMillis();
                if (var13 - var9 > 1000L) {
                    this.outputPercentRemaining("Preparing spawn area", var5 * 100 / 625);
                    var9 = var13;
                }
                ++var5;
                var7.theChunkProviderServer.loadChunk(var8.posX + var11 >> 4, var8.posZ + var12 >> 4);
                var12 += 16;
            }
            var11 += 16;
        }
        this.clearCurrentTask();
    }

    public abstract boolean canStructuresSpawn();

    public abstract WorldSettings.GameType getGameType();

    public abstract EnumDifficulty func_147135_j();

    public abstract boolean isHardcore();

    public abstract int func_110455_j();

    public abstract boolean func_152363_m();

    protected void outputPercentRemaining(String p_71216_1_, int p_71216_2_) {
        this.currentTask = p_71216_1_;
        this.percentDone = p_71216_2_;
        logger.info(String.valueOf(p_71216_1_) + ": " + p_71216_2_ + "%");
    }

    protected void clearCurrentTask() {
        this.currentTask = null;
        this.percentDone = 0;
    }

    protected void saveAllWorlds(boolean p_71267_1_) {
        if (!this.worldIsBeingDeleted) {
            WorldServer[] var2 = this.worldServers;
            int var3 = var2.length;
            int var4 = 0;
            while (var4 < var3) {
                WorldServer var5 = var2[var4];
                if (var5 != null) {
                    if (!p_71267_1_) {
                        logger.info("Saving chunks for level '" + var5.getWorldInfo().getWorldName() + "'/" + var5.provider.getDimensionName());
                    }
                    try {
                        var5.saveAllChunks(true, null);
                    }
                    catch (MinecraftException var7) {
                        logger.warn(var7.getMessage());
                    }
                }
                ++var4;
            }
        }
    }

    public void stopServer() {
        if (!this.worldIsBeingDeleted) {
            logger.info("Stopping server");
            if (this.func_147137_ag() != null) {
                this.func_147137_ag().terminateEndpoints();
            }
            if (this.serverConfigManager != null) {
                logger.info("Saving players");
                this.serverConfigManager.saveAllPlayerData();
                this.serverConfigManager.removeAllPlayers();
            }
            if (this.worldServers != null) {
                logger.info("Saving worlds");
                this.saveAllWorlds(false);
                int var1 = 0;
                while (var1 < this.worldServers.length) {
                    WorldServer var2 = this.worldServers[var1];
                    var2.flush();
                    ++var1;
                }
            }
            if (this.usageSnooper.isSnooperRunning()) {
                this.usageSnooper.stopSnooper();
            }
        }
    }

    public boolean isServerRunning() {
        return this.serverRunning;
    }

    public void initiateShutdown() {
        this.serverRunning = false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block24: {
            try {
                try {
                    block27: {
                        if (!this.startServer()) break block27;
                        var1 = MinecraftServer.getSystemTimeMillis();
                        var50 = 0L;
                        this.field_147147_p.func_151315_a(new ChatComponentText(this.motd));
                        this.field_147147_p.func_151321_a(new ServerStatusResponse.MinecraftProtocolVersionIdentifier("1.7.10", 5));
                        this.func_147138_a(this.field_147147_p);
                        while (this.serverRunning) {
                            block28: {
                                var5 = MinecraftServer.getSystemTimeMillis();
                                var7 = var5 - var1;
                                if (var7 > 2000L && var1 - this.timeOfLastWarning >= 15000L) {
                                    MinecraftServer.logger.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{var7, var7 / 50L});
                                    var7 = 2000L;
                                    this.timeOfLastWarning = var1;
                                }
                                if (var7 < 0L) {
                                    MinecraftServer.logger.warn("Time ran backwards! Did the system time change?");
                                    var7 = 0L;
                                }
                                var50 += var7;
                                var1 = var5;
                                if (!this.worldServers[0].areAllPlayersAsleep()) ** GOTO lbl27
                                this.tick();
                                var50 = 0L;
                                break block28;
lbl-1000:
                                // 1 sources

                                {
                                    var50 -= 50L;
                                    this.tick();
lbl27:
                                    // 2 sources

                                    ** while (var50 > 50L)
                                }
                            }
                            Thread.sleep(Math.max(1L, 50L - var50));
                            this.serverIsRunning = true;
                        }
                        break block24;
                    }
                    this.finalTick(null);
                }
                catch (Throwable var48) {
                    MinecraftServer.logger.error("Encountered an unexpected exception", var48);
                    var2 = null;
                    var2 = var48 instanceof ReportedException != false ? this.addServerInfoToCrashReport(((ReportedException)var48).getCrashReport()) : this.addServerInfoToCrashReport(new CrashReport("Exception in server tick loop", var48));
                    var3 = new File(new File(this.getDataDirectory(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                    if (var2.saveToFile(var3)) {
                        MinecraftServer.logger.error("This crash report has been saved to: " + var3.getAbsolutePath());
                    } else {
                        MinecraftServer.logger.error("We were unable to save this crash report to disk.");
                    }
                    this.finalTick(var2);
                    try {
                        try {
                            this.stopServer();
                            this.serverStopped = true;
                        }
                        catch (Throwable var46) {
                            MinecraftServer.logger.error("Exception stopping the server", var46);
                            this.systemExitNow();
                        }
                    }
                    finally {
                        this.systemExitNow();
                    }
                }
            }
            finally {
                block26: {
                    try {
                        try {
                            this.stopServer();
                            this.serverStopped = true;
                        }
                        catch (Throwable var46) {
                            MinecraftServer.logger.error("Exception stopping the server", var46);
                            this.systemExitNow();
                            break block26;
                        }
                    }
                    catch (Throwable var11_13) {
                        this.systemExitNow();
                        throw var11_13;
                    }
                    this.systemExitNow();
                }
            }
        }
    }

    private void func_147138_a(ServerStatusResponse p_147138_1_) {
        File var2 = this.getFile("server-icon.png");
        if (var2.isFile()) {
            ByteBuf var3 = Unpooled.buffer();
            try {
                try {
                    BufferedImage var4 = ImageIO.read(var2);
                    Validate.validState((var4.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((var4.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    ImageIO.write((RenderedImage)var4, "PNG", (OutputStream)new ByteBufOutputStream(var3));
                    ByteBuf var5 = Base64.encode((ByteBuf)var3);
                    p_147138_1_.func_151320_a("data:image/png;base64," + var5.toString(Charsets.UTF_8));
                }
                catch (Exception var9) {
                    logger.error("Couldn't load server icon", (Throwable)var9);
                    var3.release();
                }
            }
            finally {
                var3.release();
            }
        }
    }

    protected File getDataDirectory() {
        return new File(".");
    }

    protected void finalTick(CrashReport p_71228_1_) {
    }

    protected void systemExitNow() {
    }

    public void tick() {
        long var1 = System.nanoTime();
        ++this.tickCounter;
        if (this.startProfiling) {
            this.startProfiling = false;
            this.theProfiler.profilingEnabled = true;
            this.theProfiler.clearProfiling();
        }
        this.theProfiler.startSection("root");
        this.updateTimeLightAndEntities();
        if (var1 - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = var1;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.PlayerCountData(this.getMaxPlayers(), this.getCurrentPlayerCount()));
            GameProfile[] var3 = new GameProfile[Math.min(this.getCurrentPlayerCount(), 12)];
            int var4 = MathHelper.getRandomIntegerInRange(this.field_147146_q, 0, this.getCurrentPlayerCount() - var3.length);
            int var5 = 0;
            while (var5 < var3.length) {
                var3[var5] = ((EntityPlayerMP)this.serverConfigManager.playerEntityList.get(var4 + var5)).getGameProfile();
                ++var5;
            }
            Collections.shuffle(Arrays.asList(var3));
            this.field_147147_p.func_151318_b().func_151330_a(var3);
        }
        if (this.tickCounter % 900 == 0) {
            this.theProfiler.startSection("save");
            this.serverConfigManager.saveAllPlayerData();
            this.saveAllWorlds(true);
            this.theProfiler.endSection();
        }
        this.theProfiler.startSection("tallying");
        this.tickTimeArray[this.tickCounter % 100] = System.nanoTime() - var1;
        this.theProfiler.endSection();
        this.theProfiler.startSection("snooper");
        if (!this.usageSnooper.isSnooperRunning() && this.tickCounter > 100) {
            this.usageSnooper.startSnooper();
        }
        if (this.tickCounter % 6000 == 0) {
            this.usageSnooper.addMemoryStatsToSnooper();
        }
        this.theProfiler.endSection();
        this.theProfiler.endSection();
    }

    public void updateTimeLightAndEntities() {
        this.theProfiler.startSection("levels");
        int var1 = 0;
        while (var1 < this.worldServers.length) {
            long var2 = System.nanoTime();
            if (var1 == 0 || this.getAllowNether()) {
                WorldServer var4 = this.worldServers[var1];
                this.theProfiler.startSection(var4.getWorldInfo().getWorldName());
                this.theProfiler.startSection("pools");
                this.theProfiler.endSection();
                if (this.tickCounter % 20 == 0) {
                    this.theProfiler.startSection("timeSync");
                    this.serverConfigManager.func_148537_a(new S03PacketTimeUpdate(var4.getTotalWorldTime(), var4.getWorldTime(), var4.getGameRules().getGameRuleBooleanValue("doDaylightCycle")), var4.provider.dimensionId);
                    this.theProfiler.endSection();
                }
                this.theProfiler.startSection("tick");
                try {
                    var4.tick();
                }
                catch (Throwable var8) {
                    CrashReport var6 = CrashReport.makeCrashReport(var8, "Exception ticking world");
                    var4.addWorldInfoToCrashReport(var6);
                    throw new ReportedException(var6);
                }
                try {
                    var4.updateEntities();
                }
                catch (Throwable var7) {
                    CrashReport var6 = CrashReport.makeCrashReport(var7, "Exception ticking world entities");
                    var4.addWorldInfoToCrashReport(var6);
                    throw new ReportedException(var6);
                }
                this.theProfiler.endSection();
                this.theProfiler.startSection("tracker");
                var4.getEntityTracker().updateTrackedEntities();
                this.theProfiler.endSection();
                this.theProfiler.endSection();
            }
            this.timeOfLastDimensionTick[var1][this.tickCounter % 100] = System.nanoTime() - var2;
            ++var1;
        }
        this.theProfiler.endStartSection("connection");
        this.func_147137_ag().networkTick();
        this.theProfiler.endStartSection("players");
        this.serverConfigManager.sendPlayerInfoToAllPlayers();
        this.theProfiler.endStartSection("tickables");
        var1 = 0;
        while (var1 < this.tickables.size()) {
            ((IUpdatePlayerListBox)this.tickables.get(var1)).update();
            ++var1;
        }
        this.theProfiler.endSection();
    }

    public boolean getAllowNether() {
        return true;
    }

    public void startServerThread() {
        new Thread("Server thread"){
            private static final String __OBFID = "CL_00001418";

            @Override
            public void run() {
                MinecraftServer.this.run();
            }
        }.start();
    }

    public File getFile(String p_71209_1_) {
        return new File(this.getDataDirectory(), p_71209_1_);
    }

    public void logWarning(String p_71236_1_) {
        logger.warn(p_71236_1_);
    }

    public WorldServer worldServerForDimension(int p_71218_1_) {
        return p_71218_1_ == -1 ? this.worldServers[1] : (p_71218_1_ == 1 ? this.worldServers[2] : this.worldServers[0]);
    }

    public String getMinecraftVersion() {
        return "1.7.10";
    }

    public int getCurrentPlayerCount() {
        return this.serverConfigManager.getCurrentPlayerCount();
    }

    public int getMaxPlayers() {
        return this.serverConfigManager.getMaxPlayers();
    }

    public String[] getAllUsernames() {
        return this.serverConfigManager.getAllUsernames();
    }

    public GameProfile[] func_152357_F() {
        return this.serverConfigManager.func_152600_g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport addServerInfoToCrashReport(CrashReport p_71230_1_) {
        p_71230_1_.getCategory().addCrashSectionCallable("Profiler Position", new Callable(){
            private static final String __OBFID = "CL_00001419";

            public String call() {
                return MinecraftServer.this.theProfiler.profilingEnabled ? MinecraftServer.this.theProfiler.getNameOfLastSection() : "N/A (disabled)";
            }
        });
        if (this.worldServers != null && this.worldServers.length > 0 && this.worldServers[0] != null) {
            p_71230_1_.getCategory().addCrashSectionCallable("Vec3 Pool Size", new Callable(){
                private static final String __OBFID = "CL_00001420";

                public String call() {
                    int var1 = 0;
                    int var2 = 56 * var1;
                    int var3 = var2 / 1024 / 1024;
                    int var4 = 0;
                    int var5 = 56 * var4;
                    int var6 = var5 / 1024 / 1024;
                    return String.valueOf(var1) + " (" + var2 + " bytes; " + var3 + " MB) allocated, " + var4 + " (" + var5 + " bytes; " + var6 + " MB) used";
                }
            });
        }
        if (this.serverConfigManager != null) {
            p_71230_1_.getCategory().addCrashSectionCallable("Player Count", new Callable(){
                private static final String __OBFID = "CL_00001780";

                public String call() {
                    return String.valueOf(MinecraftServer.this.serverConfigManager.getCurrentPlayerCount()) + " / " + MinecraftServer.this.serverConfigManager.getMaxPlayers() + "; " + ((MinecraftServer)MinecraftServer.this).serverConfigManager.playerEntityList;
                }
            });
        }
        return p_71230_1_;
    }

    public List getPossibleCompletions(ICommandSender p_71248_1_, String p_71248_2_) {
        ArrayList<String> var3 = new ArrayList<String>();
        if (p_71248_2_.startsWith("/")) {
            boolean var10 = !(p_71248_2_ = p_71248_2_.substring(1)).contains(" ");
            List var11 = this.commandManager.getPossibleCommands(p_71248_1_, p_71248_2_);
            if (var11 != null) {
                for (String var13 : var11) {
                    if (var10) {
                        var3.add("/" + var13);
                        continue;
                    }
                    var3.add(var13);
                }
            }
            return var3;
        }
        String[] var4 = p_71248_2_.split(" ", -1);
        String var5 = var4[var4.length - 1];
        String[] var6 = this.serverConfigManager.getAllUsernames();
        int var7 = var6.length;
        int var8 = 0;
        while (var8 < var7) {
            String var9 = var6[var8];
            if (CommandBase.doesStringStartWith(var5, var9)) {
                var3.add(var9);
            }
            ++var8;
        }
        return var3;
    }

    public static MinecraftServer getServer() {
        return mcServer;
    }

    @Override
    public String getCommandSenderName() {
        return "Server";
    }

    @Override
    public void addChatMessage(IChatComponent p_145747_1_) {
        logger.info(p_145747_1_.getUnformattedText());
    }

    @Override
    public boolean canCommandSenderUseCommand(int p_70003_1_, String p_70003_2_) {
        return true;
    }

    public ICommandManager getCommandManager() {
        return this.commandManager;
    }

    public KeyPair getKeyPair() {
        return this.serverKeyPair;
    }

    public String getServerOwner() {
        return this.serverOwner;
    }

    public void setServerOwner(String p_71224_1_) {
        this.serverOwner = p_71224_1_;
    }

    public boolean isSinglePlayer() {
        return this.serverOwner != null;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String p_71261_1_) {
        this.folderName = p_71261_1_;
    }

    public void setWorldName(String p_71246_1_) {
        this.worldName = p_71246_1_;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setKeyPair(KeyPair p_71253_1_) {
        this.serverKeyPair = p_71253_1_;
    }

    public void func_147139_a(EnumDifficulty p_147139_1_) {
        int var2 = 0;
        while (var2 < this.worldServers.length) {
            WorldServer var3 = this.worldServers[var2];
            if (var3 != null) {
                if (var3.getWorldInfo().isHardcoreModeEnabled()) {
                    var3.difficultySetting = EnumDifficulty.HARD;
                    var3.setAllowedSpawnTypes(true, true);
                } else if (this.isSinglePlayer()) {
                    var3.difficultySetting = p_147139_1_;
                    var3.setAllowedSpawnTypes(var3.difficultySetting != EnumDifficulty.PEACEFUL, true);
                } else {
                    var3.difficultySetting = p_147139_1_;
                    var3.setAllowedSpawnTypes(this.allowSpawnMonsters(), this.canSpawnAnimals);
                }
            }
            ++var2;
        }
    }

    protected boolean allowSpawnMonsters() {
        return true;
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean p_71204_1_) {
        this.isDemo = p_71204_1_;
    }

    public void canCreateBonusChest(boolean p_71194_1_) {
        this.enableBonusChest = p_71194_1_;
    }

    public ISaveFormat getActiveAnvilConverter() {
        return this.anvilConverterForAnvilFile;
    }

    public void deleteWorldAndStopServer() {
        this.worldIsBeingDeleted = true;
        this.getActiveAnvilConverter().flushCache();
        int var1 = 0;
        while (var1 < this.worldServers.length) {
            WorldServer var2 = this.worldServers[var1];
            if (var2 != null) {
                var2.flush();
            }
            ++var1;
        }
        this.getActiveAnvilConverter().deleteWorldDirectory(this.worldServers[0].getSaveHandler().getWorldDirectoryName());
        this.initiateShutdown();
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    @Override
    public void addServerStatsToSnooper(PlayerUsageSnooper p_70000_1_) {
        p_70000_1_.func_152768_a("whitelist_enabled", false);
        p_70000_1_.func_152768_a("whitelist_count", 0);
        p_70000_1_.func_152768_a("players_current", this.getCurrentPlayerCount());
        p_70000_1_.func_152768_a("players_max", this.getMaxPlayers());
        p_70000_1_.func_152768_a("players_seen", this.serverConfigManager.getAvailablePlayerDat().length);
        p_70000_1_.func_152768_a("uses_auth", this.onlineMode);
        p_70000_1_.func_152768_a("gui_state", this.getGuiEnabled() ? "enabled" : "disabled");
        p_70000_1_.func_152768_a("run_time", (MinecraftServer.getSystemTimeMillis() - p_70000_1_.getMinecraftStartTimeMillis()) / 60L * 1000L);
        p_70000_1_.func_152768_a("avg_tick_ms", (int)(MathHelper.average(this.tickTimeArray) * 1.0E-6));
        int var2 = 0;
        int var3 = 0;
        while (var3 < this.worldServers.length) {
            if (this.worldServers[var3] != null) {
                WorldServer var4 = this.worldServers[var3];
                WorldInfo var5 = var4.getWorldInfo();
                p_70000_1_.func_152768_a("world[" + var2 + "][dimension]", var4.provider.dimensionId);
                p_70000_1_.func_152768_a("world[" + var2 + "][mode]", (Object)var5.getGameType());
                p_70000_1_.func_152768_a("world[" + var2 + "][difficulty]", (Object)var4.difficultySetting);
                p_70000_1_.func_152768_a("world[" + var2 + "][hardcore]", var5.isHardcoreModeEnabled());
                p_70000_1_.func_152768_a("world[" + var2 + "][generator_name]", var5.getTerrainType().getWorldTypeName());
                p_70000_1_.func_152768_a("world[" + var2 + "][generator_version]", var5.getTerrainType().getGeneratorVersion());
                p_70000_1_.func_152768_a("world[" + var2 + "][height]", this.buildLimit);
                p_70000_1_.func_152768_a("world[" + var2 + "][chunks_loaded]", var4.getChunkProvider().getLoadedChunkCount());
                ++var2;
            }
            ++var3;
        }
        p_70000_1_.func_152768_a("worlds", var2);
    }

    @Override
    public void addServerTypeToSnooper(PlayerUsageSnooper p_70001_1_) {
        p_70001_1_.func_152767_b("singleplayer", this.isSinglePlayer());
        p_70001_1_.func_152767_b("server_brand", this.getServerModName());
        p_70001_1_.func_152767_b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        p_70001_1_.func_152767_b("dedicated", this.isDedicatedServer());
    }

    @Override
    public boolean isSnooperEnabled() {
        return true;
    }

    public abstract boolean isDedicatedServer();

    public boolean isServerInOnlineMode() {
        return this.onlineMode;
    }

    public void setOnlineMode(boolean p_71229_1_) {
        this.onlineMode = p_71229_1_;
    }

    public boolean getCanSpawnAnimals() {
        return this.canSpawnAnimals;
    }

    public void setCanSpawnAnimals(boolean p_71251_1_) {
        this.canSpawnAnimals = p_71251_1_;
    }

    public boolean getCanSpawnNPCs() {
        return this.canSpawnNPCs;
    }

    public void setCanSpawnNPCs(boolean p_71257_1_) {
        this.canSpawnNPCs = p_71257_1_;
    }

    public boolean isPVPEnabled() {
        return this.pvpEnabled;
    }

    public void setAllowPvp(boolean p_71188_1_) {
        this.pvpEnabled = p_71188_1_;
    }

    public boolean isFlightAllowed() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean p_71245_1_) {
        this.allowFlight = p_71245_1_;
    }

    public abstract boolean isCommandBlockEnabled();

    public String getMOTD() {
        return this.motd;
    }

    public void setMOTD(String p_71205_1_) {
        this.motd = p_71205_1_;
    }

    public int getBuildLimit() {
        return this.buildLimit;
    }

    public void setBuildLimit(int p_71191_1_) {
        this.buildLimit = p_71191_1_;
    }

    public ServerConfigurationManager getConfigurationManager() {
        return this.serverConfigManager;
    }

    public void func_152361_a(ServerConfigurationManager p_152361_1_) {
        this.serverConfigManager = p_152361_1_;
    }

    public void setGameType(WorldSettings.GameType p_71235_1_) {
        int var2 = 0;
        while (var2 < this.worldServers.length) {
            MinecraftServer.getServer().worldServers[var2].getWorldInfo().setGameType(p_71235_1_);
            ++var2;
        }
    }

    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    public boolean serverIsInRunLoop() {
        return this.serverIsRunning;
    }

    public boolean getGuiEnabled() {
        return false;
    }

    public abstract String shareToLAN(WorldSettings.GameType var1, boolean var2);

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void enableProfiling() {
        this.startProfiling = true;
    }

    public PlayerUsageSnooper getPlayerUsageSnooper() {
        return this.usageSnooper;
    }

    @Override
    public ChunkCoordinates getPlayerCoordinates() {
        return new ChunkCoordinates(0, 0, 0);
    }

    @Override
    public World getEntityWorld() {
        return this.worldServers[0];
    }

    public int getSpawnProtectionSize() {
        return 16;
    }

    public boolean isBlockProtected(World p_96290_1_, int p_96290_2_, int p_96290_3_, int p_96290_4_, EntityPlayer p_96290_5_) {
        return false;
    }

    public boolean getForceGamemode() {
        return this.isGamemodeForced;
    }

    public Proxy getServerProxy() {
        return this.serverProxy;
    }

    public static long getSystemTimeMillis() {
        return System.currentTimeMillis();
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int p_143006_1_) {
        this.field_143008_E = p_143006_1_;
    }

    @Override
    public IChatComponent func_145748_c_() {
        return new ChatComponentText(this.getCommandSenderName());
    }

    public boolean func_147136_ar() {
        return true;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }
}

