/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;

public class GuiQualitySettingsOF
extends GuiScreen {
    private GuiScreen prevScreen;
    protected String title = "Quality Settings";
    private GameSettings settings;
    private static GameSettings.Options[] enumOptions = new GameSettings.Options[]{GameSettings.Options.MIPMAP_LEVELS, GameSettings.Options.MIPMAP_TYPE, GameSettings.Options.ANISOTROPIC_FILTERING, GameSettings.Options.CUSTOM_SKY, GameSettings.Options.CLEAR_WATER, GameSettings.Options.RANDOM_MOBS, GameSettings.Options.BETTER_GRASS, GameSettings.Options.BETTER_SNOW, GameSettings.Options.CUSTOM_FONTS, GameSettings.Options.CUSTOM_COLORS, GameSettings.Options.SWAMP_COLORS, GameSettings.Options.SMOOTH_BIOMES, GameSettings.Options.CONNECTED_TEXTURES, GameSettings.Options.NATURAL_TEXTURES};
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public GuiQualitySettingsOF(GuiScreen guiscreen, GameSettings gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    @Override
    public void initGui() {
        int i = 0;
        GameSettings.Options[] aenumoptions = enumOptions;
        int j = aenumoptions.length;
        int k = 0;
        while (k < j) {
            GameSettings.Options enumoptions = aenumoptions[k];
            int x = this.width / 2 - 155 + i % 2 * 160;
            int y = this.height / 6 + 21 * (i / 2) - 10;
            if (!enumoptions.getEnumFloat()) {
                this.buttonList.add(new GuiOptionButton(enumoptions.returnEnumOrdinal(), x, y, enumoptions, this.settings.getKeyBinding(enumoptions)));
            } else {
                this.buttonList.add(new GuiOptionSlider(enumoptions.returnEnumOrdinal(), x, y, enumoptions));
            }
            ++i;
            ++k;
        }
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168 + 11, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.enabled) {
            if (guibutton.id < 200 && guibutton instanceof GuiOptionButton) {
                this.settings.setOptionValue(((GuiOptionButton)guibutton).func_146136_c(), 1);
                guibutton.displayString = this.settings.getKeyBinding(GameSettings.Options.getEnumOptions(guibutton.id));
            }
            if (guibutton.id == 200) {
                this.mc.gameSettings.saveOptions();
                this.mc.displayGuiScreen(this.prevScreen);
            }
            if (guibutton.id != GameSettings.Options.CLOUD_HEIGHT.ordinal()) {
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
                int i = scaledresolution.getScaledWidth();
                int j = scaledresolution.getScaledHeight();
                this.setWorldAndResolution(this.mc, i, j);
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x, y, f);
        if (Math.abs(x - this.lastMouseX) <= 5 && Math.abs(y - this.lastMouseY) <= 5) {
            int activateDelay = 700;
            if (System.currentTimeMillis() >= this.mouseStillTime + (long)activateDelay) {
                int x1 = this.width / 2 - 150;
                int y1 = this.height / 6 - 5;
                if (y <= y1 + 98) {
                    y1 += 105;
                }
                int x2 = x1 + 150 + 150;
                int y2 = y1 + 84 + 10;
                GuiButton btn = this.getSelectedButton(x, y);
                if (btn != null) {
                    String s = this.getButtonName(btn.displayString);
                    String[] lines = this.getTooltipLines(s);
                    if (lines == null) {
                        return;
                    }
                    this.drawGradientRect(x1, y1, x2, y2, -536870912, -536870912);
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        int col = 0xDDDDDD;
                        if (line.endsWith("!")) {
                            col = 0xFF2020;
                        }
                        this.fontRendererObj.drawStringWithShadow(line, x1 + 5, y1 + 5 + i * 11, col);
                        ++i;
                    }
                }
            }
        } else {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
        }
    }

    private String[] getTooltipLines(String btnName) {
        String[] stringArray;
        if (btnName.equals("Mipmap Levels")) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "Visual effect which makes distant objects look better";
            stringArray2[1] = "by smoothing the texture details";
            stringArray2[2] = "  OFF - no smoothing";
            stringArray2[3] = "  1 - minimum smoothing";
            stringArray2[4] = "  4 - maximum smoothing";
            stringArray = stringArray2;
            stringArray2[5] = "This option usually does not affect the performance.";
        } else if (btnName.equals("Mipmap Type")) {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "Visual effect which makes distant objects look better";
            stringArray3[1] = "by smoothing the texture details";
            stringArray3[2] = "  Nearest - rough smoothing";
            stringArray3[3] = "  Linear - fine smoothing";
            stringArray = stringArray3;
            stringArray3[4] = "This option usually does not affect the performance.";
        } else if (btnName.equals("Anisotropic Filtering")) {
            String[] stringArray4 = new String[5];
            stringArray4[0] = "Anisotropic Filtering";
            stringArray4[1] = " OFF - (default) standard texture detail (faster)";
            stringArray4[2] = " 2-16 - finer details in mipmapped textures (slower)";
            stringArray4[3] = "The Anisotropic Filtering restores details in mipmapped";
            stringArray = stringArray4;
            stringArray4[4] = "textures. Higher values may decrease the FPS.";
        } else if (btnName.equals("Antialiasing")) {
            String[] stringArray5 = new String[8];
            stringArray5[0] = "Antialiasing";
            stringArray5[1] = " OFF - (default) no antialiasing (faster)";
            stringArray5[2] = " 2-16 - antialiased lines and edges (slower)";
            stringArray5[3] = "The Antialiasing smooths jagged lines and ";
            stringArray5[4] = "sharp color transitions.";
            stringArray5[5] = "Higher values may substantially decrease the FPS.";
            stringArray5[6] = "Not all levels are supported by all graphics cards.";
            stringArray = stringArray5;
            stringArray5[7] = "Effective after a RESTART!";
        } else if (btnName.equals("Clear Water")) {
            String[] stringArray6 = new String[3];
            stringArray6[0] = "Clear Water";
            stringArray6[1] = "  ON - clear, transparent water";
            stringArray = stringArray6;
            stringArray6[2] = "  OFF - default water";
        } else if (btnName.equals("Better Grass")) {
            String[] stringArray7 = new String[4];
            stringArray7[0] = "Better Grass";
            stringArray7[1] = "  OFF - default side grass texture, fastest";
            stringArray7[2] = "  Fast - full side grass texture, slower";
            stringArray = stringArray7;
            stringArray7[3] = "  Fancy - dynamic side grass texture, slowest";
        } else if (btnName.equals("Better Snow")) {
            String[] stringArray8 = new String[5];
            stringArray8[0] = "Better Snow";
            stringArray8[1] = "  OFF - default snow, faster";
            stringArray8[2] = "  ON - better snow, slower";
            stringArray8[3] = "Shows snow under transparent blocks (fence, tall grass)";
            stringArray = stringArray8;
            stringArray8[4] = "when bordering with snow blocks";
        } else if (btnName.equals("Random Mobs")) {
            String[] stringArray9 = new String[5];
            stringArray9[0] = "Random Mobs";
            stringArray9[1] = "  OFF - no random mobs, faster";
            stringArray9[2] = "  ON - random mobs, slower";
            stringArray9[3] = "Random mobs uses random textures for the game creatures.";
            stringArray = stringArray9;
            stringArray9[4] = "It needs a texture pack which has multiple mob textures.";
        } else if (btnName.equals("Swamp Colors")) {
            String[] stringArray10 = new String[4];
            stringArray10[0] = "Swamp Colors";
            stringArray10[1] = "  ON - use swamp colors (default), slower";
            stringArray10[2] = "  OFF - do not use swamp colors, faster";
            stringArray = stringArray10;
            stringArray10[3] = "The swamp colors affect grass, leaves, vines and water.";
        } else if (btnName.equals("Smooth Biomes")) {
            String[] stringArray11 = new String[6];
            stringArray11[0] = "Smooth Biomes";
            stringArray11[1] = "  ON - smoothing of biome borders (default), slower";
            stringArray11[2] = "  OFF - no smoothing of biome borders, faster";
            stringArray11[3] = "The smoothing of biome borders is done by sampling and";
            stringArray11[4] = "averaging the color of all surrounding blocks.";
            stringArray = stringArray11;
            stringArray11[5] = "Affected are grass, leaves, vines and water.";
        } else if (btnName.equals("Custom Fonts")) {
            String[] stringArray12 = new String[5];
            stringArray12[0] = "Custom Fonts";
            stringArray12[1] = "  ON - uses custom fonts (default), slower";
            stringArray12[2] = "  OFF - uses default font, faster";
            stringArray12[3] = "The custom fonts are supplied by the current";
            stringArray = stringArray12;
            stringArray12[4] = "texture pack";
        } else if (btnName.equals("Custom Colors")) {
            String[] stringArray13 = new String[5];
            stringArray13[0] = "Custom Colors";
            stringArray13[1] = "  ON - uses custom colors (default), slower";
            stringArray13[2] = "  OFF - uses default colors, faster";
            stringArray13[3] = "The custom colors are supplied by the current";
            stringArray = stringArray13;
            stringArray13[4] = "texture pack";
        } else if (btnName.equals("Show Capes")) {
            String[] stringArray14 = new String[3];
            stringArray14[0] = "Show Capes";
            stringArray14[1] = "  ON - show player capes (default)";
            stringArray = stringArray14;
            stringArray14[2] = "  OFF - do not show player capes";
        } else if (btnName.equals("Connected Textures")) {
            String[] stringArray15 = new String[8];
            stringArray15[0] = "Connected Textures";
            stringArray15[1] = "  OFF - no connected textures (default)";
            stringArray15[2] = "  Fast - fast connected textures";
            stringArray15[3] = "  Fancy - fancy connected textures";
            stringArray15[4] = "Connected textures joins the textures of glass,";
            stringArray15[5] = "sandstone and bookshelves when placed next to";
            stringArray15[6] = "each other. The connected textures are supplied";
            stringArray = stringArray15;
            stringArray15[7] = "by the current texture pack.";
        } else if (btnName.equals("Far View")) {
            String[] stringArray16 = new String[7];
            stringArray16[0] = "Far View";
            stringArray16[1] = " OFF - (default) standard view distance";
            stringArray16[2] = " ON - 3x view distance";
            stringArray16[3] = "Far View is very resource demanding!";
            stringArray16[4] = "3x view distance => 9x chunks to be loaded => FPS / 9";
            stringArray16[5] = "Standard view distances: 32, 64, 128, 256";
            stringArray = stringArray16;
            stringArray16[6] = "Far view distances: 96, 192, 384, 512";
        } else if (btnName.equals("Natural Textures")) {
            String[] stringArray17 = new String[8];
            stringArray17[0] = "Natural Textures";
            stringArray17[1] = "  OFF - no natural textures (default)";
            stringArray17[2] = "  ON - use natural textures";
            stringArray17[3] = "Natural textures remove the gridlike pattern";
            stringArray17[4] = "created by repeating blocks of the same type.";
            stringArray17[5] = "It uses rotated and flipped variants of the base";
            stringArray17[6] = "block texture. The configuration for the natural";
            stringArray = stringArray17;
            stringArray17[7] = "textures is supplied by the current texture pack";
        } else if (btnName.equals("Custom Sky")) {
            String[] stringArray18 = new String[5];
            stringArray18[0] = "Custom Sky";
            stringArray18[1] = "  ON - custom sky textures (default), slow";
            stringArray18[2] = "  OFF - default sky, faster";
            stringArray18[3] = "The custom sky textures are supplied by the current";
            stringArray = stringArray18;
            stringArray18[4] = "texture pack";
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String getButtonName(String displayString) {
        int pos = displayString.indexOf(58);
        return pos < 0 ? displayString : displayString.substring(0, pos);
    }

    private GuiButton getSelectedButton(int i, int j) {
        int k = 0;
        while (k < this.buttonList.size()) {
            boolean flag;
            GuiButton btn = (GuiButton)this.buttonList.get(k);
            int btnWidth = GuiVideoSettings.getButtonWidth(btn);
            int btnHeight = GuiVideoSettings.getButtonHeight(btn);
            boolean bl = flag = i >= btn.field_146128_h && j >= btn.field_146129_i && i < btn.field_146128_h + btnWidth && j < btn.field_146129_i + btnHeight;
            if (flag) {
                return btn;
            }
            ++k;
        }
        return null;
    }
}

