/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.src.Config;
import net.minecraft.src.CustomColorizer;
import net.minecraft.src.CustomSky;
import net.minecraft.src.NaturalTextures;
import net.minecraft.src.RandomMobs;
import net.minecraft.src.TextureAnimations;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesOakOpaque = "leaves_oak_opaque";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texLeavesJungleOpaque = "leaves_jungle_opaque";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texLogJungle = "log_jungle";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_layer_0";
    public static final String texFireLayer1 = "fire_layer_1";
    public static final String texPortal = "portal";
    public static IIcon iconGrassTop;
    public static IIcon iconGrassSide;
    public static IIcon iconGrassSideOverlay;
    public static IIcon iconSnow;
    public static IIcon iconGrassSideSnowed;
    public static IIcon iconMyceliumSide;
    public static IIcon iconMyceliumTop;
    public static IIcon iconWaterStill;
    public static IIcon iconWaterFlow;
    public static IIcon iconLavaStill;
    public static IIcon iconLavaFlow;
    public static IIcon iconPortal;
    public static IIcon iconFireLayer0;
    public static IIcon iconFireLayer1;
    private static IntBuffer staticBuffer;

    static {
        staticBuffer = GLAllocation.createDirectIntBuffer(256);
    }

    public static void update() {
        TextureMap mapBlocks = TextureMap.textureMapBlocks;
        if (mapBlocks != null) {
            iconGrassTop = mapBlocks.getIconSafe(texGrassTop);
            iconGrassSide = mapBlocks.getIconSafe(texGrassSide);
            iconGrassSideOverlay = mapBlocks.getIconSafe(texGrassSideOverlay);
            iconSnow = mapBlocks.getIconSafe(texSnow);
            iconGrassSideSnowed = mapBlocks.getIconSafe(texGrassSideSnowed);
            iconMyceliumSide = mapBlocks.getIconSafe(texMyceliumSide);
            iconMyceliumTop = mapBlocks.getIconSafe(texMyceliumTop);
            iconWaterStill = mapBlocks.getIconSafe(texWaterStill);
            iconWaterFlow = mapBlocks.getIconSafe(texWaterFlow);
            iconLavaStill = mapBlocks.getIconSafe(texLavaStill);
            iconLavaFlow = mapBlocks.getIconSafe(texLavaFlow);
            iconFireLayer0 = mapBlocks.getIconSafe(texFireLayer0);
            iconFireLayer1 = mapBlocks.getIconSafe(texFireLayer1);
            iconPortal = mapBlocks.getIconSafe(texPortal);
        }
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static TextureAtlasSprite getTextureAtlasSprite(IIcon icon) {
        return icon instanceof TextureAtlasSprite ? (TextureAtlasSprite)icon : null;
    }

    public static int ceilPowerOfTwo(int val) {
        int i = 1;
        while (i < val) {
            i *= 2;
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        int i = 0;
        while (i < power) {
            val *= 2;
            ++i;
        }
        return val;
    }

    public static void refreshBlockTextures() {
        Config.dbg("*** Reloading block textures ***");
        TextureMap.textureMapBlocks.loadTextureSafe(Config.getResourceManager());
        TextureUtils.update();
        NaturalTextures.update();
        TextureMap.textureMapBlocks.updateAnimations();
    }

    public static ITextureObject getTexture(String path) {
        return TextureUtils.getTexture(new ResourceLocation(path));
    }

    public static ITextureObject getTexture(ResourceLocation loc) {
        ITextureObject tex = Config.getTextureManager().getTexture(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        SimpleTexture tex1 = new SimpleTexture(loc);
        Config.getTextureManager().loadTexture(loc, tex1);
        return tex1;
    }

    public static void resourcesReloaded(IResourceManager rm) {
        if (TextureMap.textureMapBlocks != null) {
            Config.dbg("*** Reloading custom textures ***");
            CustomSky.reset();
            TextureAnimations.reset();
            TextureUtils.update();
            NaturalTextures.update();
            TextureAnimations.update();
            CustomColorizer.update();
            CustomSky.update();
            RandomMobs.resetTextures();
            Config.updateTexturePackClouds();
            Config.getTextureManager().tick();
        }
    }

    public static void refreshTextureMaps(IResourceManager rm) {
        TextureMap.textureMapBlocks.loadTextureSafe(rm);
        TextureMap.textureMapItems.loadTextureSafe(rm);
        TextureUtils.update();
        NaturalTextures.update();
    }

    public static void registerResourceListener() {
        IResourceManager rm = Config.getResourceManager();
        if (rm instanceof IReloadableResourceManager) {
            IReloadableResourceManager tto = (IReloadableResourceManager)rm;
            IResourceManagerReloadListener ttol = new IResourceManagerReloadListener(){

                @Override
                public void onResourceManagerReload(IResourceManager var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            tto.registerReloadListener(ttol);
        }
        ITickableTextureObject tto1 = new ITickableTextureObject(){

            @Override
            public void tick() {
                TextureAnimations.updateCustomAnimations();
            }

            @Override
            public void loadTexture(IResourceManager var1) throws IOException {
            }

            @Override
            public int getGlTextureId() {
                return 0;
            }
        };
        ResourceLocation ttol1 = new ResourceLocation("optifine/TickableTextures");
        Config.getTextureManager().loadTickableTexture(ttol1, tto1);
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = String.valueOf(basePath) + "/";
            }
            path = String.valueOf(basePath) + path;
            return path;
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = String.valueOf(strMcpatcher) + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = String.valueOf(strMcpatcher) + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        return pos < 0 ? "" : path.substring(0, pos);
    }
}

