/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockDoor;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class VillageCollection
extends WorldSavedData {
    private World worldObj;
    private final List villagerPositionsList = new ArrayList();
    private final List newDoors = new ArrayList();
    private final List villageList = new ArrayList();
    private int tickCounter;
    private static final String __OBFID = "CL_00001635";

    public VillageCollection(String p_i1677_1_) {
        super(p_i1677_1_);
    }

    public VillageCollection(World p_i1678_1_) {
        super("villages");
        this.worldObj = p_i1678_1_;
        this.markDirty();
    }

    public void func_82566_a(World p_82566_1_) {
        this.worldObj = p_82566_1_;
        for (Village var3 : this.villageList) {
            var3.func_82691_a(p_82566_1_);
        }
    }

    public void addVillagerPosition(int p_75551_1_, int p_75551_2_, int p_75551_3_) {
        if (this.villagerPositionsList.size() <= 64 && !this.isVillagerPositionPresent(p_75551_1_, p_75551_2_, p_75551_3_)) {
            this.villagerPositionsList.add(new ChunkCoordinates(p_75551_1_, p_75551_2_, p_75551_3_));
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (Village var2 : this.villageList) {
            var2.tick(this.tickCounter);
        }
        this.removeAnnihilatedVillages();
        this.dropOldestVillagerPosition();
        this.addNewDoorsToVillageOrCreateVillage();
        if (this.tickCounter % 400 == 0) {
            this.markDirty();
        }
    }

    private void removeAnnihilatedVillages() {
        Iterator var1 = this.villageList.iterator();
        while (var1.hasNext()) {
            Village var2 = (Village)var1.next();
            if (!var2.isAnnihilated()) continue;
            var1.remove();
            this.markDirty();
        }
    }

    public List getVillageList() {
        return this.villageList;
    }

    public Village findNearestVillage(int p_75550_1_, int p_75550_2_, int p_75550_3_, int p_75550_4_) {
        Village var5 = null;
        float var6 = Float.MAX_VALUE;
        for (Village var8 : this.villageList) {
            float var10;
            float var9 = var8.getCenter().getDistanceSquared(p_75550_1_, p_75550_2_, p_75550_3_);
            if (!(var9 < var6) || !(var9 <= (var10 = (float)(p_75550_4_ + var8.getVillageRadius())) * var10)) continue;
            var5 = var8;
            var6 = var9;
        }
        return var5;
    }

    private void dropOldestVillagerPosition() {
        if (!this.villagerPositionsList.isEmpty()) {
            this.addUnassignedWoodenDoorsAroundToNewDoorsList((ChunkCoordinates)this.villagerPositionsList.remove(0));
        }
    }

    private void addNewDoorsToVillageOrCreateVillage() {
        int var1 = 0;
        while (var1 < this.newDoors.size()) {
            VillageDoorInfo var2 = (VillageDoorInfo)this.newDoors.get(var1);
            boolean var3 = false;
            for (Village var5 : this.villageList) {
                int var7;
                int var6 = (int)var5.getCenter().getDistanceSquared(var2.posX, var2.posY, var2.posZ);
                if (var6 > (var7 = 32 + var5.getVillageRadius()) * var7) continue;
                var5.addVillageDoorInfo(var2);
                var3 = true;
                break;
            }
            if (!var3) {
                Village var8 = new Village(this.worldObj);
                var8.addVillageDoorInfo(var2);
                this.villageList.add(var8);
                this.markDirty();
            }
            ++var1;
        }
        this.newDoors.clear();
    }

    private void addUnassignedWoodenDoorsAroundToNewDoorsList(ChunkCoordinates p_75546_1_) {
        int var2 = 16;
        int var3 = 4;
        int var4 = 16;
        int var5 = p_75546_1_.posX - var2;
        while (var5 < p_75546_1_.posX + var2) {
            int var6 = p_75546_1_.posY - var3;
            while (var6 < p_75546_1_.posY + var3) {
                int var7 = p_75546_1_.posZ - var4;
                while (var7 < p_75546_1_.posZ + var4) {
                    if (this.isWoodenDoorAt(var5, var6, var7)) {
                        VillageDoorInfo var8 = this.getVillageDoorAt(var5, var6, var7);
                        if (var8 == null) {
                            this.addDoorToNewListIfAppropriate(var5, var6, var7);
                        } else {
                            var8.lastActivityTimestamp = this.tickCounter;
                        }
                    }
                    ++var7;
                }
                ++var6;
            }
            ++var5;
        }
    }

    private VillageDoorInfo getVillageDoorAt(int p_75547_1_, int p_75547_2_, int p_75547_3_) {
        VillageDoorInfo var5;
        Iterator var4 = this.newDoors.iterator();
        do {
            if (!var4.hasNext()) {
                Village var7;
                VillageDoorInfo var6;
                var4 = this.villageList.iterator();
                do {
                    if (var4.hasNext()) continue;
                    return null;
                } while ((var6 = (var7 = (Village)var4.next()).getVillageDoorAt(p_75547_1_, p_75547_2_, p_75547_3_)) == null);
                return var6;
            }
            var5 = (VillageDoorInfo)var4.next();
        } while (var5.posX != p_75547_1_ || var5.posZ != p_75547_3_ || Math.abs(var5.posY - p_75547_2_) > 1);
        return var5;
    }

    private void addDoorToNewListIfAppropriate(int p_75542_1_, int p_75542_2_, int p_75542_3_) {
        int var4 = ((BlockDoor)Blocks.wooden_door).func_150013_e(this.worldObj, p_75542_1_, p_75542_2_, p_75542_3_);
        if (var4 != 0 && var4 != 2) {
            int var5 = 0;
            int var6 = -5;
            while (var6 < 0) {
                if (this.worldObj.canBlockSeeTheSky(p_75542_1_, p_75542_2_, p_75542_3_ + var6)) {
                    --var5;
                }
                ++var6;
            }
            var6 = 1;
            while (var6 <= 5) {
                if (this.worldObj.canBlockSeeTheSky(p_75542_1_, p_75542_2_, p_75542_3_ + var6)) {
                    ++var5;
                }
                ++var6;
            }
            if (var5 != 0) {
                this.newDoors.add(new VillageDoorInfo(p_75542_1_, p_75542_2_, p_75542_3_, 0, var5 > 0 ? -2 : 2, this.tickCounter));
            }
        } else {
            int var5 = 0;
            int var6 = -5;
            while (var6 < 0) {
                if (this.worldObj.canBlockSeeTheSky(p_75542_1_ + var6, p_75542_2_, p_75542_3_)) {
                    --var5;
                }
                ++var6;
            }
            var6 = 1;
            while (var6 <= 5) {
                if (this.worldObj.canBlockSeeTheSky(p_75542_1_ + var6, p_75542_2_, p_75542_3_)) {
                    ++var5;
                }
                ++var6;
            }
            if (var5 != 0) {
                this.newDoors.add(new VillageDoorInfo(p_75542_1_, p_75542_2_, p_75542_3_, var5 > 0 ? -2 : 2, 0, this.tickCounter));
            }
        }
    }

    private boolean isVillagerPositionPresent(int p_75548_1_, int p_75548_2_, int p_75548_3_) {
        ChunkCoordinates var5;
        Iterator var4 = this.villagerPositionsList.iterator();
        do {
            if (!var4.hasNext()) {
                return false;
            }
            var5 = (ChunkCoordinates)var4.next();
        } while (var5.posX != p_75548_1_ || var5.posY != p_75548_2_ || var5.posZ != p_75548_3_);
        return true;
    }

    private boolean isWoodenDoorAt(int p_75541_1_, int p_75541_2_, int p_75541_3_) {
        return this.worldObj.getBlock(p_75541_1_, p_75541_2_, p_75541_3_) == Blocks.wooden_door;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_76184_1_) {
        this.tickCounter = p_76184_1_.getInteger("Tick");
        NBTTagList var2 = p_76184_1_.getTagList("Villages", 10);
        int var3 = 0;
        while (var3 < var2.tagCount()) {
            NBTTagCompound var4 = var2.getCompoundTagAt(var3);
            Village var5 = new Village();
            var5.readVillageDataFromNBT(var4);
            this.villageList.add(var5);
            ++var3;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound p_76187_1_) {
        p_76187_1_.setInteger("Tick", this.tickCounter);
        NBTTagList var2 = new NBTTagList();
        for (Village var4 : this.villageList) {
            NBTTagCompound var5 = new NBTTagCompound();
            var4.writeVillageDataToNBT(var5);
            var2.appendTag(var5);
        }
        p_76187_1_.setTag("Villages", var2);
    }
}

