/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilChunkLoader
implements IChunkLoader,
IThreadedFileIO {
    private static final Logger logger = LogManager.getLogger();
    private List chunksToRemove = new ArrayList();
    private Set pendingAnvilChunksCoordinates = new HashSet();
    private Object syncLockObject = new Object();
    private final File chunkSaveLocation;
    private static final String __OBFID = "CL_00000384";

    public AnvilChunkLoader(File p_i2003_1_) {
        this.chunkSaveLocation = p_i2003_1_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Chunk loadChunk(World p_75815_1_, int p_75815_2_, int p_75815_3_) throws IOException {
        NBTTagCompound var4 = null;
        ChunkCoordIntPair var5 = new ChunkCoordIntPair(p_75815_2_, p_75815_3_);
        Object var6 = this.syncLockObject;
        Object object = this.syncLockObject;
        synchronized (object) {
            if (this.pendingAnvilChunksCoordinates.contains(var5)) {
                int var7 = 0;
                while (var7 < this.chunksToRemove.size()) {
                    if (((PendingChunk)this.chunksToRemove.get((int)var7)).chunkCoordinate.equals(var5)) {
                        var4 = ((PendingChunk)this.chunksToRemove.get((int)var7)).nbtTags;
                        break;
                    }
                    ++var7;
                }
            }
        }
        if (var4 == null) {
            DataInputStream var10 = RegionFileCache.getChunkInputStream(this.chunkSaveLocation, p_75815_2_, p_75815_3_);
            if (var10 == null) {
                return null;
            }
            var4 = CompressedStreamTools.read(var10);
        }
        return this.checkedReadChunkFromNBT(p_75815_1_, p_75815_2_, p_75815_3_, var4);
    }

    protected Chunk checkedReadChunkFromNBT(World p_75822_1_, int p_75822_2_, int p_75822_3_, NBTTagCompound p_75822_4_) {
        if (!p_75822_4_.func_150297_b("Level", 10)) {
            logger.error("Chunk file at " + p_75822_2_ + "," + p_75822_3_ + " is missing level data, skipping");
            return null;
        }
        if (!p_75822_4_.getCompoundTag("Level").func_150297_b("Sections", 9)) {
            logger.error("Chunk file at " + p_75822_2_ + "," + p_75822_3_ + " is missing block data, skipping");
            return null;
        }
        Chunk var5 = this.readChunkFromNBT(p_75822_1_, p_75822_4_.getCompoundTag("Level"));
        if (!var5.isAtLocation(p_75822_2_, p_75822_3_)) {
            logger.error("Chunk file at " + p_75822_2_ + "," + p_75822_3_ + " is in the wrong location; relocating. (Expected " + p_75822_2_ + ", " + p_75822_3_ + ", got " + var5.xPosition + ", " + var5.zPosition + ")");
            p_75822_4_.setInteger("xPos", p_75822_2_);
            p_75822_4_.setInteger("zPos", p_75822_3_);
            var5 = this.readChunkFromNBT(p_75822_1_, p_75822_4_.getCompoundTag("Level"));
        }
        return var5;
    }

    @Override
    public void saveChunk(World p_75816_1_, Chunk p_75816_2_) throws MinecraftException, IOException {
        p_75816_1_.checkSessionLock();
        try {
            NBTTagCompound var3 = new NBTTagCompound();
            NBTTagCompound var4 = new NBTTagCompound();
            var3.setTag("Level", var4);
            this.writeChunkToNBT(p_75816_2_, p_75816_1_, var4);
            this.addChunkToPending(p_75816_2_.getChunkCoordIntPair(), var3);
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChunkToPending(ChunkCoordIntPair p_75824_1_, NBTTagCompound p_75824_2_) {
        Object var3 = this.syncLockObject;
        Object object = this.syncLockObject;
        synchronized (object) {
            if (this.pendingAnvilChunksCoordinates.contains(p_75824_1_)) {
                int var4 = 0;
                while (var4 < this.chunksToRemove.size()) {
                    if (((PendingChunk)this.chunksToRemove.get((int)var4)).chunkCoordinate.equals(p_75824_1_)) {
                        this.chunksToRemove.set(var4, new PendingChunk(p_75824_1_, p_75824_2_));
                        return;
                    }
                    ++var4;
                }
            }
            this.chunksToRemove.add(new PendingChunk(p_75824_1_, p_75824_2_));
            this.pendingAnvilChunksCoordinates.add(p_75824_1_);
            ThreadedFileIOBase.threadedIOInstance.queueIO(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeNextIO() {
        PendingChunk var1 = null;
        Object var2 = this.syncLockObject;
        Object object = this.syncLockObject;
        synchronized (object) {
            block7: {
                if (!this.chunksToRemove.isEmpty()) break block7;
                return false;
            }
            var1 = (PendingChunk)this.chunksToRemove.remove(0);
            this.pendingAnvilChunksCoordinates.remove(var1.chunkCoordinate);
        }
        if (var1 != null) {
            try {
                this.writeChunkNBTTags(var1);
            }
            catch (Exception var4) {
                var4.printStackTrace();
            }
        }
        return true;
    }

    private void writeChunkNBTTags(PendingChunk p_75821_1_) throws IOException {
        DataOutputStream var2 = RegionFileCache.getChunkOutputStream(this.chunkSaveLocation, p_75821_1_.chunkCoordinate.chunkXPos, p_75821_1_.chunkCoordinate.chunkZPos);
        CompressedStreamTools.write(p_75821_1_.nbtTags, var2);
        var2.close();
    }

    @Override
    public void saveExtraChunkData(World p_75819_1_, Chunk p_75819_2_) {
    }

    @Override
    public void chunkTick() {
    }

    @Override
    public void saveExtraData() {
        while (this.writeNextIO()) {
        }
    }

    private void writeChunkToNBT(Chunk p_75820_1_, World p_75820_2_, NBTTagCompound p_75820_3_) {
        NBTTagCompound var11;
        p_75820_3_.setByte("V", (byte)1);
        p_75820_3_.setInteger("xPos", p_75820_1_.xPosition);
        p_75820_3_.setInteger("zPos", p_75820_1_.zPosition);
        p_75820_3_.setLong("LastUpdate", p_75820_2_.getTotalWorldTime());
        p_75820_3_.setIntArray("HeightMap", p_75820_1_.heightMap);
        p_75820_3_.setBoolean("TerrainPopulated", p_75820_1_.isTerrainPopulated);
        p_75820_3_.setBoolean("LightPopulated", p_75820_1_.isLightPopulated);
        p_75820_3_.setLong("InhabitedTime", p_75820_1_.inhabitedTime);
        ExtendedBlockStorage[] var4 = p_75820_1_.getBlockStorageArray();
        NBTTagList var5 = new NBTTagList();
        boolean var6 = !p_75820_2_.provider.hasNoSky;
        ExtendedBlockStorage[] var7 = var4;
        int var8 = var4.length;
        int var9 = 0;
        while (var9 < var8) {
            ExtendedBlockStorage var10 = var7[var9];
            if (var10 != null) {
                var11 = new NBTTagCompound();
                var11.setByte("Y", (byte)(var10.getYLocation() >> 4 & 0xFF));
                var11.setByteArray("Blocks", var10.getBlockLSBArray());
                if (var10.getBlockMSBArray() != null) {
                    var11.setByteArray("Add", var10.getBlockMSBArray().data);
                }
                var11.setByteArray("Data", var10.getMetadataArray().data);
                var11.setByteArray("BlockLight", var10.getBlocklightArray().data);
                if (var6) {
                    var11.setByteArray("SkyLight", var10.getSkylightArray().data);
                } else {
                    var11.setByteArray("SkyLight", new byte[var10.getBlocklightArray().data.length]);
                }
                var5.appendTag(var11);
            }
            ++var9;
        }
        p_75820_3_.setTag("Sections", var5);
        p_75820_3_.setByteArray("Biomes", p_75820_1_.getBiomeArray());
        p_75820_1_.hasEntities = false;
        NBTTagList var16 = new NBTTagList();
        var8 = 0;
        while (var8 < p_75820_1_.entityLists.length) {
            for (Entity var20 : p_75820_1_.entityLists[var8]) {
                if (!var20.writeToNBTOptional(var11 = new NBTTagCompound())) continue;
                p_75820_1_.hasEntities = true;
                var16.appendTag(var11);
            }
            ++var8;
        }
        p_75820_3_.setTag("Entities", var16);
        NBTTagList var17 = new NBTTagList();
        for (TileEntity var21 : p_75820_1_.chunkTileEntityMap.values()) {
            var11 = new NBTTagCompound();
            var21.writeToNBT(var11);
            var17.appendTag(var11);
        }
        p_75820_3_.setTag("TileEntities", var17);
        List var19 = p_75820_2_.getPendingBlockUpdates(p_75820_1_, false);
        if (var19 != null) {
            long var22 = p_75820_2_.getTotalWorldTime();
            NBTTagList var12 = new NBTTagList();
            for (NextTickListEntry var14 : var19) {
                NBTTagCompound var15 = new NBTTagCompound();
                var15.setInteger("i", Block.getIdFromBlock(var14.func_151351_a()));
                var15.setInteger("x", var14.xCoord);
                var15.setInteger("y", var14.yCoord);
                var15.setInteger("z", var14.zCoord);
                var15.setInteger("t", (int)(var14.scheduledTime - var22));
                var15.setInteger("p", var14.priority);
                var12.appendTag(var15);
            }
            p_75820_3_.setTag("TileTicks", var12);
        }
    }

    private Chunk readChunkFromNBT(World p_75823_1_, NBTTagCompound p_75823_2_) {
        NBTTagList var22;
        NBTTagList var19;
        NBTTagList var17;
        int var3 = p_75823_2_.getInteger("xPos");
        int var4 = p_75823_2_.getInteger("zPos");
        Chunk var5 = new Chunk(p_75823_1_, var3, var4);
        var5.heightMap = p_75823_2_.getIntArray("HeightMap");
        var5.isTerrainPopulated = p_75823_2_.getBoolean("TerrainPopulated");
        var5.isLightPopulated = p_75823_2_.getBoolean("LightPopulated");
        var5.inhabitedTime = p_75823_2_.getLong("InhabitedTime");
        NBTTagList var6 = p_75823_2_.getTagList("Sections", 10);
        int var7 = 16;
        ExtendedBlockStorage[] var8 = new ExtendedBlockStorage[var7];
        boolean var9 = !p_75823_1_.provider.hasNoSky;
        int var10 = 0;
        while (var10 < var6.tagCount()) {
            NBTTagCompound var11 = var6.getCompoundTagAt(var10);
            byte var12 = var11.getByte("Y");
            ExtendedBlockStorage var13 = new ExtendedBlockStorage(var12 << 4, var9);
            var13.setBlockLSBArray(var11.getByteArray("Blocks"));
            if (var11.func_150297_b("Add", 7)) {
                var13.setBlockMSBArray(new NibbleArray(var11.getByteArray("Add"), 4));
            }
            var13.setBlockMetadataArray(new NibbleArray(var11.getByteArray("Data"), 4));
            var13.setBlocklightArray(new NibbleArray(var11.getByteArray("BlockLight"), 4));
            if (var9) {
                var13.setSkylightArray(new NibbleArray(var11.getByteArray("SkyLight"), 4));
            }
            var13.removeInvalidBlocks();
            var8[var12] = var13;
            ++var10;
        }
        var5.setStorageArrays(var8);
        if (p_75823_2_.func_150297_b("Biomes", 7)) {
            var5.setBiomeArray(p_75823_2_.getByteArray("Biomes"));
        }
        if ((var17 = p_75823_2_.getTagList("Entities", 10)) != null) {
            int var18 = 0;
            while (var18 < var17.tagCount()) {
                NBTTagCompound var20 = var17.getCompoundTagAt(var18);
                Entity var23 = EntityList.createEntityFromNBT(var20, p_75823_1_);
                var5.hasEntities = true;
                if (var23 != null) {
                    var5.addEntity(var23);
                    Entity var14 = var23;
                    NBTTagCompound var15 = var20;
                    while (var15.func_150297_b("Riding", 10)) {
                        Entity var16 = EntityList.createEntityFromNBT(var15.getCompoundTag("Riding"), p_75823_1_);
                        if (var16 != null) {
                            var5.addEntity(var16);
                            var14.mountEntity(var16);
                        }
                        var14 = var16;
                        var15 = var15.getCompoundTag("Riding");
                    }
                }
                ++var18;
            }
        }
        if ((var19 = p_75823_2_.getTagList("TileEntities", 10)) != null) {
            int var21 = 0;
            while (var21 < var19.tagCount()) {
                NBTTagCompound var24 = var19.getCompoundTagAt(var21);
                TileEntity var26 = TileEntity.createAndLoadEntity(var24);
                if (var26 != null) {
                    var5.addTileEntity(var26);
                }
                ++var21;
            }
        }
        if (p_75823_2_.func_150297_b("TileTicks", 9) && (var22 = p_75823_2_.getTagList("TileTicks", 10)) != null) {
            int var25 = 0;
            while (var25 < var22.tagCount()) {
                NBTTagCompound var27 = var22.getCompoundTagAt(var25);
                p_75823_1_.func_147446_b(var27.getInteger("x"), var27.getInteger("y"), var27.getInteger("z"), Block.getBlockById(var27.getInteger("i")), var27.getInteger("t"), var27.getInteger("p"));
                ++var25;
            }
        }
        return var5;
    }

    static class PendingChunk {
        public final ChunkCoordIntPair chunkCoordinate;
        public final NBTTagCompound nbtTags;
        private static final String __OBFID = "CL_00000385";

        public PendingChunk(ChunkCoordIntPair p_i2002_1_, NBTTagCompound p_i2002_2_) {
            this.chunkCoordinate = p_i2002_1_;
            this.nbtTags = p_i2002_2_;
        }
    }
}

