/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class MapGenVillage
extends MapGenStructure {
    public static final List villageSpawnBiomes = Arrays.asList(BiomeGenBase.plains, BiomeGenBase.desert, BiomeGenBase.field_150588_X);
    private int terrainType;
    private int field_82665_g = 32;
    private int field_82666_h = 8;
    private static final String __OBFID = "CL_00000514";

    public MapGenVillage() {
    }

    public MapGenVillage(Map p_i2093_1_) {
        this();
        for (Map.Entry var3 : p_i2093_1_.entrySet()) {
            if (((String)var3.getKey()).equals("size")) {
                this.terrainType = MathHelper.parseIntWithDefaultAndMax((String)var3.getValue(), this.terrainType, 0);
                continue;
            }
            if (!((String)var3.getKey()).equals("distance")) continue;
            this.field_82665_g = MathHelper.parseIntWithDefaultAndMax((String)var3.getValue(), this.field_82665_g, this.field_82666_h + 1);
        }
    }

    @Override
    public String func_143025_a() {
        return "Village";
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_75047_1_, int p_75047_2_) {
        boolean var8;
        int var3 = p_75047_1_;
        int var4 = p_75047_2_;
        if (p_75047_1_ < 0) {
            p_75047_1_ -= this.field_82665_g - 1;
        }
        if (p_75047_2_ < 0) {
            p_75047_2_ -= this.field_82665_g - 1;
        }
        int var5 = p_75047_1_ / this.field_82665_g;
        int var6 = p_75047_2_ / this.field_82665_g;
        Random var7 = this.worldObj.setRandomSeed(var5, var6, 10387312);
        var5 *= this.field_82665_g;
        var6 *= this.field_82665_g;
        return var3 == (var5 += var7.nextInt(this.field_82665_g - this.field_82666_h)) && var4 == (var6 += var7.nextInt(this.field_82665_g - this.field_82666_h)) && (var8 = this.worldObj.getWorldChunkManager().areBiomesViable(var3 * 16 + 8, var4 * 16 + 8, 0, villageSpawnBiomes));
    }

    @Override
    protected StructureStart getStructureStart(int p_75049_1_, int p_75049_2_) {
        return new Start(this.worldObj, this.rand, p_75049_1_, p_75049_2_, this.terrainType);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;
        private static final String __OBFID = "CL_00000515";

        public Start() {
        }

        public Start(World p_i2092_1_, Random p_i2092_2_, int p_i2092_3_, int p_i2092_4_, int p_i2092_5_) {
            super(p_i2092_3_, p_i2092_4_);
            int var10;
            List var6 = StructureVillagePieces.getStructureVillageWeightedPieceList(p_i2092_2_, p_i2092_5_);
            StructureVillagePieces.Start var7 = new StructureVillagePieces.Start(p_i2092_1_.getWorldChunkManager(), 0, p_i2092_2_, (p_i2092_3_ << 4) + 2, (p_i2092_4_ << 4) + 2, var6, p_i2092_5_);
            this.components.add(var7);
            var7.buildComponent(var7, this.components, p_i2092_2_);
            List var8 = var7.field_74930_j;
            List var9 = var7.field_74932_i;
            while (!var8.isEmpty() || !var9.isEmpty()) {
                StructureComponent var11;
                if (var8.isEmpty()) {
                    var10 = p_i2092_2_.nextInt(var9.size());
                    var11 = (StructureComponent)var9.remove(var10);
                    var11.buildComponent(var7, this.components, p_i2092_2_);
                    continue;
                }
                var10 = p_i2092_2_.nextInt(var8.size());
                var11 = (StructureComponent)var8.remove(var10);
                var11.buildComponent(var7, this.components, p_i2092_2_);
            }
            this.updateBoundingBox();
            var10 = 0;
            for (StructureComponent var12 : this.components) {
                if (var12 instanceof StructureVillagePieces.Road) continue;
                ++var10;
            }
            this.hasMoreThanTwoComponents = var10 > 2;
        }

        @Override
        public boolean isSizeableStructure() {
            return this.hasMoreThanTwoComponents;
        }

        @Override
        public void func_143022_a(NBTTagCompound p_143022_1_) {
            super.func_143022_a(p_143022_1_);
            p_143022_1_.setBoolean("Valid", this.hasMoreThanTwoComponents);
        }

        @Override
        public void func_143017_b(NBTTagCompound p_143017_1_) {
            super.func_143017_b(p_143017_1_);
            this.hasMoreThanTwoComponents = p_143017_1_.getBoolean("Valid");
        }
    }
}

