/*
 * Decompiled with CFR 0.152.
 */
package z.state.transition;

import z.Color;
import z.GameContainer;
import z.Graphics;
import z.state.GameState;
import z.state.StateBasedGame;
import z.state.transition.Transition;

public class FadeOutTransition
implements Transition {
    private Color color;
    private int fadeTime;

    public FadeOutTransition() {
        this(Color.black, 500);
    }

    public FadeOutTransition(Color color) {
        this(color, 500);
    }

    public FadeOutTransition(Color color, int fadeTime) {
        this.color = new Color(color);
        this.color.a = 0.0f;
        this.fadeTime = fadeTime;
    }

    @Override
    public boolean isComplete() {
        return this.color.a >= 1.0f;
    }

    @Override
    public void postRender(StateBasedGame game, GameContainer container, Graphics g) {
        Color old = g.getColor();
        g.setColor(this.color);
        g.fillRect(0.0f, 0.0f, container.getWidth() * 2, container.getHeight() * 2);
        g.setColor(old);
    }

    @Override
    public void update(StateBasedGame game, GameContainer container, int delta) {
        this.color.a += (float)delta * (1.0f / (float)this.fadeTime);
        if (this.color.a > 1.0f) {
            this.color.a = 1.0f;
        }
    }

    @Override
    public void preRender(StateBasedGame game, GameContainer container, Graphics g) {
    }

    @Override
    public void init(GameState firstState, GameState secondState) {
    }
}

