/*
 * Decompiled with CFR 0.152.
 */
package z.svg;

import java.util.ArrayList;
import z.Color;
import z.Image;
import z.ImageBuffer;
import z.geom.Transform;
import z.svg.Diagram;

public class Gradient {
    private String name;
    private ArrayList steps = new ArrayList();
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float r;
    private Image image;
    private boolean radial;
    private Transform transform;
    private String ref;

    public Gradient(String name, boolean radial) {
        this.name = name;
        this.radial = radial;
    }

    public boolean isRadial() {
        return this.radial;
    }

    public void setTransform(Transform trans) {
        this.transform = trans;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void reference(String ref) {
        this.ref = ref;
    }

    public void resolve(Diagram diagram) {
        if (this.ref == null) {
            return;
        }
        Gradient other = diagram.getGradient(this.ref);
        int i = 0;
        while (i < other.steps.size()) {
            this.steps.add(other.steps.get(i));
            ++i;
        }
    }

    public void genImage() {
        if (this.image == null) {
            ImageBuffer buffer = new ImageBuffer(128, 16);
            int i = 0;
            while (i < 128) {
                Color col = this.getColorAt((float)i / 128.0f);
                int j = 0;
                while (j < 16) {
                    buffer.setRGBA(i, j, col.getRedByte(), col.getGreenByte(), col.getBlueByte(), col.getAlphaByte());
                    ++j;
                }
                ++i;
            }
            this.image = buffer.getImage();
        }
    }

    public Image getImage() {
        this.genImage();
        return this.image;
    }

    public void setR(float r) {
        this.r = r;
    }

    public void setX1(float x1) {
        this.x1 = x1;
    }

    public void setX2(float x2) {
        this.x2 = x2;
    }

    public void setY1(float y1) {
        this.y1 = y1;
    }

    public void setY2(float y2) {
        this.y2 = y2;
    }

    public float getR() {
        return this.r;
    }

    public float getX1() {
        return this.x1;
    }

    public float getX2() {
        return this.x2;
    }

    public float getY1() {
        return this.y1;
    }

    public float getY2() {
        return this.y2;
    }

    public void addStep(float location, Color c) {
        this.steps.add(new Step(location, c));
    }

    public Color getColorAt(float p) {
        if (p <= 0.0f) {
            return ((Step)this.steps.get((int)0)).col;
        }
        if (p > 1.0f) {
            return ((Step)this.steps.get((int)(this.steps.size() - 1))).col;
        }
        int i = 1;
        while (i < this.steps.size()) {
            Step prev = (Step)this.steps.get(i - 1);
            Step current = (Step)this.steps.get(i);
            if (p <= current.location) {
                float dis = current.location - prev.location;
                float v = (p -= prev.location) / dis;
                Color c = new Color(1, 1, 1, 1);
                c.a = prev.col.a * (1.0f - v) + current.col.a * v;
                c.r = prev.col.r * (1.0f - v) + current.col.r * v;
                c.g = prev.col.g * (1.0f - v) + current.col.g * v;
                c.b = prev.col.b * (1.0f - v) + current.col.b * v;
                return c;
            }
            ++i;
        }
        return Color.black;
    }

    private class Step {
        float location;
        Color col;

        public Step(float location, Color c) {
            this.location = location;
            this.col = c;
        }
    }
}

