/*
 * Decompiled with CFR 0.152.
 */
package z.svg;

import z.Color;
import z.Graphics;
import z.geom.Shape;
import z.geom.ShapeRenderer;
import z.geom.TexCoordGenerator;
import z.opengl.TextureImpl;
import z.opengl.renderer.Renderer;
import z.opengl.renderer.SGL;
import z.svg.Diagram;
import z.svg.Figure;
import z.svg.Gradient;
import z.svg.LinearGradientFill;
import z.svg.RadialGradientFill;

public class SimpleDiagramRenderer {
    protected static SGL GL = Renderer.get();
    public Diagram diagram;
    public int list = -1;

    public SimpleDiagramRenderer(Diagram diagram) {
        this.diagram = diagram;
    }

    public void render(Graphics g) {
        if (this.list == -1) {
            this.list = GL.glGenLists(1);
            GL.glNewList(this.list, 4864);
            SimpleDiagramRenderer.render(g, this.diagram);
            GL.glEndList();
        }
        GL.glCallList(this.list);
        TextureImpl.bindNone();
    }

    public static void render(Graphics g, Diagram diagram) {
        int i = 0;
        while (i < diagram.getFigureCount()) {
            Figure figure = diagram.getFigure(i);
            if (figure.getData().isFilled()) {
                String fill;
                if (figure.getData().isColor("fill")) {
                    g.setColor(figure.getData().getAsColor("fill"));
                    g.fill(diagram.getFigure(i).getShape());
                    g.setAntiAlias(true);
                    g.draw(diagram.getFigure(i).getShape());
                    g.setAntiAlias(false);
                }
                if (diagram.getPatternDef(fill = figure.getData().getAsReference("fill")) != null) {
                    System.out.println("PATTERN");
                }
                if (diagram.getGradient(fill) != null) {
                    Gradient gradient = diagram.getGradient(fill);
                    Shape shape = diagram.getFigure(i).getShape();
                    TexCoordGenerator fg = null;
                    fg = gradient.isRadial() ? new RadialGradientFill(shape, diagram.getFigure(i).getTransform(), gradient) : new LinearGradientFill(shape, diagram.getFigure(i).getTransform(), gradient);
                    Color.white.bind();
                    ShapeRenderer.texture(shape, gradient.getImage(), fg);
                }
            }
            if (figure.getData().isStroked() && figure.getData().isColor("stroke")) {
                g.setColor(figure.getData().getAsColor("stroke"));
                g.setLineWidth(figure.getData().getAsFloat("stroke-width"));
                g.setAntiAlias(true);
                g.draw(diagram.getFigure(i).getShape());
                g.setAntiAlias(false);
                g.resetLineWidth();
            }
            ++i;
        }
    }
}

