/*
 * Decompiled with CFR 0.152.
 */
package z.svg.inkscape;

import org.w3c.dom.Element;
import z.geom.Ellipse;
import z.geom.Shape;
import z.geom.Transform;
import z.svg.Diagram;
import z.svg.Figure;
import z.svg.Loader;
import z.svg.NonGeometricData;
import z.svg.ParsingException;
import z.svg.inkscape.ElementProcessor;
import z.svg.inkscape.Util;

public class EllipseProcessor
implements ElementProcessor {
    @Override
    public void process(Loader loader, Element element, Diagram diagram, Transform t) throws ParsingException {
        Transform transform = Util.getTransform(element);
        transform = new Transform(t, transform);
        float x = Util.getFloatAttribute(element, "cx");
        float y = Util.getFloatAttribute(element, "cy");
        float rx = Util.getFloatAttribute(element, "rx");
        float ry = Util.getFloatAttribute(element, "ry");
        Ellipse ellipse = new Ellipse(x, y, rx, ry);
        Shape shape = ellipse.transform(transform);
        NonGeometricData data = Util.getNonGeometricData(element);
        data.addAttribute("cx", "" + x);
        data.addAttribute("cy", "" + y);
        data.addAttribute("rx", "" + rx);
        data.addAttribute("ry", "" + ry);
        diagram.addFigure(new Figure(1, shape, data, transform));
    }

    @Override
    public boolean handles(Element element) {
        if (element.getNodeName().equals("ellipse")) {
            return true;
        }
        return element.getNodeName().equals("path") && "arc".equals(element.getAttributeNS("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "type"));
    }
}

