/*
 * Decompiled with CFR 0.152.
 */
package z.svg.inkscape;

import org.w3c.dom.Element;
import z.geom.Rectangle;
import z.geom.Shape;
import z.geom.Transform;
import z.svg.Diagram;
import z.svg.Figure;
import z.svg.Loader;
import z.svg.NonGeometricData;
import z.svg.ParsingException;
import z.svg.inkscape.ElementProcessor;
import z.svg.inkscape.Util;

public class RectProcessor
implements ElementProcessor {
    @Override
    public void process(Loader loader, Element element, Diagram diagram, Transform t) throws ParsingException {
        Transform transform = Util.getTransform(element);
        transform = new Transform(t, transform);
        float width = Float.parseFloat(element.getAttribute("width"));
        float height = Float.parseFloat(element.getAttribute("height"));
        float x = Float.parseFloat(element.getAttribute("x"));
        float y = Float.parseFloat(element.getAttribute("y"));
        Rectangle rect = new Rectangle(x, y, width + 1.0f, height + 1.0f);
        Shape shape = rect.transform(transform);
        NonGeometricData data = Util.getNonGeometricData(element);
        data.addAttribute("width", "" + width);
        data.addAttribute("height", "" + height);
        data.addAttribute("x", "" + x);
        data.addAttribute("y", "" + y);
        diagram.addFigure(new Figure(3, shape, data, transform));
    }

    @Override
    public boolean handles(Element element) {
        return element.getNodeName().equals("rect");
    }
}

