/*
 * Decompiled with CFR 0.152.
 */
package net.canelex.guiscale;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import net.canelex.guiscale.CommandScale;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class GuiScaleMod
extends DummyModContainer {
    public static double guiScaleBonus = 0.0;
    private static File saveFile;
    private static Minecraft mc;
    private static boolean worldLoaded;

    public GuiScaleMod() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.name = "Gui Scale Mod";
        meta.modId = "guiscalemod";
        meta.version = "1.0";
        meta.description = "Allows you to change the screen's resolution, changing the size of vanilla GUI.";
        meta.url = "www.youtube.com/canelex";
        meta.authorList = Lists.newArrayList();
        meta.authorList.add("canelex");
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        mc = Minecraft.func_71410_x();
        saveFile = new File(Minecraft.func_71410_x().field_71412_D, "guiscale.data");
        GuiScaleMod.loadSettings();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandScale());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldEvent(WorldEvent.Load event) {
        worldLoaded = true;
    }

    @SubscribeEvent
    public void onWorldEvent(WorldEvent.Unload event) {
        worldLoaded = false;
    }

    public static double getGuiScale() {
        if (mc != null && GuiScaleMod.mc.field_71415_G) {
            worldLoaded = true;
        }
        if (mc != null && GuiScaleMod.mc.field_71441_e != null && worldLoaded) {
            return guiScaleBonus;
        }
        return 0.0;
    }

    public static void loadSettings() {
        if (!saveFile.exists()) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(saveFile));
            guiScaleBonus = Double.parseDouble(reader.readLine());
            reader.close();
        }
        catch (Exception ex) {
            System.out.println("Failed to load data: " + ex.getMessage());
        }
    }

    public static void saveSettings() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(saveFile));
            writer.write(String.valueOf(guiScaleBonus));
            writer.close();
        }
        catch (Exception ex) {
            System.out.println("Failed to save data: " + ex.getMessage());
        }
    }
}

