/*
 * Decompiled with CFR 0.152.
 */
package me.aycy.blockoverlay;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import me.aycy.blockoverlay.BlockOverlayCommand;
import me.aycy.blockoverlay.util.BlockOverlayMode;
import me.aycy.blockoverlay.visual.BlockOverlayRender;
import me.aycy.blockoverlay.visual.ColorGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="blockoverlay", name="BlockOverlay", version="1.2", acceptedMinecraftVersions="[1.8.9]")
public class BlockOverlay {
    private boolean openGui = false;
    private boolean openColorGui;
    private boolean chroma;
    private BlockOverlayMode mode = BlockOverlayMode.DEFAULT;
    private BlockOverlayRender render;
    private GuiScreen gui;

    public GuiScreen getGui() {
        return this.gui;
    }

    public void setGui(GuiScreen gui) {
        this.gui = gui;
    }

    public BlockOverlayMode getMode() {
        return this.mode;
    }

    public void setMode(BlockOverlayMode mode) {
        this.mode = mode;
    }

    public BlockOverlayRender getRender() {
        return this.render;
    }

    public boolean getOpenGui() {
        return this.openGui;
    }

    public void setOpenGui(boolean openGui) {
        this.openGui = openGui;
    }

    public void openColorGui() {
        this.openColorGui = true;
    }

    public boolean getChroma() {
        return this.chroma;
    }

    public void switchChroma() {
        this.chroma = !this.chroma;
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.render = new BlockOverlayRender(this);
        MinecraftForge.EVENT_BUS.register((Object)this.render);
        ClientCommandHandler.instance.func_71560_a((ICommand)new BlockOverlayCommand(this));
        this.loadConfig();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.openGui) {
            Minecraft.func_71410_x().func_147108_a(this.gui);
            this.openGui = false;
        }
        if (this.openColorGui) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ColorGui(this, this.getRender()));
            this.openColorGui = false;
        }
    }

    public void loadConfig() {
        try {
            String line;
            File parentFile = new File(Minecraft.func_71410_x().field_71412_D, "config");
            File file = new File(parentFile + File.separator + "blockOverlay.cfg");
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                switch (++i) {
                    case 2: {
                        this.mode = BlockOverlayMode.valueOf(line.toUpperCase());
                        break;
                    }
                    case 5: {
                        this.render.setColor(Float.parseFloat(line), this.render.getRGBAValues().get(1).floatValue(), this.render.getRGBAValues().get(2).floatValue(), this.render.getRGBAValues().get(3).floatValue());
                        break;
                    }
                    case 6: {
                        this.render.setColor(this.render.getRGBAValues().get(0).floatValue(), Float.parseFloat(line), this.render.getRGBAValues().get(2).floatValue(), this.render.getRGBAValues().get(3).floatValue());
                        break;
                    }
                    case 7: {
                        this.render.setColor(this.render.getRGBAValues().get(0).floatValue(), this.render.getRGBAValues().get(1).floatValue(), Float.parseFloat(line), this.render.getRGBAValues().get(3).floatValue());
                        break;
                    }
                    case 8: {
                        this.render.setColor(this.render.getRGBAValues().get(0).floatValue(), this.render.getRGBAValues().get(1).floatValue(), this.render.getRGBAValues().get(2).floatValue(), Float.parseFloat(line));
                        break;
                    }
                    case 11: {
                        this.chroma = Boolean.parseBoolean(line);
                        break;
                    }
                    case 12: {
                        this.render.setChromaSpeed(Integer.parseInt(line));
                        break;
                    }
                    case 15: {
                        this.render.setWidth(Float.parseFloat(line));
                    }
                }
            }
            reader.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            File parentFile = new File(Minecraft.func_71410_x().field_71412_D, "config");
            File file = new File(parentFile + File.separator + "blockOverlay.cfg");
            if (!file.exists()) {
                file.getParentFile().mkdir();
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("Mode: \n" + this.mode.getName() + "\n\nColor (RGBA): \n" + this.render.getColor() + "\n\nChroma: \n" + this.chroma + "\n" + this.render.getChromaSpeed() + "\n\nLine Width\n" + this.render.getWidth());
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

