/*
 * Decompiled with CFR 0.152.
 */
package me.aycy.blockoverlay.visual;

import java.io.IOException;
import me.aycy.blockoverlay.BlockOverlay;
import me.aycy.blockoverlay.util.BlockOverlayMode;
import me.aycy.blockoverlay.util.GuiSlideControl;
import me.aycy.blockoverlay.visual.BlockOverlayRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class BlockOverlayGui
extends GuiScreen {
    private BlockOverlay mod;
    private BlockOverlayRender render;
    private BlockOverlayMode prevMode;
    private BlockOverlayMode tempMode;
    private GuiButton buttonMode;
    private GuiButton buttonDone;
    private GuiButton buttonCancel;
    private GuiButton buttonColor;
    private GuiButton lastPressed;
    private GuiSlideControl lineWidth;

    public BlockOverlayGui(BlockOverlay mod, BlockOverlayRender render) {
        this.mod = mod;
        this.render = render;
        this.prevMode = mod.getMode();
        this.tempMode = mod.getMode();
    }

    public void func_73866_w_() {
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        this.buttonColor = new GuiButton(3, x - 100, this.getRowPos(3), "Color");
        this.field_146292_n.add(this.buttonColor);
        this.buttonMode = new GuiButton(0, x - 100, this.getRowPos(4), "Mode: " + this.tempMode.getName());
        this.field_146292_n.add(this.buttonMode);
        this.buttonDone = new GuiButton(1, x - 100, this.getRowPos(5), "Done");
        this.field_146292_n.add(this.buttonDone);
        this.buttonCancel = new GuiButton(2, x - 100, this.getRowPos(6), "Cancel");
        this.field_146292_n.add(this.buttonCancel);
        this.lineWidth = new GuiSlideControl(10, x - 100, this.getRowPos(2), 200, 20, "Line Width: ", 2.0f, 5.0f, this.render.getWidth(), false);
        this.field_146292_n.add(this.lineWidth);
    }

    public int getRowPos(int rowNumber) {
        return this.field_146295_m / 4 + (24 * rowNumber - 24) - 16;
    }

    public int getCenter() {
        return this.field_146294_l / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Block Overlay", x, y - 80, 0xFFFFFF);
        this.updateComponents();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146286_b(int mouseX, int mouseY, int which) {
        if (this.lastPressed != null && which == 0) {
            this.lastPressed.func_146118_a(mouseX, mouseY);
            try {
                this.actionPerformed_MouseUp(this.lastPressed);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.lastPressed = null;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                this.lastPressed = guibutton;
                this.func_146284_a(guibutton);
            }
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void actionPerformed_MouseUp(GuiButton button) throws IOException {
        if (button instanceof GuiSlideControl) {
            this.func_146284_a(button);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.tempMode = this.tempMode.getNextMode(this.tempMode);
                this.updateComponents();
                this.mod.setMode(this.tempMode);
                break;
            }
            case 1: {
                this.mod.setMode(this.tempMode);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)null);
                break;
            }
            case 3: {
                this.mod.openColorGui();
                break;
            }
            case 10: {
                this.render.setWidth(this.lineWidth.GetValueAsFloat());
            }
        }
    }

    public void func_146281_b() {
        this.mod.saveConfig();
    }

    public void updateComponents() {
        this.buttonMode.field_146126_j = "Mode: " + this.tempMode.getName();
        this.buttonColor.field_146125_m = this.tempMode == BlockOverlayMode.FULL || this.tempMode == BlockOverlayMode.OUTLINE;
        this.lineWidth.field_146125_m = this.tempMode == BlockOverlayMode.FULL || this.tempMode == BlockOverlayMode.OUTLINE;
    }
}

