/*
 * Decompiled with CFR 0.152.
 */
package me.aycy.blockoverlay.visual;

import java.awt.Color;
import java.util.ArrayList;
import me.aycy.blockoverlay.BlockOverlay;
import me.aycy.blockoverlay.util.BlockOverlayMode;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class BlockOverlayRender {
    private BlockOverlay mod;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private float lineWidth;
    private int chromaSpeed;

    public BlockOverlayRender(BlockOverlay mod) {
        this.mod = mod;
        this.chromaSpeed = 1;
        this.lineWidth = 2.0f;
    }

    public float getWidth() {
        return this.lineWidth;
    }

    public void setWidth(float newVal) {
        this.lineWidth = newVal;
    }

    public int getChromaSpeed() {
        return this.chromaSpeed;
    }

    public void setChromaSpeed(int chromaSpeed) {
        this.chromaSpeed = chromaSpeed;
    }

    public ArrayList<Float> getRGBAValues() {
        ArrayList<Float> result = new ArrayList<Float>();
        result.add(Float.valueOf(this.red));
        result.add(Float.valueOf(this.green));
        result.add(Float.valueOf(this.blue));
        result.add(Float.valueOf(this.alpha));
        return result;
    }

    public String getColor() {
        String color = "";
        color = color + Float.toString(this.red) + "\r\n";
        color = color + Float.toString(this.green) + "\r\n";
        color = color + Float.toString(this.blue) + "\r\n";
        color = color + Float.toString(this.alpha);
        return color;
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        MovingObjectPosition mops = event.target;
        if (event.target == null || mops.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || this.mod.getMode() == BlockOverlayMode.DEFAULT) {
            return;
        }
        event.setCanceled(true);
        if (this.mod.getMode() == BlockOverlayMode.NONE) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(event.target.func_178782_a()).func_177230_c() == null) {
            return;
        }
        Block block = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(event.target.func_178782_a()).func_177230_c();
        if (block == Blocks.field_150350_a || block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return;
        }
        double x = (double)event.target.func_178782_a().func_177958_n() - Minecraft.func_71410_x().func_175598_ae().field_78730_l;
        double y = (double)event.target.func_178782_a().func_177956_o() - Minecraft.func_71410_x().func_175598_ae().field_78731_m;
        double z = (double)event.target.func_178782_a().func_177952_p() - Minecraft.func_71410_x().func_175598_ae().field_78728_n;
        GlStateManager.func_179094_E();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)this.lineWidth);
        if (this.mod.getChroma()) {
            double millis = (float)(System.currentTimeMillis() % (10000L / (long)this.chromaSpeed)) / (10000.0f / (float)this.chromaSpeed);
            Color c = Color.getHSBColor((float)millis, 0.8f, 0.8f);
            float r = (float)c.getRed() / 255.0f;
            float g = (float)c.getGreen() / 255.0f;
            float b = (float)c.getBlue() / 255.0f;
            this.red = r;
            this.blue = b;
            this.green = g;
            float f = this.alpha = this.mod.getMode() == BlockOverlayMode.FULL ? 0.12f : 1.0f;
        }
        if (this.mod.getMode() == BlockOverlayMode.OUTLINE) {
            GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        } else {
            GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)1.0f);
        }
        AxisAlignedBB box = new AxisAlignedBB(x - 0.001, y - 0.001, z - 0.001, x + 1.001, y + 1.001, z + 1.001);
        RenderGlobal.func_181561_a((AxisAlignedBB)box);
        if (this.mod.getMode() == BlockOverlayMode.FULL) {
            this.drawFilledBoundingBox(box, this.red, this.green, this.blue, this.alpha);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private void drawFilledBoundingBox(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        worldRenderer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

