/*
 * Decompiled with CFR 0.152.
 */
package me.aycy.blockoverlay.visual;

import java.io.IOException;
import java.util.ArrayList;
import me.aycy.blockoverlay.BlockOverlay;
import me.aycy.blockoverlay.util.GuiSlideControl;
import me.aycy.blockoverlay.visual.BlockOverlayRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class ColorGui
extends GuiScreen {
    private BlockOverlay mod;
    private BlockOverlayRender render;
    private GuiSlideControl red;
    private GuiSlideControl green;
    private GuiSlideControl blue;
    private GuiSlideControl alpha;
    private GuiSlideControl chromaSpeed;
    private GuiButton lastPressed;
    private GuiButton goBack;
    private GuiButton chromaToggle;

    public ColorGui(BlockOverlay mod, BlockOverlayRender render) {
        this.mod = mod;
        this.render = render;
    }

    public void func_73866_w_() {
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        ArrayList<Float> currentVals = this.render.getRGBAValues();
        this.red = new GuiSlideControl(60, this.getCenter() - 100, this.getRowPos(3), 200, 20, "Red: ", 0.0f, 1.0f, currentVals.get(0).floatValue(), false);
        this.green = new GuiSlideControl(40, this.getCenter() - 100, this.getRowPos(4), 200, 20, "Green: ", 0.0f, 1.0f, currentVals.get(1).floatValue(), false);
        this.blue = new GuiSlideControl(20, this.getCenter() - 100, this.getRowPos(5), 200, 20, "Blue: ", 0.0f, 1.0f, currentVals.get(2).floatValue(), false);
        this.alpha = new GuiSlideControl(0, this.getCenter() - 100, this.getRowPos(6), 200, 20, "Alpha: ", 0.0f, 1.0f, currentVals.get(3).floatValue(), false);
        this.chromaSpeed = new GuiSlideControl(7, this.getCenter() - 100, this.getRowPos(3), 200, 20, "Chroma Speed: ", 1.0f, 10.0f, this.render.getChromaSpeed(), true);
        this.goBack = new GuiButton(10, this.getCenter() - 100, this.getRowPos(7), "Go Back");
        this.field_146292_n.add(this.goBack);
        this.chromaToggle = new GuiButton(5, this.getCenter() - 100, this.getRowPos(2), "Chroma: " + (this.mod.getChroma() ? "Enabled" : "Disabled"));
        this.field_146292_n.add(this.chromaToggle);
        this.field_146292_n.add(this.red);
        this.field_146292_n.add(this.green);
        this.field_146292_n.add(this.blue);
        this.field_146292_n.add(this.alpha);
        this.field_146292_n.add(this.chromaSpeed);
    }

    public int getRowPos(int rowNumber) {
        return this.field_146295_m / 4 + (24 * rowNumber - 24) - 16;
    }

    public int getCenter() {
        return this.field_146294_l / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, "Block Overlay Color", x, y - 80, 0xFFFFFF);
        this.chromaSpeed.field_146125_m = this.mod.getChroma();
        this.red.field_146125_m = !this.mod.getChroma();
        this.green.field_146125_m = !this.mod.getChroma();
        this.blue.field_146125_m = !this.mod.getChroma();
        this.alpha.field_146125_m = !this.mod.getChroma();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146286_b(int mouseX, int mouseY, int which) {
        if (this.lastPressed != null && which == 0) {
            this.lastPressed.func_146118_a(mouseX, mouseY);
            try {
                this.actionPerformed_MouseUp(this.lastPressed);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.lastPressed = null;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                this.lastPressed = guibutton;
                this.func_146284_a(guibutton);
            }
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void actionPerformed_MouseUp(GuiButton button) throws IOException {
        if (button instanceof GuiSlideControl) {
            this.func_146284_a(button);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 60: {
                this.render.setColor(this.red.GetValueAsFloat(), this.green.GetValueAsFloat(), this.blue.GetValueAsFloat(), this.alpha.GetValueAsFloat());
                break;
            }
            case 40: {
                this.render.setColor(this.red.GetValueAsFloat(), this.green.GetValueAsFloat(), this.blue.GetValueAsFloat(), this.alpha.GetValueAsFloat());
                break;
            }
            case 20: {
                this.render.setColor(this.red.GetValueAsFloat(), this.green.GetValueAsFloat(), this.blue.GetValueAsFloat(), this.alpha.GetValueAsFloat());
                break;
            }
            case 0: {
                this.render.setColor(this.red.GetValueAsFloat(), this.green.GetValueAsFloat(), this.blue.GetValueAsFloat(), this.alpha.GetValueAsFloat());
                break;
            }
            case 10: {
                this.mod.setOpenGui(true);
                break;
            }
            case 7: {
                this.render.setChromaSpeed(this.chromaSpeed.GetValueAsInt());
                break;
            }
            case 5: {
                this.mod.switchChroma();
                button.field_146126_j = "Chroma: " + (this.mod.getChroma() ? "Enabled" : "Disabled");
                if (this.mod.getChroma()) {
                    this.red.field_146125_m = false;
                    this.green.field_146125_m = false;
                    this.blue.field_146125_m = false;
                    this.alpha.field_146125_m = false;
                    break;
                }
                this.red.field_146125_m = true;
                this.green.field_146125_m = true;
                this.blue.field_146125_m = true;
                this.alpha.field_146125_m = true;
            }
        }
    }

    public void func_146281_b() {
        this.render.setColor(this.red.GetValueAsFloat(), this.green.GetValueAsFloat(), this.blue.GetValueAsFloat(), this.alpha.GetValueAsFloat());
        this.mod.saveConfig();
    }
}

