/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class InGameConfigScreen
extends GuiScreen {
    private final ResourceLocation INV_BG = new ResourceLocation("inventoryhud", "textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = new ResourceLocation("inventoryhud", "textures/gui/conf_bg.png");
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private GuiButton backButton;
    private final int menu;
    private final boolean inGame;

    public InGameConfigScreen(int menu, boolean inGame) {
        this.menu = menu;
        this.inGame = inGame;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.backButton = new GuiButton(0, this.field_146294_l - 60, 10, 50, 20, "Back");
        this.field_146292_n.add(this.backButton);
        float invScale = InvConfig.isInvMini() ? 0.75f : 1.0f;
        int invWidth = InvConfig.isInvVertical() ? 52 : 160;
        int invHeight = InvConfig.isInvVertical() ? 160 : 52;
        int x = this.getPosX((int)((float)invWidth * invScale), InvConfig.getxInvPos(), InvConfig.getInvHalign());
        int y = this.getPosY((int)((float)invHeight * invScale), InvConfig.getyInvPos(), InvConfig.getInvValign());
        this.ICW = new ConfigWidget(2, x, y, invWidth, invHeight, invScale, Translation.INVGUI.func_150260_c(), InventoryHUD.isActive);
        this.field_146292_n.add(this.ICW);
        if (!InvConfig.isInvVertical()) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(new ConfigWidget.ConfigWidgetListener(){

            @Override
            public void onShowChanged(ConfigWidget w) {
                InGameConfigScreen.this.onInvChanged();
            }
        });
        this.ICW.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

            @Override
            public void onPosChanged(ConfigWidget w) {
                InGameConfigScreen.this.onInvPosChanged();
            }
        });
        float potScale = InvConfig.isPotMini() ? 0.75f : 1.0f;
        x = this.getPosX((int)(60.0f * potScale), InvConfig.getxPotPos(), InvConfig.getPotHalign());
        y = this.getPosY((int)(24.0f * potScale), InvConfig.getyPotPos(), InvConfig.getPotValign());
        this.PCW = new ConfigWidget(3, x, y, 60, 24, potScale, Translation.POTGUI.func_150260_c(), InvConfig.isPotHud());
        this.field_146292_n.add(this.PCW);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(new ConfigWidget.ConfigWidgetListener(){

            @Override
            public void onShowChanged(ConfigWidget w) {
                InGameConfigScreen.this.onPotionChanged();
            }
        });
        this.PCW.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

            @Override
            public void onPosChanged(ConfigWidget w) {
                InGameConfigScreen.this.onPotionPosChanged();
            }
        });
        if (InvConfig.getMoveAll()) {
            x = this.getPosX(90, InvConfig.getxArmPos(), InvConfig.getArmHalign());
            y = this.getPosY(70, InvConfig.getyArmPos(), InvConfig.getArmValign());
            this.ACW = new ConfigWidget(3, x, y, 90, 70, 1.0f, Translation.ARMGUI.func_150260_c(), InventoryHUD.armorHUD);
            this.field_146292_n.add(this.ACW);
            this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
            this.ACW.addListener(new ConfigWidget.ConfigWidgetListener(){

                @Override
                public void onShowChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onArmorChanged();
                }
            });
            this.ACW.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onArmorPosChanged();
                }
            });
        } else {
            int xSize = 16;
            int ySize = 16;
            int textPos = 80;
            x = this.getPosX(xSize, InvConfig.getHelmX(), InvConfig.getHelmHal());
            y = this.getPosY(ySize, InvConfig.getHelmY(), InvConfig.getHelmVal());
            ConfigWidget tmp = new ConfigWidget(3, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowArmor(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_helmet.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 0);
                }
            });
            x = this.getPosX(xSize, InvConfig.getChestX(), InvConfig.getChestHal());
            y = this.getPosY(ySize, InvConfig.getChestY(), InvConfig.getChestVal());
            tmp = new ConfigWidget(4, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowArmor(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_chestplate.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 1);
                }
            });
            x = this.getPosX(xSize, InvConfig.getLegX(), InvConfig.getLegHal());
            y = this.getPosY(ySize, InvConfig.getLegY(), InvConfig.getLegVal());
            tmp = new ConfigWidget(5, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowArmor(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_leggings.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 2);
                }
            });
            x = this.getPosX(xSize, InvConfig.getBootsX(), InvConfig.getBootsHal());
            y = this.getPosY(ySize, InvConfig.getBootsY(), InvConfig.getBootsVal());
            tmp = new ConfigWidget(6, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowArmor(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_boots.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 3);
                }
            });
            x = this.getPosX(xSize, InvConfig.getMainX(), InvConfig.getMainHal());
            y = this.getPosY(ySize, InvConfig.getMainY(), InvConfig.getMainVal());
            tmp = new ConfigWidget(7, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowMain(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_main_hand_slot.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 4);
                }
            });
            x = this.getPosX(xSize, InvConfig.getArrX(), InvConfig.getArrHal());
            y = this.getPosY(ySize, InvConfig.getArrY(), InvConfig.getArrVal());
            tmp = new ConfigWidget(9, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowArrows(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_arrows.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 6);
                }
            });
            x = this.getPosX(xSize, InvConfig.getInvX(), InvConfig.getInvHal());
            y = this.getPosY(ySize, InvConfig.getInvY(), InvConfig.getInvVal());
            tmp = new ConfigWidget(10, x, y, xSize, ySize, 1.0f, "", InvConfig.isShowInv(), false);
            this.field_146292_n.add(tmp);
            tmp.initTextureValues(textPos, 124.0f, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/items/empty_inventory.png"));
            tmp.addPosListener(new ConfigWidget.ConfigWidgetPosListener(){

                @Override
                public void onPosChanged(ConfigWidget w) {
                    InGameConfigScreen.this.onItemPosChanged(w, 5);
                }
            });
        }
    }

    private int getPosX(int width, int posX, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = posX;
                break;
            }
            case RIGHT: {
                result = this.field_146294_l - posX;
                break;
            }
            case MIDDLE: {
                result = this.field_146294_l / 2 - width / 2 - posX;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.field_146294_l - width) {
            result = this.field_146294_l - width;
        }
        return result;
    }

    private int getPosY(int height, int posY, WidgetAligns.VAlign hal) {
        int result = 0;
        switch (hal) {
            case TOP: {
                result = posY;
                break;
            }
            case BOTTOM: {
                result = this.field_146295_m - posY;
                break;
            }
            case CENTER: {
                result = this.field_146295_m / 2 - height / 2 - posY;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.field_146295_m - height) {
            result = this.field_146295_m - height;
        }
        return result;
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.backButton) {
            this.saveConfig();
            switch (this.menu) {
                case -1: {
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 0: {
                    this.field_146297_k.func_147108_a((GuiScreen)new InventoryConfigScreen(this.inGame));
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)new ArmorConfigScreen(this.inGame));
                    break;
                }
                case 2: {
                    this.field_146297_k.func_147108_a((GuiScreen)new PotionConfigScreen(this.inGame));
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.CONF_BG);
        InGameConfigScreen.func_146110_a((int)0, (int)(this.field_146295_m / 3 - 1), (float)this.field_146294_l, (float)3.0f, (int)this.field_146294_l, (int)3, (float)3.0f, (float)3.0f);
        InGameConfigScreen.func_146110_a((int)0, (int)(this.field_146295_m / 3 * 2 - 1), (float)this.field_146294_l, (float)3.0f, (int)this.field_146294_l, (int)3, (float)3.0f, (float)3.0f);
        InGameConfigScreen.func_146110_a((int)(this.field_146294_l / 3 - 1), (int)0, (float)3.0f, (float)this.field_146295_m, (int)3, (int)this.field_146295_m, (float)3.0f, (float)3.0f);
        InGameConfigScreen.func_146110_a((int)(this.field_146294_l / 3 * 2 - 1), (int)0, (float)3.0f, (float)this.field_146295_m, (int)3, (int)this.field_146295_m, (float)3.0f, (float)3.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    public boolean func_73868_f() {
        return true;
    }

    private void saveConfig() {
        InvConfig.setxInvPos(InventoryGui.invX);
        InvConfig.setyInvPos(InventoryGui.invY);
        InvConfig.setInvHalign(InventoryGui.InvAligns.HorAlign);
        InvConfig.setInvValign(InventoryGui.InvAligns.VertAlign);
        InvConfig.setxPotPos(InventoryGui.potX);
        InvConfig.setyPotPos(InventoryGui.potY);
        InvConfig.setPotHalign(InventoryGui.PotAligns.HorAlign);
        InvConfig.setPotValign(InventoryGui.PotAligns.VertAlign);
        InvConfig.setxArmPos(InventoryGui.armX);
        InvConfig.setyArmPos(InventoryGui.armY);
        InvConfig.setArmHalign(InventoryGui.ArmAligns.HorAlign);
        InvConfig.setArmValign(InventoryGui.ArmAligns.VertAlign);
        InvConfig.setHelmHal(InventoryGui.items[0].aligns.HorAlign);
        InvConfig.setHelmVal(InventoryGui.items[0].aligns.VertAlign);
        InvConfig.setHelmX(InventoryGui.items[0].x);
        InvConfig.setHelmY(InventoryGui.items[0].y);
        InvConfig.setChestHal(InventoryGui.items[1].aligns.HorAlign);
        InvConfig.setChestVal(InventoryGui.items[1].aligns.VertAlign);
        InvConfig.setChestX(InventoryGui.items[1].x);
        InvConfig.setChestY(InventoryGui.items[1].y);
        InvConfig.setLegHal(InventoryGui.items[2].aligns.HorAlign);
        InvConfig.setLegVal(InventoryGui.items[2].aligns.VertAlign);
        InvConfig.setLegX(InventoryGui.items[2].x);
        InvConfig.setLegY(InventoryGui.items[2].y);
        InvConfig.setBootsHal(InventoryGui.items[3].aligns.HorAlign);
        InvConfig.setBootsVal(InventoryGui.items[3].aligns.VertAlign);
        InvConfig.setBootsX(InventoryGui.items[3].x);
        InvConfig.setBootsY(InventoryGui.items[3].y);
        InvConfig.setMainHal(InventoryGui.items[4].aligns.HorAlign);
        InvConfig.setMainVal(InventoryGui.items[4].aligns.VertAlign);
        InvConfig.setMainX(InventoryGui.items[4].x);
        InvConfig.setMainY(InventoryGui.items[4].y);
        InvConfig.setArrHal(InventoryGui.items[6].aligns.HorAlign);
        InvConfig.setArrVal(InventoryGui.items[6].aligns.VertAlign);
        InvConfig.setArrX(InventoryGui.items[6].x);
        InvConfig.setArrY(InventoryGui.items[6].y);
        InvConfig.setInvHal(InventoryGui.items[5].aligns.HorAlign);
        InvConfig.setInvVal(InventoryGui.items[5].aligns.VertAlign);
        InvConfig.setInvX(InventoryGui.items[5].x);
        InvConfig.setInvY(InventoryGui.items[5].y);
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InvConfig.setInvHud(this.ICW.getShow());
    }

    private void onInvPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.invX = this.ICW.field_146128_h;
        } else if (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.invX = mc.field_71462_r.field_146294_l - this.ICW.field_146128_h;
        } else {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.invX = this.ICW.field_146128_h + this.ICW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10 ? mc.field_71462_r.field_146294_l / 2 - this.ICW.field_146120_f / 2 - this.ICW.field_146128_h : (this.ICW.field_146128_h + this.ICW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10 ? mc.field_71462_r.field_146294_l / 2 - this.ICW.field_146120_f / 2 - this.ICW.field_146128_h : 0);
        }
        if (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 3) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.invY = this.ICW.field_146129_i;
        } else if (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 3 * 2) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.invY = mc.field_71462_r.field_146295_m - this.ICW.field_146129_i;
        } else {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.invY = this.ICW.field_146129_i + this.ICW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10 ? mc.field_71462_r.field_146295_m / 2 - this.ICW.field_146121_g / 2 - this.ICW.field_146129_i : (this.ICW.field_146129_i + this.ICW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10 ? mc.field_71462_r.field_146295_m / 2 - this.ICW.field_146121_g / 2 - this.ICW.field_146129_i : 0);
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InvConfig.setPotHud(this.PCW.getShow());
    }

    private void onPotionPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryGui.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.potX = this.PCW.field_146128_h;
            InventoryGui.PotPosChanged();
        } else if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryGui.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.potX = mc.field_71462_r.field_146294_l - this.PCW.field_146128_h;
            InventoryGui.PotPosChanged();
        } else {
            InventoryGui.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10) {
                InventoryGui.potX = mc.field_71462_r.field_146294_l / 2 - this.PCW.field_146120_f / 2 - this.PCW.field_146128_h;
                InventoryGui.PotPosChanged();
            } else if (this.PCW.field_146128_h + this.PCW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10) {
                InventoryGui.potX = mc.field_71462_r.field_146294_l / 2 - this.PCW.field_146120_f / 2 - this.PCW.field_146128_h;
                InventoryGui.PotPosChanged();
            } else {
                InventoryGui.potX = 0;
                InventoryGui.PotPosChanged();
            }
        }
        if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 3) {
            InventoryGui.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.potY = this.PCW.field_146129_i;
            InventoryGui.PotPosYChanged(true);
        } else if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 3 * 2) {
            InventoryGui.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.potY = mc.field_71462_r.field_146295_m - this.PCW.field_146129_i;
            InventoryGui.PotPosYChanged(false);
        } else {
            InventoryGui.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
                InventoryGui.potY = mc.field_71462_r.field_146295_m / 2 - this.PCW.field_146121_g / 2 - this.PCW.field_146129_i;
                InventoryGui.PotPosYChanged(true);
            } else if (this.PCW.field_146129_i + this.PCW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
                InventoryGui.potY = mc.field_71462_r.field_146295_m / 2 - this.PCW.field_146121_g / 2 - this.PCW.field_146129_i;
                InventoryGui.PotPosYChanged(false);
            } else {
                InventoryGui.potY = 0;
                InventoryGui.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InvConfig.setArmHud(this.ACW.getShow());
    }

    private void onArmorPosChanged() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.ACW.field_146128_h + this.ACW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryGui.ArmAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.armX = this.ACW.field_146128_h;
        } else if (this.ACW.field_146128_h + this.ACW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryGui.ArmAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.armX = mc.field_71462_r.field_146294_l - this.ACW.field_146128_h;
        } else {
            InventoryGui.ArmAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.armX = this.ACW.field_146128_h + this.ACW.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10 ? mc.field_71462_r.field_146294_l / 2 - 45 - this.ACW.field_146128_h : (this.ACW.field_146128_h + this.ACW.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10 ? mc.field_71462_r.field_146294_l / 2 - 45 - this.ACW.field_146128_h : 0);
        }
        if (this.ACW.field_146129_i + this.ACW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
            InventoryGui.ArmAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.armY = this.ACW.field_146129_i;
        } else if (this.ACW.field_146129_i + this.ACW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
            InventoryGui.ArmAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.armY = mc.field_71462_r.field_146295_m - this.ACW.field_146129_i;
        } else {
            InventoryGui.ArmAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.armY = this.ACW.field_146129_i + this.ACW.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10 ? mc.field_71462_r.field_146295_m / 2 - 35 - this.ACW.field_146129_i : (this.ACW.field_146129_i + this.ACW.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10 ? mc.field_71462_r.field_146295_m / 2 - 35 - this.ACW.field_146129_i : 0);
        }
    }

    private void onItemPosChanged(ConfigWidget w, int i) {
        Minecraft mc = Minecraft.func_71410_x();
        if (w.field_146128_h + w.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 3) {
            InventoryGui.items[i].aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.items[i].x = w.field_146128_h;
        } else if (w.field_146128_h + w.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 3 * 2) {
            InventoryGui.items[i].aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.items[i].x = mc.field_71462_r.field_146294_l - w.field_146128_h;
        } else {
            InventoryGui.items[i].aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.items[i].x = w.field_146128_h + w.field_146120_f / 2 <= mc.field_71462_r.field_146294_l / 2 - 10 ? mc.field_71462_r.field_146294_l / 2 - w.field_146120_f / 2 - w.field_146128_h : (w.field_146128_h + w.field_146120_f / 2 >= mc.field_71462_r.field_146294_l / 2 + 10 ? mc.field_71462_r.field_146294_l / 2 - w.field_146120_f / 2 - w.field_146128_h : 0);
        }
        if (w.field_146129_i + w.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10) {
            InventoryGui.items[i].aligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.items[i].y = w.field_146129_i;
        } else if (w.field_146129_i + w.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10) {
            InventoryGui.items[i].aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.items[i].y = mc.field_71462_r.field_146295_m - w.field_146129_i;
        } else {
            InventoryGui.items[i].aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.items[i].y = w.field_146129_i + w.field_146121_g / 2 <= mc.field_71462_r.field_146295_m / 2 - 10 ? mc.field_71462_r.field_146295_m / 2 - w.field_146121_g / 2 - w.field_146129_i : (w.field_146129_i + w.field_146121_g / 2 >= mc.field_71462_r.field_146295_m / 2 + 10 ? mc.field_71462_r.field_146295_m / 2 - w.field_146121_g / 2 - w.field_146129_i : 0);
        }
    }

    protected void func_73869_a(char p_keyTyped_1_, int p_keyTyped_2_) {
        if (p_keyTyped_2_ == 1) {
            this.saveConfig();
            switch (this.menu) {
                case -1: {
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 0: {
                    this.field_146297_k.func_147108_a((GuiScreen)new InventoryConfigScreen(this.inGame));
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)new ArmorConfigScreen(this.inGame));
                    break;
                }
                case 2: {
                    this.field_146297_k.func_147108_a((GuiScreen)new PotionConfigScreen(this.inGame));
                }
            }
        }
    }
}

