/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config;

import dlovin.inventoryhud.utils.WidgetAligns;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class InvConfig {
    private static final int VERSION = 3;
    private static final String INVENTORY = "Inventory";
    private static final String POTIONS = "Potions";
    private static final String ARMOR = "Armor";
    private static final String POSITION = "Position";
    private static File configFile;
    private static Configuration config;
    private static boolean invHud;
    private static int invAlpha;
    private static boolean invVertical;
    private static boolean invMini;
    private static boolean potHud;
    private static int potAlpha;
    private static boolean potMini;
    private static int potGap;
    private static boolean armHud;
    private static int armAbove;
    private static ArmorView armView;
    private static boolean armBars;
    private static boolean moveAll;
    private static boolean showEmpty;
    private static boolean showArmor;
    private static boolean showMain;
    private static boolean showArrows;
    private static boolean showInv;
    private static int xInvPos;
    private static int yInvPos;
    private static int xPotPos;
    private static int yPotPos;
    private static int xArmPos;
    private static int yArmPos;
    private static WidgetAligns.HAlign armHalign;
    private static WidgetAligns.VAlign armValign;
    private static WidgetAligns.HAlign potHalign;
    private static WidgetAligns.VAlign potValign;
    private static WidgetAligns.HAlign invHalign;
    private static WidgetAligns.VAlign invValign;
    private static int helmX;
    private static int helmY;
    private static int chestX;
    private static int chestY;
    private static int legX;
    private static int legY;
    private static int bootsX;
    private static int bootsY;
    private static int mainX;
    private static int mainY;
    private static int arrX;
    private static int arrY;
    private static int invX;
    private static int invY;
    private static WidgetAligns.HAlign helmHal;
    private static WidgetAligns.HAlign chestHal;
    private static WidgetAligns.HAlign legHal;
    private static WidgetAligns.HAlign bootsHal;
    private static WidgetAligns.HAlign mainHal;
    private static WidgetAligns.HAlign arrHal;
    private static WidgetAligns.HAlign invHal;
    private static WidgetAligns.VAlign helmVal;
    private static WidgetAligns.VAlign chestVal;
    private static WidgetAligns.VAlign legVal;
    private static WidgetAligns.VAlign bootsVal;
    private static WidgetAligns.VAlign mainVal;
    private static WidgetAligns.VAlign arrVal;
    private static WidgetAligns.VAlign invVal;
    private static final String[] validArmViews;
    private static final String[] validHalign;
    private static final String[] validValign;

    public InvConfig(String path) {
        configFile = new File(path);
        config = new Configuration(configFile, String.valueOf(3));
        this.load();
    }

    private ArmorView armViewFromString(String st) {
        if (st.contains("PERCENTAGE")) {
            return ArmorView.PERCENTAGE;
        }
        if (st.contains("DAMAGELEFT")) {
            return ArmorView.DAMAGELEFT;
        }
        if (st.contains("DAMAGE")) {
            return ArmorView.DAMAGE;
        }
        if (st.contains("OFF")) {
            return ArmorView.OFF;
        }
        return ArmorView.PERCENTAGE;
    }

    public void load() {
        config.setCategoryComment(INVENTORY, "Settings for Inventory HUD");
        config.setCategoryComment(POTIONS, "Settings for Potion HUD");
        config.setCategoryComment(ARMOR, "Settings for Armor HUD");
        config.setCategoryComment(POSITION, "POSITION SETTINGS, DON'T TOUCH!");
        invHud = config.getBoolean("inv_hud", INVENTORY, true, "Toggle on/off Inventory HUD");
        invVertical = config.getBoolean("inv_vertical", INVENTORY, false, "Inventory HUD vertical mode");
        invMini = config.getBoolean("inv_mini", INVENTORY, false, "Inventory HUD mini mode");
        invAlpha = config.getInt("inv_alpha", INVENTORY, 0, 0, 100, "Inventory HUD background transparency");
        potHud = config.getBoolean("pot_hud", POTIONS, false, "Toggle on/off Potion HUD");
        potAlpha = config.getInt("pot_alpha", POTIONS, 100, 0, 100, "Potion HUD background transparency (from 0 to 100)");
        potMini = config.getBoolean("pot_mini", POTIONS, false, "Potion HUD mini mode");
        potGap = config.getInt("pot_gap", POTIONS, 0, -5, 5, "Gap between effects in pixels(from -5 to 5)");
        armHud = config.getBoolean("arm_hud", ARMOR, false, "Toggle on/off Armor HUD");
        armAbove = config.getInt("arm_above", ARMOR, 100, 0, 100, "Hide armor if its durability higher than this value in percentage");
        armView = this.armViewFromString(config.getString("arm_view", ARMOR, ArmorView.PERCENTAGE.name(), "Armor durability in percentage, current damage or damage left\nValid values: [" + validArmViews[0] + ", " + validArmViews[1] + ", " + validArmViews[2] + "]", validArmViews));
        armBars = config.getBoolean("arm_bars", ARMOR, false, "Show or hide durability bar overlay");
        moveAll = config.getBoolean("move_all", ARMOR, true, "Move all items at once or separate");
        showEmpty = config.getBoolean("show_empty", ARMOR, true, "Show icons of empty slots");
        showArmor = config.getBoolean("show_armor", ARMOR, true, "Show armor items");
        showMain = config.getBoolean("show_main", ARMOR, true, "Show main hand item");
        showArrows = config.getBoolean("show_arrows", ARMOR, true, "Show arrows count");
        showInv = config.getBoolean("show_inv", ARMOR, true, "Show inventory space counter");
        invHalign = WidgetAligns.halFromString(config.getString("inv_halign", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Inventory HUD horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        invValign = WidgetAligns.valFromString(config.getString("inv_valign", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Inventory HUD vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        xInvPos = config.getInt("x_inv_pos", POSITION, 0, -9999, 9999, "Inventory HUD X position according alignments");
        yInvPos = config.getInt("y_inv_pos", POSITION, 150, -9999, 9999, "Inventory HUD Y position according alignments");
        potHalign = WidgetAligns.halFromString(config.getString("pot_halign", POSITION, WidgetAligns.HAlign.LEFT.name(), "Potion HUD horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        potValign = WidgetAligns.valFromString(config.getString("pot_valign", POSITION, WidgetAligns.VAlign.TOP.name(), "Potion HUD vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        xPotPos = config.getInt("x_pot_pos", POSITION, 20, -9999, 9999, "Potion HUD X position according alignments");
        yPotPos = config.getInt("y_pot_pos", POSITION, 20, -9999, 9999, "Potion HUD Y position according alignments");
        armHalign = WidgetAligns.halFromString(config.getString("arm_halign", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Armor HUD horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        armValign = WidgetAligns.valFromString(config.getString("arm_valign", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Armor HUD vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        xArmPos = config.getInt("x_arm_pos", POSITION, 0, -9999, 9999, "Armor HUD X position according alignments");
        yArmPos = config.getInt("y_arm_pos", POSITION, 70, -9999, 9999, "Armor HUD Y position according alignments");
        helmX = config.getInt("helm_x", POSITION, 103, -9999, 9999, "Helm Position X");
        helmY = config.getInt("helm_y", POSITION, 54, -9999, 9999, "Helm Position Y");
        chestX = config.getInt("chest_x", POSITION, 103, -9999, 9999, "Chestplate Position X");
        chestY = config.getInt("chest_y", POSITION, 37, -9999, 9999, "Chestplate Position Y");
        legX = config.getInt("leg_x", POSITION, -103, -9999, 9999, "Leggings Position X");
        legY = config.getInt("leg_y", POSITION, 54, -9999, 9999, "Leggings Position Y");
        bootsX = config.getInt("boots_x", POSITION, -107, -9999, 9999, "Boots Position X");
        bootsY = config.getInt("boots_y", POSITION, 37, -9999, 9999, "Boots Position Y");
        mainX = config.getInt("main_x", POSITION, 103, -9999, 9999, "Main Hand Position X");
        mainY = config.getInt("main_y", POSITION, 71, -9999, 9999, "Main Hand Position Y");
        arrX = config.getInt("arrows_x", POSITION, 103, -9999, 9999, "Arrows Position X");
        arrY = config.getInt("arrows_y", POSITION, 20, -9999, 9999, "Arrows Position Y");
        invX = config.getInt("inv_icon_x", POSITION, -103, -9999, 9999, "Inventory Icon Position X");
        invY = config.getInt("inv_icon_y", POSITION, 20, -9999, 9999, "Inventory Icon Position Y");
        helmHal = WidgetAligns.halFromString(config.getString("helm_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Helmet horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        chestHal = WidgetAligns.halFromString(config.getString("chest_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Chestplate horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        legHal = WidgetAligns.halFromString(config.getString("leg_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Leggings horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        bootsHal = WidgetAligns.halFromString(config.getString("boots_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Boots horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        mainHal = WidgetAligns.halFromString(config.getString("main_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Main hand horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        arrHal = WidgetAligns.halFromString(config.getString("arrows_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Arrows horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        invHal = WidgetAligns.halFromString(config.getString("inv_icon_hal", POSITION, WidgetAligns.HAlign.MIDDLE.name(), "Inventory icon horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign));
        helmVal = WidgetAligns.valFromString(config.getString("helm_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Helmet vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        chestVal = WidgetAligns.valFromString(config.getString("chest_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Chestplate vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        legVal = WidgetAligns.valFromString(config.getString("leg_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Leggings vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        bootsVal = WidgetAligns.valFromString(config.getString("boots_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Boots vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        mainVal = WidgetAligns.valFromString(config.getString("main_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Main hand vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        arrVal = WidgetAligns.valFromString(config.getString("arrows_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Arrows vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        invVal = WidgetAligns.valFromString(config.getString("inv_icon_val", POSITION, WidgetAligns.VAlign.BOTTOM.name(), "Inventory icon vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign));
        config.save();
    }

    public static int getHelmX() {
        return helmX;
    }

    public static void setHelmX(int helmX) {
        InvConfig.helmX = helmX;
        config.get(POSITION, "helm_x", 103, "Helm Position X", -9999, 9999).set(helmX);
        config.save();
    }

    public static int getHelmY() {
        return helmY;
    }

    public static void setHelmY(int helmY) {
        InvConfig.helmY = helmY;
        config.get(POSITION, "helm_y", 54, "Helm Position Y", -9999, 9999).set(helmY);
        config.save();
    }

    public static int getChestX() {
        return chestX;
    }

    public static void setChestX(int chestX) {
        InvConfig.chestX = chestX;
        config.get(POSITION, "chest_x", 103, "Chestplate Position X", -9999, 9999).set(chestX);
        config.save();
    }

    public static int getChestY() {
        return chestY;
    }

    public static void setChestY(int chestY) {
        InvConfig.chestY = chestY;
        config.get(POSITION, "chest_y", 37, "Chestplate Position Y", -9999, 9999).set(chestY);
        config.save();
    }

    public static int getLegX() {
        return legX;
    }

    public static void setLegX(int legX) {
        InvConfig.legX = legX;
        config.get(POSITION, "leg_x", -103, "Leggings Position X", -9999, 9999).set(legX);
        config.save();
    }

    public static int getLegY() {
        return legY;
    }

    public static void setLegY(int legY) {
        InvConfig.legY = legY;
        config.get(POSITION, "leg_y", 54, "Leggings Position Y", -9999, 9999).set(legY);
        config.save();
    }

    public static int getBootsX() {
        return bootsX;
    }

    public static void setBootsX(int bootsX) {
        InvConfig.bootsX = bootsX;
        config.get(POSITION, "boots_x", -103, "Boots Position X", -9999, 9999).set(bootsX);
        config.save();
    }

    public static int getBootsY() {
        return bootsY;
    }

    public static void setBootsY(int bootsY) {
        InvConfig.bootsY = bootsY;
        config.get(POSITION, "boots_y", 37, "Boots Position Y", -9999, 9999).set(bootsY);
        config.save();
    }

    public static int getMainX() {
        return mainX;
    }

    public static void setMainX(int mainX) {
        InvConfig.mainX = mainX;
        config.get(POSITION, "main_x", 103, "Main Hand Position X", -9999, 9999).set(mainX);
        config.save();
    }

    public static int getMainY() {
        return mainY;
    }

    public static void setMainY(int mainY) {
        InvConfig.mainY = mainY;
        config.get(POSITION, "main_y", 71, "Main Hand Position Y", -9999, 9999).set(mainY);
        config.save();
    }

    public static int getArrX() {
        return arrX;
    }

    public static void setArrX(int arrX) {
        InvConfig.arrX = arrX;
        config.get(POSITION, "arrows_x", 103, "Arrows Position X", -9999, 9999).set(arrX);
        config.save();
    }

    public static int getArrY() {
        return arrY;
    }

    public static void setArrY(int arrY) {
        InvConfig.arrY = arrY;
        config.get(POSITION, "arrows_y", 20, "Arrows Position Y", -9999, 9999).set(arrY);
        config.save();
    }

    public static int getInvX() {
        return invX;
    }

    public static void setInvX(int invX) {
        InvConfig.invX = invX;
        config.get(POSITION, "inv_icon_x", -103, "Inventory Icon Position X", -9999, 9999).set(invX);
        config.save();
    }

    public static int getInvY() {
        return invY;
    }

    public static void setInvY(int invY) {
        InvConfig.invY = invY;
        config.get(POSITION, "inv_icon_y", 20, "Inventory Icon Position Y", -9999, 9999).set(invY);
        config.save();
    }

    public static WidgetAligns.HAlign getHelmHal() {
        return helmHal;
    }

    public static void setHelmHal(WidgetAligns.HAlign helmHal) {
        InvConfig.helmHal = helmHal;
        config.get(POSITION, "helm_hal", WidgetAligns.HAlign.MIDDLE.name(), "Helmet horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(helmHal.name());
        config.save();
    }

    public static WidgetAligns.HAlign getChestHal() {
        return chestHal;
    }

    public static void setChestHal(WidgetAligns.HAlign chestHal) {
        InvConfig.chestHal = chestHal;
        config.get(POSITION, "chest_hal", WidgetAligns.HAlign.MIDDLE.name(), "Chestplate horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(chestHal.name());
        config.save();
    }

    public static WidgetAligns.HAlign getLegHal() {
        return legHal;
    }

    public static void setLegHal(WidgetAligns.HAlign legHal) {
        InvConfig.legHal = legHal;
        config.get(POSITION, "leg_hal", WidgetAligns.HAlign.MIDDLE.name(), "Leggings horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(legHal.name());
        config.save();
    }

    public static WidgetAligns.HAlign getBootsHal() {
        return bootsHal;
    }

    public static void setBootsHal(WidgetAligns.HAlign bootsHal) {
        InvConfig.bootsHal = bootsHal;
        config.get(POSITION, "boots_hal", WidgetAligns.HAlign.MIDDLE.name(), "Boots horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(bootsHal.name());
        config.save();
    }

    public static WidgetAligns.HAlign getMainHal() {
        return mainHal;
    }

    public static void setMainHal(WidgetAligns.HAlign mainHal) {
        InvConfig.mainHal = mainHal;
        config.get(POSITION, "main_hal", WidgetAligns.HAlign.MIDDLE.name(), "Main hand horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(mainHal.name());
        config.save();
    }

    public static WidgetAligns.HAlign getArrHal() {
        return arrHal;
    }

    public static void setArrHal(WidgetAligns.HAlign arrHal) {
        InvConfig.arrHal = arrHal;
        config.get(POSITION, "arrows_hal", WidgetAligns.HAlign.MIDDLE.name(), "Arrows horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(arrHal.name());
        config.save();
    }

    public static WidgetAligns.HAlign getInvHal() {
        return invHal;
    }

    public static void setInvHal(WidgetAligns.HAlign invHal) {
        InvConfig.invHal = invHal;
        config.get(POSITION, "inv_icon_hal", WidgetAligns.HAlign.MIDDLE.name(), "Inventory icon horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(invHal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getHelmVal() {
        return helmVal;
    }

    public static void setHelmVal(WidgetAligns.VAlign helmVal) {
        InvConfig.helmVal = helmVal;
        config.get(POSITION, "helm_val", WidgetAligns.VAlign.BOTTOM.name(), "Helmet vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(helmVal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getChestVal() {
        return chestVal;
    }

    public static void setChestVal(WidgetAligns.VAlign chestVal) {
        InvConfig.chestVal = chestVal;
        config.get(POSITION, "chest_val", WidgetAligns.VAlign.BOTTOM.name(), "Chestplate vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(chestVal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getLegVal() {
        return legVal;
    }

    public static void setLegVal(WidgetAligns.VAlign legVal) {
        InvConfig.legVal = legVal;
        config.get(POSITION, "leg_val", WidgetAligns.VAlign.BOTTOM.name(), "Leggings vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(legVal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getBootsVal() {
        return bootsVal;
    }

    public static void setBootsVal(WidgetAligns.VAlign bootsVal) {
        InvConfig.bootsVal = bootsVal;
        config.get(POSITION, "boots_val", WidgetAligns.VAlign.BOTTOM.name(), "Boots vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(bootsVal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getMainVal() {
        return mainVal;
    }

    public static void setMainVal(WidgetAligns.VAlign mainVal) {
        InvConfig.mainVal = mainVal;
        config.get(POSITION, "main_val", WidgetAligns.VAlign.BOTTOM.name(), "Main hand vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(mainVal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getArrVal() {
        return arrVal;
    }

    public static void setArrVal(WidgetAligns.VAlign arrVal) {
        InvConfig.arrVal = arrVal;
        config.get(POSITION, "arrows_val", WidgetAligns.VAlign.BOTTOM.name(), "Arrows vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(arrVal.name());
        config.save();
    }

    public static WidgetAligns.VAlign getInvVal() {
        return invVal;
    }

    public static void setInvVal(WidgetAligns.VAlign invVal) {
        InvConfig.invVal = invVal;
        config.get(POSITION, "inv_icon_val", WidgetAligns.VAlign.BOTTOM.name(), "Inventory icon vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(invVal.name());
        config.save();
    }

    public static boolean isShowEmpty() {
        return showEmpty;
    }

    public static void setShowEmpty(boolean showEmpty) {
        InvConfig.showEmpty = showEmpty;
        config.get(ARMOR, "show_empty", true, "Show icons of empty slots").set(showEmpty);
        config.save();
    }

    public static boolean isShowArmor() {
        return showArmor;
    }

    public static void setShowArmor(boolean showArmor) {
        InvConfig.showArmor = showArmor;
        config.get(ARMOR, "show_armor", true, "Show armor items").set(showArmor);
        config.save();
    }

    public static boolean isShowMain() {
        return showMain;
    }

    public static void setShowMain(boolean showMain) {
        InvConfig.showMain = showMain;
        config.get(ARMOR, "show_main", true, "Show main hand item").set(showMain);
        config.save();
    }

    public static boolean isShowArrows() {
        return showArrows;
    }

    public static void setShowArrows(boolean showArrows) {
        InvConfig.showArrows = showArrows;
        config.get(ARMOR, "show_arrows", true, "Show arrows count").set(showArrows);
        config.save();
    }

    public static boolean isShowInv() {
        return showInv;
    }

    public static void setShowInv(boolean showInv) {
        InvConfig.showInv = showInv;
        config.get(ARMOR, "show_inv", true, "Show inventory space counter").set(showInv);
        config.save();
    }

    public static boolean getMoveAll() {
        return moveAll;
    }

    public static void setMoveAll(boolean moveAll) {
        InvConfig.moveAll = moveAll;
        config.get(ARMOR, "move_all", true, "Move all items at once or separate").set(moveAll);
        config.save();
    }

    public static int getInvAlpha() {
        return invAlpha;
    }

    public static void setInvAlpha(int invAlpha) {
        InvConfig.invAlpha = invAlpha;
        config.get(INVENTORY, "inv_alpha", 0, "Inventory HUD background transparency", 0, 100).set(invAlpha);
        config.save();
    }

    public static boolean isInvHud() {
        return invHud;
    }

    public static void setInvHud(boolean invHud) {
        InvConfig.invHud = invHud;
        config.get(INVENTORY, "inv_hud", true, "Toggle on/off Inventory HUD").set(invHud);
        config.save();
    }

    public static WidgetAligns.HAlign getInvHalign() {
        return invHalign;
    }

    public static void setInvHalign(WidgetAligns.HAlign invHalign) {
        InvConfig.invHalign = invHalign;
        config.get(POSITION, "inv_halign", WidgetAligns.HAlign.MIDDLE.name(), "Inventory HUD horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(invHalign.name());
        config.save();
    }

    public static WidgetAligns.VAlign getInvValign() {
        return invValign;
    }

    public static void setInvValign(WidgetAligns.VAlign invValign) {
        InvConfig.invValign = invValign;
        config.get(POSITION, "inv_valign", WidgetAligns.VAlign.BOTTOM.name(), "Inventory HUD vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(invValign.name());
        config.save();
    }

    public static int getxInvPos() {
        return xInvPos;
    }

    public static void setxInvPos(int xInvPos) {
        InvConfig.xInvPos = xInvPos;
        config.get(POSITION, "x_inv_pos", 0, "Inventory HUD X position according alignments", -9999, 9999).set(xInvPos);
        config.save();
    }

    public static int getyInvPos() {
        return yInvPos;
    }

    public static void setyInvPos(int yInvPos) {
        InvConfig.yInvPos = yInvPos;
        config.get(POSITION, "y_inv_pos", 150, "Inventory HUD Y position according alignments", -9999, 9999).set(yInvPos);
        config.save();
    }

    public static boolean isInvVertical() {
        return invVertical;
    }

    public static void setInvVertical(boolean invVertical) {
        InvConfig.invVertical = invVertical;
        config.get(INVENTORY, "inv_vertical", false, "Inventory HUD vertical mode").set(invVertical);
        config.save();
    }

    public static boolean isInvMini() {
        return invMini;
    }

    public static void setInvMini(boolean invMini) {
        InvConfig.invMini = invMini;
        config.get(INVENTORY, "inv_mini", false, "Inventory HUD mini mode").set(invMini);
        config.save();
    }

    public static boolean isPotHud() {
        return potHud;
    }

    public static void setPotHud(boolean potHud) {
        InvConfig.potHud = potHud;
        config.get(POTIONS, "pot_hud", false, "Toggle on/off Potion HUD").set(potHud);
        config.save();
    }

    public static WidgetAligns.HAlign getPotHalign() {
        return potHalign;
    }

    public static void setPotHalign(WidgetAligns.HAlign potHalign) {
        InvConfig.potHalign = potHalign;
        config.get(POSITION, "pot_halign", WidgetAligns.HAlign.LEFT.name(), "Potion HUD horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(potHalign.name());
        config.save();
    }

    public static WidgetAligns.VAlign getPotValign() {
        return potValign;
    }

    public static void setPotValign(WidgetAligns.VAlign potValign) {
        InvConfig.potValign = potValign;
        config.get(POSITION, "pot_valign", WidgetAligns.VAlign.TOP.name(), "Potion HUD vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(potValign.name());
        config.save();
    }

    public static int getxPotPos() {
        return xPotPos;
    }

    public static void setxPotPos(int xPotPos) {
        InvConfig.xPotPos = xPotPos;
        config.get(POSITION, "x_pot_pos", 20, "Potion HUD X position according alignments", -9999, 9999).set(xPotPos);
        config.save();
    }

    public static int getyPotPos() {
        return yPotPos;
    }

    public static void setyPotPos(int yPotPos) {
        InvConfig.yPotPos = yPotPos;
        config.get(POSITION, "y_pot_pos", 20, "Potion HUD Y position according alignments", -9999, 9999).set(yPotPos);
        config.save();
    }

    public static int getPotAlpha() {
        return potAlpha;
    }

    public static void setPotAlpha(int potAlpha) {
        InvConfig.potAlpha = potAlpha;
        config.get(POTIONS, "pot_alpha", 100, "Potion HUD background transparency (from 0 to 100)", 0, 100).set(potAlpha);
        config.save();
    }

    public static boolean isPotMini() {
        return potMini;
    }

    public static void setPotMini(boolean potMini) {
        InvConfig.potMini = potMini;
        config.get(POTIONS, "pot_mini", false, "Potion HUD mini mode").set(potMini);
        config.save();
    }

    public static int getPotGap() {
        return potGap;
    }

    public static void setPotGap(int potGap) {
        InvConfig.potGap = potGap;
        config.get(POTIONS, "pot_gap", 0, "Gap between effects in pixels(from -5 to 5)", -5, 5).set(potGap);
        config.save();
    }

    public static boolean isArmHud() {
        return armHud;
    }

    public static void setArmHud(boolean armHud) {
        InvConfig.armHud = armHud;
        config.get(ARMOR, "arm_hud", false, "Toggle on/off Armor HUD").set(armHud);
        config.save();
    }

    public static WidgetAligns.HAlign getArmHalign() {
        return armHalign;
    }

    public static void setArmHalign(WidgetAligns.HAlign armHalign) {
        InvConfig.armHalign = armHalign;
        config.get(POSITION, "arm_halign", WidgetAligns.HAlign.MIDDLE.name(), "Armor HUD horizontal alignment\nValid values: [" + validHalign[0] + ", " + validHalign[1] + ", " + validHalign[2] + "]", validHalign).set(armHalign.name());
        config.save();
    }

    public static WidgetAligns.VAlign getArmValign() {
        return armValign;
    }

    public static void setArmValign(WidgetAligns.VAlign armValign) {
        InvConfig.armValign = armValign;
        config.get(POSITION, "arm_valign", WidgetAligns.VAlign.BOTTOM.name(), "Armor HUD vertical alignment\nValid values: [" + validValign[0] + ", " + validValign[1] + ", " + validValign[2] + "]", validValign).set(armValign.name());
        config.save();
    }

    public static int getxArmPos() {
        return xArmPos;
    }

    public static void setxArmPos(int xArmPos) {
        InvConfig.xArmPos = xArmPos;
        config.get(POSITION, "x_arm_pos", 0, "Armor HUD X position according alignments", -9999, 9999).set(xArmPos);
        config.save();
    }

    public static int getyArmPos() {
        return yArmPos;
    }

    public static void setyArmPos(int yArmPos) {
        InvConfig.yArmPos = yArmPos;
        config.get(POSITION, "y_arm_pos", 70, "Armor HUD Y position according alignments", -9999, 9999).set(yArmPos);
        config.save();
    }

    public static int getArmAbove() {
        return armAbove;
    }

    public static void setArmAbove(int armAbove) {
        InvConfig.armAbove = armAbove;
        config.get(ARMOR, "arm_above", 100, "Hide armor if its durability higher than this value in percentage", 0, 100).set(armAbove);
        config.save();
    }

    public static ArmorView getArmView() {
        return armView;
    }

    public static void setArmView(ArmorView armView) {
        InvConfig.armView = armView;
        config.get(ARMOR, "arm_view", ArmorView.PERCENTAGE.name(), "Armor durability in percentage, current damage or damage left\nValid values: [" + validArmViews[0] + ", " + validArmViews[1] + ", " + validArmViews[2] + ", " + validArmViews[3] + "]", validArmViews).set(armView.name());
        config.save();
    }

    public static boolean isArmBars() {
        return armBars;
    }

    public static void setArmBars(boolean armBars) {
        InvConfig.armBars = armBars;
        config.get(ARMOR, "arm_bars", false, "Show or hide durability bar overlay").set(armBars);
        config.save();
    }

    static {
        invHud = true;
        invAlpha = 0;
        invVertical = false;
        invMini = false;
        potHud = false;
        potAlpha = 100;
        potMini = false;
        potGap = 0;
        armHud = false;
        armAbove = 100;
        armView = ArmorView.PERCENTAGE;
        armBars = false;
        moveAll = true;
        showEmpty = true;
        showArmor = true;
        showMain = true;
        showArrows = true;
        showInv = true;
        xInvPos = 0;
        yInvPos = 150;
        xPotPos = 20;
        yPotPos = 20;
        xArmPos = 0;
        yArmPos = 70;
        armHalign = WidgetAligns.HAlign.MIDDLE;
        armValign = WidgetAligns.VAlign.BOTTOM;
        potHalign = WidgetAligns.HAlign.LEFT;
        potValign = WidgetAligns.VAlign.TOP;
        invHalign = WidgetAligns.HAlign.MIDDLE;
        invValign = WidgetAligns.VAlign.BOTTOM;
        helmX = 103;
        helmY = 54;
        chestX = 103;
        chestY = 37;
        legX = -103;
        legY = 54;
        bootsX = -103;
        bootsY = 37;
        mainX = 103;
        mainY = 71;
        arrX = 103;
        arrY = 20;
        invX = -103;
        invY = 20;
        helmHal = WidgetAligns.HAlign.MIDDLE;
        chestHal = WidgetAligns.HAlign.MIDDLE;
        legHal = WidgetAligns.HAlign.MIDDLE;
        bootsHal = WidgetAligns.HAlign.MIDDLE;
        mainHal = WidgetAligns.HAlign.MIDDLE;
        arrHal = WidgetAligns.HAlign.MIDDLE;
        invHal = WidgetAligns.HAlign.MIDDLE;
        helmVal = WidgetAligns.VAlign.BOTTOM;
        chestVal = WidgetAligns.VAlign.BOTTOM;
        legVal = WidgetAligns.VAlign.BOTTOM;
        bootsVal = WidgetAligns.VAlign.BOTTOM;
        mainVal = WidgetAligns.VAlign.BOTTOM;
        arrVal = WidgetAligns.VAlign.BOTTOM;
        invVal = WidgetAligns.VAlign.BOTTOM;
        validArmViews = new String[]{"PERCENTAGE", "DAMAGE", "DAMAGELEFT", "OFF"};
        validHalign = new String[]{"LEFT", "MIDDLE", "RIGHT"};
        validValign = new String[]{"TOP", "CENTER", "BOTTOM"};
    }

    public static enum ArmorView {
        PERCENTAGE,
        DAMAGE,
        DAMAGELEFT,
        OFF;

    }
}

