/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryGui
extends GuiIngame {
    public static final ResourceLocation INVENTORY_BACKGROUND = new ResourceLocation("textures/gui/container/inventory.png");
    private final RenderItem itemRenderer;
    private final FontRenderer fontRenderer;
    private final Minecraft minecraft;
    public static int invX;
    public static int invY;
    public static int potX;
    public static int potY;
    public static int armX;
    public static int armY;
    public static WidgetAligns InvAligns;
    public static WidgetAligns PotAligns;
    public static WidgetAligns ArmAligns;
    public static int potSide;
    public static int potVert;
    public static int potIconSide;
    public static int potTextSide;
    public static int armAbove;
    public static float potAlpha;
    public static int potGap;
    public static boolean potMini;
    public static boolean invMini;
    public static boolean invVert;
    public static float invAlpha;
    public static boolean showArmor;
    public static boolean showMain;
    public static boolean showOff;
    public static boolean showArrows;
    public static boolean showInv;
    public static boolean moveAll;
    public static boolean showEmpty;
    public static EachItem[] items;
    public static InvConfig.ArmorView armView;
    public static boolean armBars;
    private static ResourceLocation[] armorRL;
    private final int[][] armorPosX = new int[][]{{119, 119, -136, -136, -136, 119, -136}, {94, 94, -119, -119, -119, 94, -119}};
    private final int[] armorPosY = new int[]{-38, -56, -38, -56, -74, -20, -20};
    private static final ResourceLocation PBG;
    private static final ResourceLocation PBGM;
    private static final ResourceLocation PMT;
    private static final ResourceLocation INVBG;

    public static void syncConfig() {
        int height = new ScaledResolution(Minecraft.func_71410_x()).func_78328_b();
        invX = InvConfig.getxInvPos();
        invY = InvConfig.getyInvPos();
        potX = InvConfig.getxPotPos();
        potY = InvConfig.getyPotPos();
        armX = InvConfig.getxArmPos();
        armY = InvConfig.getyArmPos();
        InvAligns = new WidgetAligns(InvConfig.getInvHalign(), InvConfig.getInvValign());
        PotAligns = new WidgetAligns(InvConfig.getPotHalign(), InvConfig.getPotValign());
        ArmAligns = new WidgetAligns(InvConfig.getArmHalign(), InvConfig.getArmValign());
        potMini = InvConfig.isPotMini();
        invMini = InvConfig.isInvMini();
        invVert = InvConfig.isInvVertical();
        InventoryGui.PotPosChanged();
        switch (InventoryGui.PotAligns.VertAlign) {
            case TOP: {
                potVert = 1;
                break;
            }
            case CENTER: {
                if (potY - 12 < height / 2) {
                    potVert = -1;
                    break;
                }
                potVert = 1;
                break;
            }
            case BOTTOM: {
                potVert = -1;
            }
        }
        armAbove = InvConfig.getArmAbove();
        potAlpha = (float)InvConfig.getPotAlpha() / 100.0f;
        potGap = InvConfig.getPotGap();
        armView = InvConfig.getArmView();
        armBars = InvConfig.isArmBars();
        invAlpha = (float)InvConfig.getInvAlpha() / 100.0f;
        moveAll = InvConfig.getMoveAll();
        showArmor = InvConfig.isShowArmor();
        showMain = InvConfig.isShowMain();
        showArrows = InvConfig.isShowArrows();
        showInv = InvConfig.isShowInv();
        showEmpty = InvConfig.isShowEmpty();
        InventoryGui.items[0] = new EachItem(InvConfig.getHelmX(), InvConfig.getHelmY(), new WidgetAligns(InvConfig.getHelmHal(), InvConfig.getHelmVal()));
        InventoryGui.items[1] = new EachItem(InvConfig.getChestX(), InvConfig.getChestY(), new WidgetAligns(InvConfig.getChestHal(), InvConfig.getChestVal()));
        InventoryGui.items[2] = new EachItem(InvConfig.getLegX(), InvConfig.getLegY(), new WidgetAligns(InvConfig.getLegHal(), InvConfig.getLegVal()));
        InventoryGui.items[3] = new EachItem(InvConfig.getBootsX(), InvConfig.getBootsY(), new WidgetAligns(InvConfig.getBootsHal(), InvConfig.getBootsVal()));
        InventoryGui.items[4] = new EachItem(InvConfig.getMainX(), InvConfig.getMainY(), new WidgetAligns(InvConfig.getMainHal(), InvConfig.getMainVal()));
        InventoryGui.items[5] = new EachItem(InvConfig.getInvX(), InvConfig.getInvY(), new WidgetAligns(InvConfig.getInvHalign(), InvConfig.getInvVal()));
        InventoryGui.items[6] = new EachItem(InvConfig.getArrX(), InvConfig.getArrY(), new WidgetAligns(InvConfig.getArrHal(), InvConfig.getArrVal()));
    }

    @SideOnly(value=Side.CLIENT)
    public InventoryGui() {
        super(Minecraft.func_71410_x());
        this.minecraft = Minecraft.func_71410_x();
        this.itemRenderer = this.minecraft.func_175599_af();
        this.fontRenderer = this.minecraft.field_71466_p;
        InventoryGui.syncConfig();
    }

    @SubscribeEvent
    public void onRenderGui(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        GuiIngameForge.renderExperiance = true;
        ScaledResolution scaled = new ScaledResolution(this.minecraft);
        int width = scaled.func_78326_a();
        int height = scaled.func_78328_b();
        if (InventoryHUD.armorHUD) {
            if (moveAll) {
                this.RenderArmorStatus(width, height);
            } else {
                this.RenderEachArmor(width, height);
            }
        }
        if (InventoryHUD.potionHUD) {
            this.RenderPotions(width, height);
        }
        if (!InventoryHUD.isActive) {
            return;
        }
        if (this.field_73839_d.field_71462_r != null) {
            return;
        }
        this.RenderInventory(width, height);
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
    }

    private void RenderInventory(int width, int height) {
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        double scale = invMini ? 0.75 : 1.0;
        int px = this.getX(width, (int)((double)(iMax * 18 - 2) * scale), invX, InventoryGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((double)(jMax * 18 - 2) * scale), invY, InventoryGui.InvAligns.VertAlign);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)px, (float)py, (float)-320.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
        RenderHelper.func_74520_c();
        this.field_73839_d.func_110434_K().func_110577_a(INVBG);
        InventoryGui.func_146110_a((int)-2, (int)-2, (float)0.0f, (float)(jMax == 3 ? 0.0f : 56.0f), (int)(iMax * 18 + 2), (int)(jMax * 18 + 2), (float)256.0f, (float)256.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = this.field_73839_d.field_71439_g.field_71071_by.field_70462_a[index];
                this.itemRenderer.func_180450_b(item, i * 18, j * 18);
                this.itemRenderer.func_180453_a(this.fontRenderer, item, i * 18, j * 18, null);
            }
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private boolean isArrow(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151032_g);
    }

    private void renderElement(int x, int y, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay) {
        if (res != null) {
            this.field_73839_d.func_110434_K().func_110577_a(res);
            InventoryGui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        } else {
            RenderHelper.func_74520_c();
            this.itemRenderer.func_180450_b(item, x, y);
            if (overlay) {
                this.itemRenderer.func_180453_a(this.fontRenderer, item, x, y, null);
            }
            RenderHelper.func_74518_a();
        }
        if (text == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (right) {
            this.fontRenderer.func_175063_a(text, (float)(x + 17), (float)(y + 4), 0xFFFFFF);
        } else {
            this.fontRenderer.func_175063_a(text, (float)(x - 1 - this.fontRenderer.func_78256_a(text)), (float)(y + 4), 0xFFFFFF);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void RenderArmorStatus(int width, int height) {
        if (InventoryGui.ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && InventoryGui.ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-320.0f);
            ItemStack[] equip = new ItemStack[5];
            for (int j = 0; j < this.field_73839_d.field_71439_g.field_71071_by.field_70460_b.length; ++j) {
                equip[j] = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[j];
            }
            equip[4] = this.field_73839_d.field_71439_g.func_71045_bC();
            for (int i = 4; i >= 0; --i) {
                int yOff = 0;
                if (!showArmor) {
                    if (i < 4) continue;
                    yOff = 36;
                }
                if (!showMain && i == 4) continue;
                int xOff = 0;
                if (armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    xOff = i < 2 ? -19 : 19;
                }
                int Damage = ArmorStatus.GetDamage(equip[i]);
                String text = null;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (Damage >= 0 && Damage <= armAbove) {
                    if (!armView.equals((Object)InvConfig.ArmorView.OFF)) {
                        switch (armView) {
                            case PERCENTAGE: {
                                text = this.getDamageText(String.valueOf(Damage), Damage);
                                break;
                            }
                            case DAMAGE: {
                                text = this.getDamageText(String.valueOf(equip[i].func_77952_i()), Damage);
                                break;
                            }
                            case DAMAGELEFT: {
                                text = this.getDamageText(String.valueOf(equip[i].func_77958_k() - equip[i].func_77952_i()), Damage);
                            }
                        }
                    }
                    this.renderElement(width / 2 + this.armorPosX[0][i] + xOff, height + this.armorPosY[i] + yOff, i > 1, null, equip[i], text, armBars);
                    continue;
                }
                if (Damage == -2 && armAbove == 100) {
                    this.renderElement(width / 2 + this.armorPosX[0][i] + xOff, height + this.armorPosY[i] + yOff, i > 1, null, equip[i], null, true);
                    continue;
                }
                if (!showEmpty) continue;
                this.renderElement(width / 2 + this.armorPosX[0][i] + xOff, height + this.armorPosY[i] + yOff, i > 1, armorRL[i], null, null, false);
            }
            if (showInv || showArrows) {
                int count = 0;
                int arrows = 0;
                for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                    if (slot == null) {
                        ++count;
                        continue;
                    }
                    if (!this.isArrow(slot)) continue;
                    arrows += slot.field_77994_a;
                }
                if (showInv) {
                    if (armView.equals((Object)InvConfig.ArmorView.OFF)) {
                        this.renderElement(width / 2 + this.armorPosX[0][5] - 19, height + this.armorPosY[5], true, armorRL[5], null, count + "", false);
                    } else {
                        this.renderElement(width / 2 + this.armorPosX[0][5], height + this.armorPosY[5], false, armorRL[5], null, count + "", false);
                    }
                }
                if (showArrows) {
                    if (armView.equals((Object)InvConfig.ArmorView.OFF)) {
                        this.renderElement(width / 2 + this.armorPosX[0][6] + 19, height + this.armorPosY[6], false, armorRL[6], null, arrows + "", false);
                    } else {
                        this.renderElement(width / 2 + this.armorPosX[0][6], height + this.armorPosY[6], true, armorRL[6], null, arrows + "", false);
                    }
                }
            }
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            int x = this.getX(width, 90, armX, InventoryGui.ArmAligns.HorAlign);
            int y = this.getY(height, 70, armY, InventoryGui.ArmAligns.VertAlign);
            boolean right = this.getRight(armX, InventoryGui.ArmAligns.HorAlign);
            GlStateManager.func_179109_b((float)x, (float)y, (float)-320.0f);
            this.RenderItems(0, 0, right);
            GlStateManager.func_179121_F();
        }
    }

    private void RenderItems(int xpos, int ypos, boolean right) {
        int xOffsetT = right ? 75 : 0;
        ItemStack[] equip = new ItemStack[5];
        for (int j = 0; j < this.field_73839_d.field_71439_g.field_71071_by.field_70460_b.length; ++j) {
            equip[j] = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[3 - j];
        }
        equip[4] = this.field_73839_d.field_71439_g.func_71045_bC();
        for (int i = 4; i >= 0; --i) {
            if (!showMain && i == 4 || !showArmor && i < 4) continue;
            int yOffset = i % 4 * 18;
            int xOffset = xOffsetT;
            if (i > 3 && showArmor) {
                xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            int Damage = ArmorStatus.GetDamage(equip[i]);
            String text = null;
            if (Damage >= 0 && Damage <= armAbove) {
                if (!armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(equip[i].func_77952_i()), Damage);
                            break;
                        }
                        case DAMAGELEFT: {
                            text = this.getDamageText(String.valueOf(equip[i].func_77958_k() - equip[i].func_77952_i()), Damage);
                        }
                    }
                }
                this.renderElement(xpos + xOffset, ypos + yOffset, !right, null, equip[i], text, armBars);
                continue;
            }
            if (Damage == -2 && armAbove == 100) {
                this.renderElement(xpos + xOffset, ypos + yOffset, !right, null, equip[i], null, true);
                continue;
            }
            if (!showEmpty) continue;
            this.renderElement(xpos + xOffset, ypos + yOffset, !right, armorRL[i], null, null, false);
        }
        if (showArrows || showInv) {
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                if (slot == null) {
                    ++count;
                    continue;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.field_77994_a;
            }
            int xOffset = xOffsetT;
            int yOffset = 36;
            if (showArmor) {
                int n = xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            if (!showMain) {
                yOffset -= 18;
            }
            if (!showOff) {
                yOffset -= 18;
            }
            if (showInv) {
                this.renderElement(xpos + xOffset, ypos + yOffset, !right, armorRL[5], null, "" + count, false);
                yOffset += 18;
            }
            if (showArrows) {
                this.renderElement(xpos + xOffset, ypos + yOffset, !right, armorRL[6], null, "" + arrows, false);
            }
        }
    }

    private void RenderEachArmor(int width, int height) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-320.0f);
        ItemStack[] equip = new ItemStack[5];
        for (int j = 0; j < this.field_73839_d.field_71439_g.field_71071_by.field_70460_b.length; ++j) {
            equip[j] = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[3 - j];
        }
        equip[4] = this.field_73839_d.field_71439_g.func_71045_bC();
        for (int i = 4; i >= 0; --i) {
            if (!showMain && i == 4 || !showArmor && i < 4) continue;
            int x = this.getX(width, 16, InventoryGui.items[i].x, InventoryGui.items[i].aligns.HorAlign);
            int y = this.getY(height, 16, InventoryGui.items[i].y, InventoryGui.items[i].aligns.VertAlign);
            int right = this.getRight(InventoryGui.items[i].x, InventoryGui.items[i].aligns.HorAlign) ? 1 : 0;
            int Damage = ArmorStatus.GetDamage(equip[i]);
            String text = null;
            if (Damage >= 0 && Damage <= armAbove) {
                if (!armView.equals((Object)InvConfig.ArmorView.OFF)) {
                    switch (armView) {
                        case PERCENTAGE: {
                            text = this.getDamageText(String.valueOf(Damage), Damage);
                            break;
                        }
                        case DAMAGE: {
                            text = this.getDamageText(String.valueOf(equip[i].func_77952_i()), Damage);
                            break;
                        }
                        case DAMAGELEFT: {
                            text = this.getDamageText(String.valueOf(equip[i].func_77958_k() - equip[i].func_77952_i()), Damage);
                        }
                    }
                }
                this.renderElement(x, y, right == 0, null, equip[i], text, armBars);
                continue;
            }
            if (Damage == -2 && armAbove == 100) {
                this.renderElement(x, y, right == 0, null, equip[i], null, true);
                continue;
            }
            if (!showEmpty) continue;
            this.renderElement(x, y, right == 0, armorRL[i], null, null, false);
        }
        if (showArrows || showInv) {
            boolean right;
            int y;
            int count = 0;
            int arrows = 0;
            for (ItemStack slot : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
                if (slot == null) {
                    ++count;
                    continue;
                }
                if (!this.isArrow(slot)) continue;
                arrows += slot.field_77994_a;
            }
            if (showInv) {
                int x = this.getX(width, 16, InventoryGui.items[5].x, InventoryGui.items[5].aligns.HorAlign);
                y = this.getY(height, 16, InventoryGui.items[5].y, InventoryGui.items[5].aligns.VertAlign);
                right = this.getRight(InventoryGui.items[5].x, InventoryGui.items[5].aligns.HorAlign);
                this.renderElement(x, y, !right, armorRL[5], null, "" + count, false);
            }
            if (showArrows) {
                int x = this.getX(width, 16, InventoryGui.items[6].x, InventoryGui.items[6].aligns.HorAlign);
                y = this.getY(height, 16, InventoryGui.items[6].y, InventoryGui.items[6].aligns.VertAlign);
                right = this.getRight(InventoryGui.items[6].x, InventoryGui.items[6].aligns.HorAlign);
                this.renderElement(x, y, !right, armorRL[6], null, "" + arrows, false);
            }
        }
        GlStateManager.func_179121_F();
    }

    private String getDamageText(String p, int d) {
        String result = p;
        if (d == 100) {
            result = ChatFormatting.GREEN + result;
        } else if (d < 1) {
            result = ChatFormatting.DARK_RED + result;
        } else if (d <= 10) {
            result = ChatFormatting.RED + result;
        } else if (d <= 25) {
            result = ChatFormatting.GOLD + result;
        } else if (d <= 50) {
            result = ChatFormatting.YELLOW + result;
        }
        if (armView == InvConfig.ArmorView.PERCENTAGE) {
            result = result + ChatFormatting.WHITE + "%";
        }
        return result;
    }

    private void RenderPotions(int width, int height) {
        int y = 0;
        int effCount = this.field_73839_d.field_71439_g.func_70651_bq().size();
        if (effCount == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-90.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        int xPos = 0;
        int yPos = 0;
        switch (InventoryGui.PotAligns.HorAlign) {
            case LEFT: {
                xPos = potX;
                break;
            }
            case MIDDLE: {
                if (!potMini) {
                    xPos = width / 2 - 30 - potX;
                    break;
                }
                if (potX > 0) {
                    xPos = width / 2 - potX;
                    break;
                }
                if (potX < 0) {
                    xPos = width / 2 - 22 - potX;
                    break;
                }
                xPos = width / 2 - 11 - potX;
                break;
            }
            case RIGHT: {
                xPos = !potMini ? width - potX : width - potX + 23;
            }
        }
        switch (InventoryGui.PotAligns.VertAlign) {
            case TOP: {
                yPos = potY;
                break;
            }
            case CENTER: {
                if (!potMini) {
                    if (potY > 0) {
                        yPos = height / 2 - 12 - potY;
                        break;
                    }
                    if (potY < 0) {
                        yPos = height / 2 - 12 - (effCount - 1) * (24 + potGap) - potY;
                        break;
                    }
                    yPos = (int)((float)(height / 2 - 12) - (float)(effCount - 1) * ((float)potGap / 2.0f + 12.0f) - (float)potY);
                    break;
                }
                if (potY > 0) {
                    yPos = height / 2 - 9 - potY;
                    break;
                }
                if (potY < 0) {
                    yPos = height / 2 - 9 - (effCount - 1) * (18 + potGap) - potY;
                    break;
                }
                yPos = (int)((float)(height / 2 - 9) - (float)(effCount - 1) * ((float)potGap / 2.0f + 9.0f) - (float)potY);
                break;
            }
            case BOTTOM: {
                yPos = !potMini ? height - potY - (effCount - 1) * (potGap + 24) : height - potY - (effCount - 1) * (potGap + 18);
            }
        }
        for (PotionEffect effect : this.field_73839_d.field_71439_g.func_70651_bq()) {
            Potion pot = Potion.field_76425_a[effect.func_76456_a()];
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)potAlpha);
            if (!potMini) {
                this.field_73839_d.func_110434_K().func_110577_a(PBG);
                InventoryGui.func_146110_a((int)xPos, (int)(yPos + y), (float)0.0f, (float)0.0f, (int)60, (int)24, (float)(60 * potSide), (float)24.0f);
            } else {
                this.field_73839_d.func_110434_K().func_110577_a(PBGM);
                InventoryGui.func_146110_a((int)xPos, (int)(yPos + y), (float)0.0f, (float)0.0f, (int)22, (int)18, (float)(22 * potSide), (float)18.0f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int index = pot.func_76392_e();
            this.field_73839_d.func_110434_K().func_110577_a(INVENTORY_BACKGROUND);
            if (!potMini) {
                InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 18), (float)(198 + index / 8 * 18), (int)18, (int)18, (float)256.0f, (float)256.0f);
            } else {
                InventoryGui.func_146110_a((int)(xPos + 3 + potIconSide), (int)(yPos + y + 3), (float)(index % 8 * 12), (float)(132.0f + (float)(index / 8 * 12)), (int)12, (int)12, (float)170.66667f, (float)170.66667f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceLocation lev = effect.func_76458_c() < 9 && effect.func_76458_c() >= 0 ? new ResourceLocation("inventoryhud", "textures/gui/l_" + effect.func_76458_c() + ".png") : new ResourceLocation("inventoryhud", "textures/gui/l_inf.png");
            this.field_73839_d.func_110434_K().func_110577_a(lev);
            if (!potMini) {
                InventoryGui.func_146110_a((int)(xPos + 15 + potIconSide), (int)(yPos + y), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
            } else {
                InventoryGui.func_146110_a((int)(xPos + 9 + potIconSide), (int)(yPos + y), (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
            }
            String time = "";
            int dur = effect.func_76459_b() / 20;
            if (!potMini) {
                if (dur > 1600) {
                    time = " **:**";
                } else {
                    String mins = dur / 60 + "";
                    String secs = dur % 60 + "";
                    if (dur / 60 < 10) {
                        mins = "0" + mins;
                    }
                    if (dur % 60 < 10) {
                        secs = "0" + secs;
                    }
                    time = dur > 10 ? mins + ":" + secs : ChatFormatting.RED + mins + ChatFormatting.WHITE + ":" + ChatFormatting.RED + secs;
                }
                this.fontRenderer.func_175063_a(time, (float)(xPos + 28 + potTextSide), (float)(yPos + y + 8), 0xFFFFFF);
                y += 24 + potGap;
                continue;
            }
            int ysize = 12;
            this.field_73839_d.func_110434_K().func_110577_a(PMT);
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            if (dur < 300) {
                float r = 1.0f;
                float g = 1.0f;
                ysize = dur / 25 + 1;
                if (dur < 150) {
                    g = 0.006666667f * (float)dur;
                } else {
                    r = 0.006666667f * (float)(300 - dur);
                }
                GlStateManager.func_179131_c((float)r, (float)g, (float)0.0f, (float)1.0f);
            }
            InventoryGui.func_146110_a((int)(xPos + 17 + potTextSide), (int)(yPos + y + 15 - ysize), (float)0.0f, (float)0.0f, (int)3, (int)ysize, (float)3.0f, (float)ysize);
            y += 18 + potGap;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void PotPosChanged() {
        switch (InventoryGui.PotAligns.HorAlign) {
            case RIGHT: {
                if (!potMini) {
                    potSide = -1;
                    potIconSide = 36;
                    potTextSide = -22;
                    break;
                }
                potSide = -1;
                potIconSide = 4;
                potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (potX > 0) {
                    if (!potMini) {
                        potSide = -1;
                        potIconSide = 36;
                        potTextSide = -22;
                        break;
                    }
                    potSide = -1;
                    potIconSide = 4;
                    potTextSide = -15;
                    break;
                }
                potSide = 1;
                potIconSide = 0;
                potTextSide = 0;
                break;
            }
            case LEFT: {
                potSide = 1;
                potIconSide = 0;
                potTextSide = 0;
            }
        }
    }

    private boolean getRight(int x, WidgetAligns.HAlign hal) {
        switch (hal) {
            case LEFT: {
                return false;
            }
            case MIDDLE: {
                return x > 0;
            }
            case RIGHT: {
                return true;
            }
        }
        return false;
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = x;
                break;
            }
            case MIDDLE: {
                result = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result = 0;
        switch (val) {
            case TOP: {
                result = y;
                break;
            }
            case CENTER: {
                result = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public static void PotPosYChanged(boolean top) {
        potVert = top ? 1 : -1;
    }

    static {
        potIconSide = 36;
        potTextSide = -22;
        armAbove = 100;
        potAlpha = 1.0f;
        potGap = 0;
        items = new EachItem[7];
        armorRL = new ResourceLocation[]{new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_helmet.png"), new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_chestplate.png"), new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_leggings.png"), new ResourceLocation("inventoryhud", "textures/items/empty_armor_slot_boots.png"), new ResourceLocation("inventoryhud", "textures/items/empty_main_hand_slot.png"), new ResourceLocation("inventoryhud", "textures/items/inventory.png"), new ResourceLocation("inventoryhud", "textures/items/arrows.png")};
        PBG = new ResourceLocation("inventoryhud", "textures/gui/potion_bg.png");
        PBGM = new ResourceLocation("inventoryhud", "textures/gui/potion_bg_mini.png");
        PMT = new ResourceLocation("inventoryhud", "textures/gui/potminitime.png");
        INVBG = new ResourceLocation("inventoryhud", "textures/gui/inv_bg.png");
    }
}

