/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import com.mojang.realmsclient.gui.ChatFormatting;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CheckBox;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.util.ResourceLocation;

public class ArmorConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton ViewBtn;
    private CustomButton BarsBtn;
    private CustomButton MoveAllBtn;
    private CustomButton ShowEmpty;
    private NumericTextField AboveField;

    public ArmorConfigScreen(boolean inGame) {
        super(1, inGame);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String toggle = InvConfig.isArmHud() ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, toggle, new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                ArmorConfigScreen.this.ToggleSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.AboveField = new NumericTextField(0, this.field_146289_q, this.field_146294_l / 2 + 20, 0, 40, 20, 0, 100, InvConfig.getArmAbove(), new NumericTextField.IChangeble(){

            @Override
            public void onChanged(NumericTextField w) {
                ArmorConfigScreen.this.AboveChanged();
            }
        });
        this.OptionList.addWidget(this.AboveField, 1);
        this.OptionList.addWidget(new CheckBox(this.field_146294_l / 2 + 20, 0, 20, 20, new CheckBox.IPressable(){

            @Override
            public void onChanged(CheckBox cb) {
                ArmorConfigScreen.this.TypeArmorChanged(cb);
            }
        }, InvConfig.isShowArmor(), new ResourceLocation("inventoryhud", "textures/gui/cb_arm.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_146294_l / 2 + 42, 0, 20, 20, new CheckBox.IPressable(){

            @Override
            public void onChanged(CheckBox cb) {
                ArmorConfigScreen.this.TypeMainHandChanged(cb);
            }
        }, InvConfig.isShowMain(), new ResourceLocation("inventoryhud", "textures/gui/cb_mh.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_146294_l / 2 + 64, 0, 20, 20, new CheckBox.IPressable(){

            @Override
            public void onChanged(CheckBox cb) {
                ArmorConfigScreen.this.TypeArrowChanged(cb);
            }
        }, InvConfig.isShowArrows(), new ResourceLocation("inventoryhud", "textures/gui/cb_ar.png")), 2);
        this.OptionList.addWidget(new CheckBox(this.field_146294_l / 2 + 86, 0, 20, 20, new CheckBox.IPressable(){

            @Override
            public void onChanged(CheckBox cb) {
                ArmorConfigScreen.this.TypeInvChanged(cb);
            }
        }, InvConfig.isShowInv(), new ResourceLocation("inventoryhud", "textures/gui/cb_inv.png")), 2);
        this.ViewBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 75, 20, InvConfig.getArmView().name(), new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                ArmorConfigScreen.this.ViewSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.ViewBtn, 3);
        this.BarsBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, InvConfig.isArmBars() + "", new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                ArmorConfigScreen.this.BarsSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.BarsBtn, 4);
        this.MoveAllBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, InvConfig.getMoveAll() + "", new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                ArmorConfigScreen.this.MoveSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.MoveAllBtn, 5);
        this.ShowEmpty = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, InvConfig.isShowEmpty() + "", new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                ArmorConfigScreen.this.EmptySwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.ShowEmpty, 6);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_EMPTY.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146279_a(Translation.ARM_EMPTY_TT.func_150260_c(), x, y);
            }
        }), 6);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_MOVE.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146283_a(Translation.getStringList(Translation.ARM_MOVE_TT), x, y);
            }
        }), 5);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_BARS.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146279_a(Translation.ARM_BARS_TT.func_150260_c(), x, y);
            }
        }), 4);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_VIEW.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146283_a(Translation.getStringList(Translation.ARM_VIEW_TT), x, y);
            }
        }), 3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TYPE.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146279_a(Translation.ARM_TYPE_TT.func_150260_c(), x, y);
            }
        }), 2);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_HIDE.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146279_a(Translation.ARM_HIDE_TT.func_150260_c(), x, y);
            }
        }), 1);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.ARM_TOGGLE.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                ArmorConfigScreen.this.func_146279_a(Translation.ARM_TOGGLE_TT.func_150260_c(), x, y);
            }
        }), 0);
        this.AboveField.setMaxStringLength(5);
    }

    private void TypeArmorChanged(CheckBox cb) {
        InventoryGui.showArmor = cb.checked;
        InvConfig.setShowArmor(cb.checked);
    }

    private void TypeMainHandChanged(CheckBox cb) {
        InventoryGui.showMain = cb.checked;
        InvConfig.setShowMain(cb.checked);
    }

    private void TypeArrowChanged(CheckBox cb) {
        InventoryGui.showArrows = cb.checked;
        InvConfig.setShowArrows(cb.checked);
    }

    private void TypeInvChanged(CheckBox cb) {
        InventoryGui.showInv = cb.checked;
        InvConfig.setShowInv(cb.checked);
    }

    private void AboveChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AboveField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.armAbove = a;
        InvConfig.setArmAbove(a);
    }

    private void MoveSwitch() {
        boolean bd;
        InventoryGui.moveAll = bd = !InvConfig.getMoveAll();
        InvConfig.setMoveAll(bd);
        this.MoveAllBtn.setMessage(Boolean.toString(bd));
    }

    private void EmptySwitch() {
        boolean bd;
        InventoryGui.showEmpty = bd = !InvConfig.isShowEmpty();
        InvConfig.setShowEmpty(bd);
        this.ShowEmpty.setMessage(Boolean.toString(bd));
    }

    private void ViewSwitch() {
        InvConfig.ArmorView at = InvConfig.getArmView();
        switch (at) {
            case PERCENTAGE: {
                at = InvConfig.ArmorView.DAMAGE;
                break;
            }
            case DAMAGE: {
                at = InvConfig.ArmorView.DAMAGELEFT;
                break;
            }
            case DAMAGELEFT: {
                at = InvConfig.ArmorView.OFF;
                break;
            }
            case OFF: {
                at = InvConfig.ArmorView.PERCENTAGE;
            }
        }
        InventoryGui.armView = at;
        InvConfig.setArmView(at);
        this.ViewBtn.setMessage(at.name());
    }

    private void ToggleSwitch() {
        boolean armor;
        InventoryHUD.armorHUD = armor = !InvConfig.isArmHud();
        InvConfig.setArmHud(armor);
        String armString = armor ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(armString);
    }

    private void BarsSwitch() {
        boolean bars;
        InventoryGui.armBars = bars = !InvConfig.isArmBars();
        InvConfig.setArmBars(bars);
        this.BarsBtn.setMessage(Boolean.toString(bars));
    }
}

