/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import com.mojang.realmsclient.gui.ChatFormatting;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;

public class InventoryConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private CustomButton VerticalModeBtn;
    private NumericTextField AlphaField;

    public InventoryConfigScreen(boolean inGame) {
        super(0, inGame);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String toggle = InvConfig.isInvHud() ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, toggle, new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                InventoryConfigScreen.this.ToggleSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.MiniModeBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, InvConfig.isInvMini() + "", new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                InventoryConfigScreen.this.MiniModeSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        this.VerticalModeBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, InvConfig.isInvVertical() + "", new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                InventoryConfigScreen.this.VerticalModeSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.VerticalModeBtn, 1);
        this.AlphaField = new NumericTextField(0, this.field_146289_q, this.field_146294_l / 2 + 20, 0, 40, 20, 0, 100, InvConfig.getInvAlpha(), new NumericTextField.IChangeble(){

            @Override
            public void onChanged(NumericTextField tf) {
                InventoryConfigScreen.this.AlphaChanged();
            }
        });
        this.OptionList.addWidget(this.AlphaField, 3);
        this.AlphaField.setMaxStringLength(5);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_ALPHA.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                InventoryConfigScreen.this.func_146279_a(Translation.INV_ALPHA_TT.func_150260_c(), x, y);
            }
        }), 3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_MINI.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                InventoryConfigScreen.this.func_146279_a(Translation.INV_MINI_TT.func_150260_c(), x, y);
            }
        }), 2);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_VERT.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                InventoryConfigScreen.this.func_146283_a(Translation.getStringList(Translation.INV_VERT_TT), x, y);
            }
        }), 1);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.INV_TOGGLE.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                InventoryConfigScreen.this.func_146279_a(Translation.INV_TOGGLE_TT.func_150260_c(), x, y);
            }
        }), 0);
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.invAlpha = (float)a / 100.0f;
        InvConfig.setInvAlpha(a);
    }

    private void MiniModeSwitch() {
        boolean mm;
        InventoryGui.invMini = mm = !InvConfig.isInvMini();
        InvConfig.setInvMini(mm);
        this.MiniModeBtn.setMessage(Boolean.toString(mm));
    }

    private void VerticalModeSwitch() {
        boolean vm;
        InventoryGui.invVert = vm = !InvConfig.isInvVertical();
        InvConfig.setInvVertical(vm);
        this.VerticalModeBtn.setMessage(Boolean.toString(vm));
    }

    private void ToggleSwitch() {
        boolean bd;
        InventoryHUD.isActive = bd = !InvConfig.isInvHud();
        InvConfig.setInvHud(bd);
        String toggle = bd ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_GREEN + "ON";
        this.ToggleBtn.setMessage(toggle);
    }
}

