/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import com.mojang.realmsclient.gui.ChatFormatting;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.TextWidget;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.WidgetAligns;

public class PotionConfigScreen
extends ConfigScreen {
    private CustomButton ToggleBtn;
    private CustomButton MiniModeBtn;
    private NumericTextField AlphaField;
    private NumericTextField GapField;

    public PotionConfigScreen(boolean inGame) {
        super(2, inGame);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String toggle = InvConfig.isPotHud() ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, toggle, new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                PotionConfigScreen.this.ToggleSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.ToggleBtn, 0);
        this.MiniModeBtn = new CustomButton(this.field_146294_l / 2 + 20, 0, 40, 20, InvConfig.isPotMini() + "", new ButtonWidget.ButtonClickListener(){

            @Override
            public void onClick() {
                PotionConfigScreen.this.MiniModeSwitch();
            }
        }, null, false);
        this.OptionList.addWidget(this.MiniModeBtn, 2);
        this.AlphaField = new NumericTextField(0, this.field_146289_q, this.field_146294_l / 2 + 20, 0, 40, 20, 0, 100, InvConfig.getPotAlpha(), new NumericTextField.IChangeble(){

            @Override
            public void onChanged(NumericTextField tf) {
                PotionConfigScreen.this.AlphaChanged();
            }
        });
        this.OptionList.addWidget(this.AlphaField, 1);
        this.GapField = new NumericTextField(1, this.field_146289_q, this.field_146294_l / 2 + 20, 0, 40, 20, -5, 5, InvConfig.getPotGap(), new NumericTextField.IChangeble(){

            @Override
            public void onChanged(NumericTextField tf) {
                PotionConfigScreen.this.GapChanged();
            }
        });
        this.OptionList.addWidget(this.GapField, 3);
        this.AlphaField.setMaxStringLength(5);
        this.GapField.setMaxStringLength(3);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_TOGGLE.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                PotionConfigScreen.this.func_146279_a(Translation.POT_TOGGLE_TT.func_150260_c(), x, y);
            }
        }), 0);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_ALPHA.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                PotionConfigScreen.this.func_146279_a(Translation.POT_ALPHA_TT.func_150260_c(), x, y);
            }
        }), 1);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_MINI.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                PotionConfigScreen.this.func_146279_a(Translation.POT_MINI_TT.func_150260_c(), x, y);
            }
        }), 2);
        this.OptionList.addWidget(new TextWidget(this.field_146294_l / 2 - 20, 10, 0xFFFFFF, WidgetAligns.HAlign.RIGHT, Translation.POT_GAP.func_150260_c(), this.field_146289_q, new Widget.ITooltip(){

            @Override
            public void onTooltip(Widget w, int x, int y) {
                PotionConfigScreen.this.func_146279_a(Translation.POT_GAP_TT.func_150260_c(), x, y);
            }
        }), 3);
    }

    private void AlphaChanged() {
        int a;
        try {
            a = Integer.parseInt(this.AlphaField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.potAlpha = (float)a / 100.0f;
        InvConfig.setPotAlpha(a);
    }

    private void GapChanged() {
        int a;
        try {
            a = Integer.parseInt(this.GapField.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryGui.potGap = a;
        InvConfig.setPotGap(a);
    }

    private void ToggleSwitch() {
        boolean potion;
        InventoryHUD.potionHUD = potion = !InvConfig.isPotHud();
        InvConfig.setPotHud(potion);
        String toggle = potion ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        this.ToggleBtn.setMessage(toggle);
    }

    private void MiniModeSwitch() {
        boolean mini;
        InventoryGui.potMini = mini = !InvConfig.isPotMini();
        InvConfig.setPotMini(mini);
        this.MiniModeBtn.setMessage(Boolean.toString(mini));
        InventoryGui.PotPosChanged();
    }
}

