/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import dlovin.inventoryhud.gui.widgets.NumericTextField;
import dlovin.inventoryhud.gui.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class CustomOptionList
extends GuiListExtended {
    private static final int ITEM_HEIGHT = 30;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final GuiScreen parent;
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private int lX = 0;
    private int lY = 0;
    private final ResourceLocation SCROLL = new ResourceLocation("inventoryhud", "textures/gui/scroll.png");

    public CustomOptionList(Minecraft mcIn, GuiScreen screen) {
        super(mcIn, screen.field_146294_l, screen.field_146295_m, 55, screen.field_146295_m - 32, 30);
        this.parent = screen;
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * 30 + 10) {
            this.maxHeight = (row + 1) * 30 + 10;
        }
        widget.y = this.field_148153_b + 10 + 30 * row + widget.y;
        this.widgets.add(widget);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public boolean mouseScrolled(int p_231043_5_) {
        double tmp = 0.0;
        if (this.maxHeight > this.field_148154_c - this.field_148153_b) {
            tmp = p_231043_5_ * 2;
            int diff = this.maxHeight - (this.field_148154_c - this.field_148153_b);
            this.scroll = (int)((double)this.scroll - tmp);
            if (this.scroll < 0) {
                tmp += (double)this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp += (double)(this.scroll - diff);
                this.scroll = diff;
            }
        }
        for (Widget w : this.widgets) {
            if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                ((NumericTextField)w).setFocused(false);
            }
            w.y = (int)((double)w.y + tmp);
        }
        return true;
    }

    public boolean mouseDragged(int mx, int my) {
        if (this.isDragging) {
            int dX = mx - this.lX;
            int dY = my - this.lY;
            this.lX = mx;
            this.lY = my;
            int height = this.field_148154_c - this.field_148153_b;
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += (double)dY / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.field_148154_c - this.field_148153_b);
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            for (Widget w : this.widgets) {
                if (w instanceof NumericTextField && ((NumericTextField)w).isFocused()) {
                    ((NumericTextField)w).setFocused(false);
                }
                w.y -= tmp;
            }
            return true;
        }
        return false;
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    public boolean isMouseOver(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return p_isMouseOver_3_ >= (double)this.field_148153_b && p_isMouseOver_3_ <= (double)this.field_148154_c && p_isMouseOver_1_ >= (double)this.field_148152_e && p_isMouseOver_1_ <= (double)this.field_148151_d;
    }

    public boolean func_148179_a(int p_231044_1_, int p_231044_3_, int p_231044_5_) {
        if (!this.isMouseOver(p_231044_1_, p_231044_3_)) {
            return false;
        }
        if (this.maxHeight > this.field_148154_c - this.field_148153_b && p_231044_5_ == 0) {
            int pos = this.field_148155_a > 309 ? this.field_148155_a / 2 + 150 : this.field_148155_a - 9;
            int height = this.field_148154_c - this.field_148153_b;
            double scale = (double)height / (double)this.maxHeight;
            int yPos = this.field_148153_b + (int)((double)this.scroll * scale);
            if (this.isOver(p_231044_1_, p_231044_3_, pos + 1, pos + 8, yPos + 1, yPos + (height = (int)((double)height * scale)) - 1)) {
                this.lX = p_231044_1_;
                this.lY = p_231044_3_;
                this.isDragging = true;
            }
        }
        for (Widget w : this.widgets) {
            w.mousePressed(this.field_148161_k, p_231044_1_, p_231044_3_, p_231044_5_);
        }
        return false;
    }

    public boolean func_148181_b(int p_231048_1_, int p_231048_3_, int p_231048_5_) {
        this.isDragging = false;
        return false;
    }

    public boolean keyTyped(char p_231042_1_, int p_231042_2_) {
        for (Widget w : this.widgets) {
            if (!(w instanceof NumericTextField) || !((NumericTextField)w).isFocused() || !((NumericTextField)w).textboxKeyTyped(p_231042_1_, p_231042_2_)) continue;
            return true;
        }
        return false;
    }

    private void renderScrollBG(int xPos, int height) {
        CustomOptionList.drawScaledCustomSizeModalRect(xPos, this.field_148153_b, 0.0f, 0.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 6, this.field_148153_b, 13.0f, 0.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos, this.field_148154_c - 3, 0.0f, 13.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 6, this.field_148154_c - 3, 13.0f, 13.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 3, this.field_148153_b, 3.0f, 0.0f, 10, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 6, this.field_148153_b + 3, 13.0f, 3.0f, 3, 10, 3, height - 6, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 3, this.field_148154_c - 3, 3.0f, 13.0f, 10, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos, this.field_148153_b + 3, 0.0f, 3.0f, 3, 10, 3, height - 6, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 3, this.field_148153_b + 3, 3.0f, 3.0f, 10, 10, 3, height - 6, 32.0f, 32.0f);
    }

    private void renderScroll(int xPos, int height, int pos) {
        CustomOptionList.drawScaledCustomSizeModalRect(xPos, pos, 16.0f, 0.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 6, pos, 29.0f, 0.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos, -3 + height + pos, 16.0f, 13.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 6, -3 + height + pos, 29.0f, 13.0f, 3, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 3, pos, 19.0f, 0.0f, 10, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 6, 3 + pos, 29.0f, 3.0f, 3, 10, 3, height - 6 > 0 ? height - 6 : 0, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 3, -3 + height + pos, 19.0f, 13.0f, 10, 3, 3, 3, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos, 3 + pos, 16.0f, 3.0f, 3, 10, 3, height - 6 > 0 ? height - 6 : 0, 32.0f, 32.0f);
        CustomOptionList.drawScaledCustomSizeModalRect(xPos + 3, 3 + pos, 19.0f, 3.0f, 10, 10, 3, height - 6 > 0 ? height - 6 : 0, 32.0f, 32.0f);
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)(u * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)((u + (float)uWidth) * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)((u + (float)uWidth) * f), (double)(v * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void func_148120_b(int insideLeft, int insideTop, int mouseXIn, int mouseYIn) {
        if (this.maxHeight > this.field_148154_c - this.field_148153_b) {
            int pos = this.field_148155_a > 309 ? this.field_148155_a / 2 + 150 : this.field_148155_a - 9;
            this.field_148161_k.func_110434_K().func_110577_a(this.SCROLL);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            int height = this.field_148154_c - this.field_148153_b;
            this.renderScrollBG(pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.field_148153_b + (int)((double)this.scroll * scale);
            GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            if (this.isOver(mouseXIn, mouseYIn, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderScroll(pos, height, yPos);
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Widget w : this.widgets) {
            w.render(this.field_148161_k, mouseXIn, mouseYIn);
        }
    }

    public void renderTooltips(int mx, int my) {
        if (mx < this.field_148152_e || mx > this.field_148151_d || my < this.field_148153_b || my > this.field_148154_c) {
            return;
        }
        for (Widget w : this.widgets) {
            w.renderTooltip(mx, my);
        }
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return null;
    }

    protected int func_148127_b() {
        return 0;
    }
}

