/*
 * Decompiled with CFR 0.152.
 */
package me.aycy.onhitparticles.config;

import java.io.File;
import java.lang.reflect.Field;
import me.aycy.onhitparticles.config.Settings;
import me.aycy.onhitparticles.config.Value;
import me.aycy.onhitparticles.particle.Particle;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public abstract class Config {
    private final Configuration configFile = new Configuration(new File(Loader.instance().getConfigDir(), "onhitparticles.cfg"), true);

    Config() {
    }

    public void load() {
        try {
            this.configFile.load();
            for (Field field : this.getClass().getFields()) {
                if (!field.isAnnotationPresent(Value.class)) continue;
                if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                    field.set(this, this.configFile.get("client", field.getName(), false).getBoolean());
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(field.getType())) {
                    field.set(this, this.configFile.get("client", field.getName(), 1).getInt());
                    continue;
                }
                if (!String.class.isAssignableFrom(field.getType())) continue;
                field.set(this, this.configFile.get("client", field.getName(), "Critical").getString());
            }
            Settings.getInstance().meleeParticle = Particle.getParticle(Settings.getInstance().meleeParticleName);
            Settings.getInstance().rangedParticle = Particle.getParticle(Settings.getInstance().rangedParticleName);
            this.configFile.save();
        }
        catch (Exception exception) {
            FMLLog.log((Level)Level.ERROR, (String)"Error loading On-Hit Particles configuration!", (Object[])new Object[0]);
        }
    }

    public void save() {
        try {
            for (Field field : this.getClass().getFields()) {
                if (!field.isAnnotationPresent(Value.class)) continue;
                if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                    this.configFile.get("client", field.getName(), false).set(field.getBoolean(this));
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(field.getType())) {
                    this.configFile.get("client", field.getName(), 1).set(field.getInt(this));
                    continue;
                }
                if (!String.class.isAssignableFrom(field.getType())) continue;
                this.configFile.get("client", field.getName(), "Critical").set((String)field.get(this));
            }
            this.configFile.save();
        }
        catch (Exception exception) {
            FMLLog.log((Level)Level.ERROR, (String)"Error saving On-Hit Particles configuration!", (Object[])new Object[0]);
        }
    }
}

