/*
 * Decompiled with CFR 0.152.
 */
package me.aycy.onhitparticles.particle;

import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public enum Particle {
    VILLAGER_ANGRY("Angry Villager", 20, 8, 2.5f, true, new int[0]),
    BLOCK_CRACK("Blood", 37, 32, 1.2f, true, new int[]{Block.func_149682_b((Block)Blocks.field_150451_bX)}),
    SHOVEL("Cloud", 32, 16, 0.2f, new int[0]),
    REDSTONE("Confetti", 30, 16, 3.0f, true, new int[0]),
    CRIT("Critical", 9, 32, 1.0f, new int[0]),
    CRIT_AND_MAGIC("Crit/Magic Crit", -1, -1, -1.0f, new int[0]),
    ENCHANTMENT_TABLE("Enchantment", 25, 16, 1.0f, true, new int[0]),
    EXPLOSION_LARGE("Explosion", 1, 1, 1.0f, true, new int[0]),
    FLAME("Flame", 26, 16, 0.05f, new int[0]),
    VILLAGER_HAPPY("Happy Villager", 21, 16, 2.5f, true, new int[0]),
    HEART("Heart", 34, 8, 2.0f, true, new int[0]),
    SPELL_INSTANT("Instant Spell", 14, 16, 0.7f, new int[0]),
    LAVA("Lava", 27, 16, 1.0f, new int[0]),
    CRIT_MAGIC("Magic Critical", 10, 32, 1.0f, new int[0]),
    SPELL_MOB("Mob Spell", 15, 16, 1.0f, new int[0]),
    NOTE("Music Note", 23, 8, 3.0f, true, new int[0]),
    PORTAL("Portal", 24, 32, 1.0f, true, new int[0]),
    SLIME("Slime", 33, 16, 0.5f, new int[0]),
    SMOKE_NORMAL("Smoke", 11, 16, 0.08f, true, new int[0]),
    SNOWBALL("Snow", 31, 16, 1.0f, true, new int[0]),
    FIREWORKS_SPARK("Spark", 3, 16, 0.1f, new int[0]),
    SPELL("Spell", 13, 16, 1.0f, new int[0]),
    WATER_SPLASH("Splash", 5, 32, 1.0f, new int[0]),
    SPELL_WITCH("Witch", 17, 16, 0.5f, new int[0]);

    private static final Particle[] copy;
    private static final HashMap<String, Particle> PARTICLES;
    private final String name;
    private final int id;
    private final int count;
    private final float offset;
    private final boolean ignoreDistance;
    private final int[] args;

    private Particle(String name, int id, int count, float offset, int[] args) {
        this(name, id, count, offset, false, args);
    }

    private Particle(String name, int id, int count, float offset, boolean ignoreDistance, int[] args) {
        this.name = name;
        this.id = id;
        this.count = count;
        this.offset = offset;
        this.ignoreDistance = ignoreDistance;
        this.args = args;
    }

    public Particle getNext() {
        return copy[(this.ordinal() + 1) % copy.length];
    }

    public static Particle getParticle(String name) {
        return PARTICLES.get(name) != null ? PARTICLES.get(name) : CRIT;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean isIgnoreDistance() {
        return this.ignoreDistance;
    }

    public int[] getArgs() {
        return this.args;
    }

    static {
        copy = Particle.values();
        PARTICLES = new HashMap();
        Arrays.stream(Particle.values()).forEach(particle -> PARTICLES.put(particle.name, (Particle)((Object)particle)));
    }
}

